/*
 * Decompiled with CFR 0.152.
 */
package net.derfruhling.minecraft.create.trainperspective;

import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Objects;
import net.derfruhling.minecraft.create.trainperspective.ModConfig;
import net.derfruhling.minecraft.create.trainperspective.Perspective;
import net.derfruhling.minecraft.create.trainperspective.RotationState;
import net.minecraft.class_1297;

public class CreateTrainPerspectiveMod {
    public static final String MODID = "create_train_perspective";
    public static CreateTrainPerspectiveMod INSTANCE;

    public CreateTrainPerspectiveMod() {
        ClientTickEvent.CLIENT_PRE.register(instance -> ModConfig.tick());
        INSTANCE = this;
    }

    public void onEntityMountEvent(boolean isMounting, class_1297 entityMounting, class_1297 entityBeingMounted) {
        if (entityMounting instanceof Perspective) {
            Perspective persp = (Perspective)entityMounting;
            if (entityBeingMounted instanceof CarriageContraptionEntity) {
                CarriageContraptionEntity contraption = (CarriageContraptionEntity)entityBeingMounted;
                if (isMounting) {
                    this.onEntityMount(persp, contraption);
                } else {
                    this.onEntityDismount(persp);
                }
            }
        }
    }

    public void onEntityMount(Perspective persp, CarriageContraptionEntity contraption) {
        if (persp.getRotationState() == null) {
            RotationState state = new RotationState(contraption, false);
            persp.enable(contraption, state);
        } else {
            RotationState state = persp.getRotationState();
            state.onMounted();
        }
    }

    private void onEntityDismount(Perspective persp) {
        if (persp.getRotationState() != null) {
            persp.getRotationState().onDismount();
        }
    }

    public void tickStandingEntity(CarriageContraptionEntity contraption, class_1297 entity) {
        if (entity.method_5854() != null) {
            return;
        }
        if (!(entity instanceof Perspective)) {
            return;
        }
        Perspective persp = (Perspective)entity;
        RotationState state = persp.getRotationState();
        if (state == null || !Objects.equals(state.getContraption(), contraption)) {
            state = new RotationState(contraption, true);
            persp.enable(contraption, state);
        } else {
            state.update();
        }
    }

    private void tickPerspectiveState(class_1297 player, Perspective persp, RotationState state) {
        CarriageContraptionEntity carriage = state.getContraption();
        if (carriage == null) {
            return;
        }
        persp.setReference(carriage);
        player.method_36456(player.method_36454() + state.getYawDelta());
        player.method_5636(player.method_36454());
        if (state.isStanding() && !state.isSeated()) {
            state.tick();
            if (state.getTicksSinceLastUpdate() > 5) {
                state.stopTickingState();
            }
        }
    }

    public void tickEntity(class_1297 entity, Perspective persp) {
        if (persp.getRotationState() != null) {
            RotationState state = persp.getRotationState();
            assert (state != null);
            if (state.shouldTickState()) {
                this.tickPerspectiveState(entity, persp, state);
            } else {
                persp.diminish();
                if (persp.isDiminished()) {
                    persp.disable();
                }
            }
        }
    }
}

