/*
 * Decompiled with CFR 0.152.
 */
package net.derfruhling.minecraft.create.trainperspective;

import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import org.jetbrains.annotations.Nullable;

public class RotationState {
    private CarriageContraptionEntity contraption;
    private boolean isStandingState;
    private float lastRecordedYaw;
    private boolean shouldTickState = true;
    private int ticksSinceLastUpdate = 0;

    public RotationState(CarriageContraptionEntity contraption, boolean isStandingState) {
        this.contraption = contraption;
        this.lastRecordedYaw = contraption.yaw;
        this.isStandingState = isStandingState;
    }

    public float getYawDelta() {
        while (this.contraption.yaw - this.lastRecordedYaw < -180.0f) {
            this.lastRecordedYaw -= 360.0f;
        }
        while (this.contraption.yaw - this.lastRecordedYaw >= 180.0f) {
            this.lastRecordedYaw += 360.0f;
        }
        float rotation = this.contraption.yaw - this.lastRecordedYaw;
        this.lastRecordedYaw = this.contraption.yaw;
        return rotation;
    }

    @Nullable
    public CarriageContraptionEntity getContraption() {
        return this.contraption;
    }

    public boolean isStanding() {
        return this.isStandingState;
    }

    public boolean isSeated() {
        return !this.isStandingState;
    }

    public boolean shouldTickState() {
        return this.shouldTickState;
    }

    public void onMounted() {
        this.isStandingState = false;
        this.shouldTickState = true;
    }

    public void onDismount() {
        this.isStandingState = true;
    }

    public void stopTickingState() {
        if (!this.isStandingState) {
            throw new IllegalStateException("not a standing state");
        }
        this.shouldTickState = false;
    }

    public int getTicksSinceLastUpdate() {
        return this.ticksSinceLastUpdate;
    }

    void update() {
        this.ticksSinceLastUpdate = 0;
    }

    void tick() {
        ++this.ticksSinceLastUpdate;
    }
}

