/*
 * Decompiled with CFR 0.152.
 */
package net.derfruhling.minecraft.create.trainperspective.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import net.derfruhling.minecraft.create.trainperspective.Conditional;
import net.derfruhling.minecraft.create.trainperspective.CreateTrainPerspectiveMod;
import net.derfruhling.minecraft.create.trainperspective.MixinUtil;
import net.derfruhling.minecraft.create.trainperspective.Perspective;
import net.derfruhling.minecraft.create.trainperspective.RotationState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
@Implements(value={@Interface(iface=Perspective.class, prefix="ctp$")})
@Environment(value=EnvType.CLIENT)
public abstract class EntityMixin {
    @Shadow
    @Nullable
    private class_1297 field_6034;
    @Shadow
    private class_1937 field_6002;
    @Unique
    private boolean ctp$perspectiveActive = false;
    @Unique
    @Nullable
    private CarriageContraptionEntity ctp$reference = null;
    @Unique
    private float ctp$scale = 1.0f;
    @Unique
    private float ctp$prevScale = 1.0f;
    @Unique
    @Nullable
    private RotationState ctp$currentState = null;

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="RETURN", ordinal=4)})
    public void onMount(class_1297 entity, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        class_1297 self = (class_1297)this;
        if (Conditional.shouldApplyPerspectiveTo(self)) {
            CreateTrainPerspectiveMod.INSTANCE.onEntityMountEvent(true, self, entity);
        }
    }

    @Inject(method={"removeVehicle"}, at={@At(value="HEAD")})
    public void onDismount(CallbackInfo ci) {
        class_1297 self;
        if (this.field_6034 != null && Conditional.shouldApplyPerspectiveTo(self = (class_1297)this)) {
            CreateTrainPerspectiveMod.INSTANCE.onEntityMountEvent(false, self, this.field_6034);
        }
    }

    @ModifyVariable(method={"calculateViewVector"}, at=@At(value="LOAD"), index=1, argsOnly=true)
    public float modifyPitch(float pitch, @Local(argsOnly=true, index=2) float yaw) {
        if (this.field_6002.field_9236) {
            Perspective persp;
            class_1297 class_12972 = (class_1297)this;
            if (class_12972 instanceof Perspective && (persp = (Perspective)class_12972).isEnabled() && Conditional.shouldApplyPerspectiveTo((class_1297)this)) {
                return MixinUtil.applyDirectionXRotChange(persp, pitch, yaw, 1.0f);
            }
            return pitch;
        }
        return pitch;
    }

    @ModifyVariable(method={"calculateViewVector"}, at=@At(value="LOAD"), index=2, argsOnly=true)
    public float modifyYaw(float yaw, @Local(argsOnly=true, index=1) float pitch) {
        if (this.field_6002.field_9236) {
            Perspective persp;
            class_1297 class_12972 = (class_1297)this;
            if (class_12972 instanceof Perspective && (persp = (Perspective)class_12972).isEnabled() && Conditional.shouldApplyPerspectiveTo((class_1297)this)) {
                return yaw + MixinUtil.getExtraYRot(persp, pitch, yaw, 1.0f);
            }
            return yaw;
        }
        return yaw;
    }

    public void ctp$enable(CarriageContraptionEntity entity, RotationState state) {
        this.ctp$perspectiveActive = true;
        this.ctp$currentState = state;
        this.ctp$reference = entity;
        this.ctp$prevScale = 1.0f;
        this.ctp$scale = 1.0f;
    }

    public void ctp$disable() {
        this.ctp$perspectiveActive = false;
        this.ctp$currentState = null;
        this.ctp$reference = null;
        this.ctp$prevScale = 1.0f;
        this.ctp$scale = 1.0f;
    }

    public void ctp$setReference(CarriageContraptionEntity entity) {
        this.ctp$reference = entity;
        this.ctp$prevScale = this.ctp$scale;
        this.ctp$scale = 1.0f;
    }

    public CarriageContraptionEntity ctp$getReference() {
        return this.ctp$reference;
    }

    public void ctp$diminish() {
        if (this.ctp$scale <= 0.0f) {
            return;
        }
        this.ctp$prevScale = this.ctp$scale;
        this.ctp$scale = class_3532.method_16439((float)0.1f, (float)this.ctp$scale, (float)0.0f);
    }

    public float ctp$getValueScale() {
        return this.ctp$scale;
    }

    public float ctp$getPrevValueScale() {
        return this.ctp$prevScale;
    }

    public boolean ctp$isEnabled() {
        return this.ctp$perspectiveActive;
    }

    @Nullable
    public RotationState ctp$getRotationState() {
        return this.ctp$currentState;
    }
}

