/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cache;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class Cache<T> {
    private volatile T value = null;

    protected abstract @NonNull T supply();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get() {
        T val = this.value;
        if (val == null) {
            Cache cache = this;
            synchronized (cache) {
                val = this.value;
                if (val == null) {
                    this.value = val = this.supply();
                }
            }
        }
        return val;
    }

    public final Optional<T> getIfPresent() {
        return Optional.ofNullable(this.value);
    }

    public final void invalidate() {
        this.value = null;
    }
}

