/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import me.lucko.luckperms.common.cacheddata.result.IntegerResult;
import me.lucko.luckperms.common.cacheddata.result.StringResult;
import me.lucko.luckperms.common.cacheddata.type.MetaStackAccumulator;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import net.luckperms.api.node.types.WeightNode;

public class MetaAccumulator {
    private final AtomicReference<State> state = new AtomicReference<State>(State.ACCUMULATING);
    private final ListMultimap<String, StringResult<MetaNode>> meta;
    private final SortedMap<Integer, StringResult<PrefixNode>> prefixes;
    private final SortedMap<Integer, StringResult<SuffixNode>> suffixes;
    private IntegerResult<WeightNode> weight;
    private String primaryGroup;
    private Set<String> seenNodeKeys = new HashSet<String>();
    private final MetaStackDefinition prefixDefinition;
    private final MetaStackDefinition suffixDefinition;
    private final MetaStackAccumulator<PrefixNode> prefixAccumulator;
    private final MetaStackAccumulator<SuffixNode> suffixAccumulator;

    public static MetaAccumulator makeFromConfig(LuckPermsPlugin plugin) {
        return new MetaAccumulator(plugin.getConfiguration().get(ConfigKeys.PREFIX_FORMATTING_OPTIONS), plugin.getConfiguration().get(ConfigKeys.SUFFIX_FORMATTING_OPTIONS));
    }

    public MetaAccumulator(MetaStackDefinition prefixDefinition, MetaStackDefinition suffixDefinition) {
        Objects.requireNonNull(prefixDefinition, "prefixDefinition");
        Objects.requireNonNull(suffixDefinition, "suffixDefinition");
        this.meta = ArrayListMultimap.create();
        this.prefixes = new TreeMap(Comparator.reverseOrder());
        this.suffixes = new TreeMap(Comparator.reverseOrder());
        this.weight = IntegerResult.nullResult();
        this.prefixDefinition = prefixDefinition;
        this.suffixDefinition = suffixDefinition;
        this.prefixAccumulator = new MetaStackAccumulator(this.prefixDefinition, ChatMetaType.PREFIX);
        this.suffixAccumulator = new MetaStackAccumulator(this.suffixDefinition, ChatMetaType.SUFFIX);
    }

    private void ensureState(State state) {
        if (this.state.get() != state) {
            throw new IllegalStateException("State must be " + (Object)((Object)state) + ", but is actually " + (Object)((Object)this.state.get()));
        }
    }

    public void complete() {
        if (!this.state.compareAndSet(State.ACCUMULATING, State.COMPLETING)) {
            return;
        }
        if (!this.meta.containsKey((Object)"weight") && !this.weight.isNull()) {
            this.meta.put((Object)"weight", StringResult.of(String.valueOf(this.weight.intResult())));
        }
        if (this.primaryGroup != null && !this.meta.containsKey((Object)"primarygroup")) {
            this.meta.put((Object)"primarygroup", StringResult.of(this.primaryGroup));
        }
        this.seenNodeKeys = null;
        this.state.set(State.COMPLETE);
    }

    public void accumulateNode(Node n) {
        ChatMetaNode<PrefixNode, PrefixNode.Builder> pn;
        this.ensureState(State.ACCUMULATING);
        if (!this.seenNodeKeys.add(n.getKey())) {
            return;
        }
        if (!n.getValue()) {
            return;
        }
        if (n instanceof MetaNode) {
            MetaNode mn = (MetaNode)n;
            this.meta.put((Object)mn.getMetaKey(), StringResult.of(mn));
        }
        if (n instanceof PrefixNode) {
            pn = (PrefixNode)n;
            this.prefixes.putIfAbsent(pn.getPriority(), StringResult.of(pn));
            this.prefixAccumulator.offer((PrefixNode)pn);
        }
        if (n instanceof SuffixNode) {
            pn = (SuffixNode)n;
            this.suffixes.putIfAbsent(pn.getPriority(), StringResult.of(pn));
            this.suffixAccumulator.offer((SuffixNode)pn);
        }
    }

    public void accumulateWeight(IntegerResult<WeightNode> weight) {
        this.ensureState(State.ACCUMULATING);
        if (this.weight.isNull() || weight.intResult() > this.weight.intResult()) {
            this.weight = weight;
        }
    }

    public void setPrimaryGroup(String primaryGroup) {
        this.ensureState(State.ACCUMULATING);
        this.primaryGroup = primaryGroup;
    }

    public ListMultimap<String, StringResult<MetaNode>> getMeta() {
        this.ensureState(State.COMPLETE);
        return this.meta;
    }

    public Map<Integer, ? extends StringResult<? extends ChatMetaNode<?, ?>>> getChatMeta(ChatMetaType type) {
        this.ensureState(State.COMPLETE);
        return type == ChatMetaType.PREFIX ? this.prefixes : this.suffixes;
    }

    public SortedMap<Integer, StringResult<PrefixNode>> getPrefixes() {
        this.ensureState(State.COMPLETE);
        return this.prefixes;
    }

    public SortedMap<Integer, StringResult<SuffixNode>> getSuffixes() {
        this.ensureState(State.COMPLETE);
        return this.suffixes;
    }

    public IntegerResult<WeightNode> getWeight() {
        this.ensureState(State.COMPLETE);
        return this.weight;
    }

    public String getPrimaryGroup() {
        this.ensureState(State.COMPLETE);
        return this.primaryGroup;
    }

    public MetaStackDefinition getPrefixDefinition() {
        this.ensureState(State.COMPLETE);
        return this.prefixDefinition;
    }

    public MetaStackDefinition getSuffixDefinition() {
        this.ensureState(State.COMPLETE);
        return this.suffixDefinition;
    }

    public StringResult<PrefixNode> getPrefix() {
        this.ensureState(State.COMPLETE);
        return this.prefixAccumulator.toResult();
    }

    public StringResult<SuffixNode> getSuffix() {
        this.ensureState(State.COMPLETE);
        return this.suffixAccumulator.toResult();
    }

    public String toString() {
        return "MetaAccumulator(meta=" + this.meta + ", prefixes=" + this.prefixes + ", suffixes=" + this.suffixes + ", weight=" + this.weight + ", primaryGroup=" + this.primaryGroup + ", prefixStack=" + this.prefixAccumulator + ", suffixStack=" + this.suffixAccumulator + ")";
    }

    private static enum State {
        ACCUMULATING,
        COMPLETING,
        COMPLETE;

    }
}

