/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.cacheddata.UsageTracked;
import me.lucko.luckperms.common.cacheddata.result.TristateResult;
import me.lucko.luckperms.common.calculator.CalculatorFactory;
import me.lucko.luckperms.common.calculator.PermissionCalculator;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.cacheddata.Result;
import net.luckperms.api.node.Node;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PermissionCache
extends UsageTracked
implements CachedPermissionData {
    private final QueryOptions queryOptions;
    private final Map<String, Node> permissions;
    private final Map<String, Boolean> permissionsView;
    private final PermissionCalculator calculator;

    public PermissionCache(QueryOptions queryOptions, CacheMetadata metadata, CalculatorFactory calculatorFactory, ConcurrentHashMap<String, Node> sourcePermissions) {
        this.queryOptions = queryOptions;
        this.permissions = sourcePermissions;
        this.permissionsView = Collections.unmodifiableMap(Maps.transformValues(this.permissions, Node::getValue));
        this.calculator = calculatorFactory.build(queryOptions, metadata);
        this.calculator.setSourcePermissions(this.permissions);
    }

    @Override
    public void invalidateCache() {
        this.calculator.invalidateCache();
    }

    public PermissionCalculator getCalculator() {
        return this.calculator;
    }

    @Override
    public @NonNull Map<String, Boolean> getPermissionMap() {
        return this.permissionsView;
    }

    public TristateResult checkPermission(String permission, CheckOrigin origin) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        return this.calculator.checkPermission(permission, origin);
    }

    @Override
    public @NonNull Result<Tristate, Node> queryPermission(@NonNull String permission) {
        return this.checkPermission(permission, CheckOrigin.LUCKPERMS_API);
    }

    @Override
    public @NonNull Tristate checkPermission(@NonNull String permission) {
        return this.checkPermission(permission, CheckOrigin.LUCKPERMS_API).result();
    }

    @Override
    public @NonNull QueryOptions getQueryOptions() {
        return this.queryOptions;
    }
}

