/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.utils;

import com.google.common.collect.ForwardingList;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.utils.ArgumentException;
import me.lucko.luckperms.common.commands.user.UserParentCommand;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.context.MutableContextSetImpl;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationParser;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.TemporaryNodeMergeStrategy;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ArgumentList
extends ForwardingList<String> {
    private final List<String> backingList;

    public ArgumentList(List<String> backingList) {
        this.backingList = backingList;
    }

    protected List<String> delegate() {
        return this.backingList;
    }

    public boolean indexOutOfBounds(int index) {
        return index < 0 || index >= this.size();
    }

    public String get(int index) throws IndexOutOfBoundsException {
        return ((String)super.get(index)).replace("{SPACE}", " ");
    }

    public String getOrDefault(int index, String defaultValue) {
        if (this.indexOutOfBounds(index)) {
            return defaultValue;
        }
        return this.get(index);
    }

    public @NonNull ArgumentList subList(int fromIndex, int toIndex) {
        return new ArgumentList(super.subList(fromIndex, toIndex));
    }

    public int getIntOrDefault(int index, int defaultValue) {
        if (this.indexOutOfBounds(index)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(this.get(index));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getLowercase(int index, Predicate<? super String> test) throws ArgumentException.DetailedUsage {
        String arg = this.get(index).toLowerCase(Locale.ROOT);
        if (!test.test(arg)) {
            throw new ArgumentException.DetailedUsage();
        }
        return arg;
    }

    public boolean getBooleanOrInsert(int index, boolean defaultValue) {
        String arg;
        if (!this.indexOutOfBounds(index) && ((arg = this.get(index)).equalsIgnoreCase("true") || arg.equalsIgnoreCase("false"))) {
            return Boolean.parseBoolean(arg);
        }
        this.add(index, Boolean.toString(defaultValue));
        return defaultValue;
    }

    public int getPriority(int index) throws ArgumentException {
        try {
            return Integer.parseInt(this.get(index));
        }
        catch (NumberFormatException e) {
            throw new ArgumentException.InvalidPriority(this.get(index));
        }
    }

    public UUID getUserTarget(int index, LuckPermsPlugin plugin, Sender sender) {
        String arg = this.get(index);
        return UserParentCommand.parseTargetUniqueId(arg, plugin, sender);
    }

    public Duration getDuration(int index) throws ArgumentException {
        String arg = this.get(index);
        return ArgumentList.parseDuration(arg).orElseThrow(() -> new ArgumentException.InvalidDate(arg));
    }

    public Duration getDurationOrDefault(int index, Duration defaultValue) throws ArgumentException {
        if (this.indexOutOfBounds(index)) {
            return defaultValue;
        }
        return ArgumentList.parseDuration(this.get(index)).orElse(defaultValue);
    }

    private static Optional<Duration> parseDuration(String input) throws ArgumentException.PastDate {
        try {
            long number = Long.parseLong(input);
            Instant now = Instant.now().truncatedTo(ChronoUnit.SECONDS);
            Duration duration = ArgumentList.checkPastDate(Duration.between(now, Instant.ofEpochSecond(number)));
            return Optional.of(duration);
        }
        catch (NumberFormatException number) {
            try {
                Duration duration = ArgumentList.checkPastDate(DurationParser.parseDuration(input));
                return Optional.of(duration);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Optional.empty();
            }
        }
    }

    private static Duration checkPastDate(Duration duration) throws ArgumentException.PastDate {
        if (duration.isNegative()) {
            throw new ArgumentException.PastDate();
        }
        return duration;
    }

    public Optional<TemporaryNodeMergeStrategy> getTemporaryModifierAndRemove(int index) {
        if (this.indexOutOfBounds(index)) {
            return Optional.empty();
        }
        TemporaryNodeMergeStrategy strategy = ArgumentList.parseTemporaryModifier(this.get(index));
        if (strategy == null) {
            return Optional.empty();
        }
        this.remove(index);
        return Optional.of(strategy);
    }

    private static TemporaryNodeMergeStrategy parseTemporaryModifier(String s) {
        switch (s.toLowerCase(Locale.ROOT)) {
            case "accumulate": {
                return TemporaryNodeMergeStrategy.ADD_NEW_DURATION_TO_EXISTING;
            }
            case "replace": {
                return TemporaryNodeMergeStrategy.REPLACE_EXISTING_IF_DURATION_LONGER;
            }
            case "deny": 
            case "none": {
                return TemporaryNodeMergeStrategy.NONE;
            }
        }
        return null;
    }

    public MutableContextSet getContextOrDefault(int fromIndex, LuckPermsPlugin plugin) throws CommandException {
        if (this.size() <= fromIndex) {
            return plugin.getConfiguration().getContextsFile().getDefaultContexts().mutableCopy();
        }
        return this.parseContext(fromIndex);
    }

    public ImmutableContextSet getContextOrEmpty(int fromIndex) {
        if (this.size() <= fromIndex) {
            return ImmutableContextSetImpl.EMPTY;
        }
        return this.parseContext(fromIndex).immutableCopy();
    }

    private MutableContextSet parseContext(int fromIndex) {
        MutableContextSetImpl contextSet = new MutableContextSetImpl();
        ArgumentList entries = this.subList(fromIndex, this.size());
        for (int i = 0; i < entries.size(); ++i) {
            String value;
            String key;
            String entry = (String)entries.get(i);
            int sep = entry.indexOf(61);
            if (sep != -1) {
                key = entry.substring(0, sep);
                value = entry.substring(sep + 1);
            } else {
                key = i == 1 ? "world" : "server";
                value = entry;
            }
            if (!Context.isValidKey(key) || !Context.isValidValue(value)) continue;
            contextSet.add(key, value);
        }
        return contextSet;
    }
}

