/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.parent;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.lib.adventure.text.Component;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;

public class ParentRemove
extends GenericChildCommand {
    public ParentRemove() {
        super(CommandSpec.PARENT_REMOVE, "remove", CommandPermission.USER_PARENT_REMOVE, CommandPermission.GROUP_PARENT_REMOVE, Predicates.is(0));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) throws CommandException {
        DataMutateResult result;
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        String groupName = args.getLowercase(0, DataConstraints.GROUP_NAME_TEST_ALLOW_SPACE);
        MutableContextSet context = args.getContextOrDefault(1, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)context) || ArgumentPermissions.checkGroup(plugin, sender, groupName, (ContextSet)context) || ArgumentPermissions.checkArguments(plugin, sender, permission, groupName)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        if (target.getType() == HolderType.USER) {
            boolean shouldPrevent;
            User user = (User)target;
            boolean bl = shouldPrevent = plugin.getConfiguration().get(ConfigKeys.PREVENT_PRIMARY_GROUP_REMOVAL) != false && context.isEmpty() && plugin.getConfiguration().get(ConfigKeys.PRIMARY_GROUP_CALCULATION_METHOD).equals("stored") && user.getPrimaryGroup().getStoredValue().orElse("default").equalsIgnoreCase(groupName);
            if (shouldPrevent) {
                Message.USER_REMOVEGROUP_ERROR_PRIMARY.send(sender);
                return;
            }
        }
        if ((result = target.unsetNode(DataType.NORMAL, (Node)((InheritanceNode.Builder)Inheritance.builder(groupName).withContext(context)).build())).wasSuccessful()) {
            Message.UNSET_INHERIT_SUCCESS.send(sender, target, (Component)Component.text((String)groupName), context);
            LoggedAction.build().source(sender).target(target).description("parent", "remove", groupName, context).build().submit(plugin, sender);
            if (target.getType() == HolderType.USER) {
                plugin.getUserManager().giveDefaultIfNeeded((User)target);
            }
            StorageAssistant.save(target, sender, plugin);
        } else {
            Message.DOES_NOT_INHERIT.send(sender, target, (Component)Component.text((String)groupName), context);
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.groups(plugin)).from(1, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

