/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.user;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.cacheddata.type.MonitoredMetaCache;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.UniqueIdType;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.QueryOptions;

public class UserInfo
extends ChildCommand<User> {
    public UserInfo() {
        super(CommandSpec.USER_INFO, "info", CommandPermission.USER_INFO, Predicates.alwaysFalse());
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, User target, ArgumentList args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        Message.USER_INFO_GENERAL.send(sender, target.getUsername().orElse("Unknown"), target.getUniqueId().toString(), UniqueIdType.determineType(target.getUniqueId(), plugin).describe(), plugin.getBootstrap().isPlayerOnline(target.getUniqueId()));
        Map parents = target.normalData().inheritanceAsSortedSet().stream().filter(Node::getValue).collect(Collectors.groupingBy(Node::hasExpiry, Collectors.toList()));
        List temporaryParents = parents.getOrDefault(true, Collections.emptyList());
        List permanentParents = parents.getOrDefault(false, Collections.emptyList());
        if (!permanentParents.isEmpty()) {
            Message.INFO_PARENT_HEADER.send(sender);
            for (InheritanceNode node : permanentParents) {
                Message.INFO_PARENT_NODE_ENTRY.send(sender, node);
            }
        }
        if (!temporaryParents.isEmpty()) {
            Message.INFO_TEMP_PARENT_HEADER.send(sender);
            for (InheritanceNode node : temporaryParents) {
                Message.INFO_PARENT_TEMPORARY_NODE_ENTRY.send(sender, node);
            }
        }
        QueryOptions queryOptions = plugin.getQueryOptionsForUser(target).orElse(null);
        boolean active = true;
        if (queryOptions == null) {
            active = false;
            queryOptions = plugin.getContextManager().getStaticQueryOptions();
        }
        ImmutableContextSet contextSet = queryOptions.context();
        MonitoredMetaCache data = target.getCachedData().getMetaData(queryOptions);
        String prefix = data.getPrefix(CheckOrigin.INTERNAL).result();
        String suffix = data.getSuffix(CheckOrigin.INTERNAL).result();
        String primaryGroup = data.getPrimaryGroup(CheckOrigin.INTERNAL);
        Map<String, List<String>> meta = data.getMeta(CheckOrigin.INTERNAL);
        Message.USER_INFO_CONTEXTUAL_DATA.send(sender, active, contextSet, prefix, suffix, primaryGroup, meta);
    }
}

