/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config.generic.adapter;

import me.lucko.luckperms.common.config.generic.adapter.StringBasedConfigurationAdapter;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SystemPropertyConfigAdapter
extends StringBasedConfigurationAdapter {
    private static final String PREFIX = "luckperms.";
    private final LuckPermsPlugin plugin;

    public SystemPropertyConfigAdapter(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    protected @Nullable String resolveValue(String path) {
        String key = PREFIX + path;
        String value = System.getProperty(key);
        if (value != null) {
            this.plugin.getLogger().info("Resolved configuration value from system property: " + key + " = " + (path.contains("password") ? "*****" : value));
        }
        return value;
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void reload() {
    }
}

