/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.nats;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.time.Duration;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.Throwing;
import me.lucko.luckperms.lib.nats.Connection;
import me.lucko.luckperms.lib.nats.Dispatcher;
import me.lucko.luckperms.lib.nats.Message;
import me.lucko.luckperms.lib.nats.MessageHandler;
import me.lucko.luckperms.lib.nats.Nats;
import me.lucko.luckperms.lib.nats.Options;
import net.luckperms.api.messenger.IncomingMessageConsumer;
import net.luckperms.api.messenger.Messenger;
import net.luckperms.api.messenger.message.OutgoingMessage;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NatsMessenger
implements Messenger {
    private static final String CHANNEL = "luckperms:update";
    private final LuckPermsPlugin plugin;
    private final IncomingMessageConsumer consumer;
    private Connection connection;
    private Dispatcher messageDispatcher;

    public NatsMessenger(LuckPermsPlugin plugin, IncomingMessageConsumer consumer) {
        this.plugin = plugin;
        this.consumer = consumer;
    }

    @Override
    public void sendOutgoingMessage(@NonNull OutgoingMessage outgoingMessage) {
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        output.writeUTF(outgoingMessage.asEncodedString());
        this.connection.publish(CHANNEL, output.toByteArray());
    }

    public void init(String address, String username, String password, boolean ssl) {
        String[] addressSplit = address.split(":");
        String host = addressSplit[0];
        int port = addressSplit.length > 1 ? Integer.parseInt(addressSplit[1]) : 4222;
        this.connection = this.createConnection(builder -> {
            builder.server("nats://" + host + ":" + port).reconnectWait(Duration.ofSeconds(5L)).maxReconnects(Integer.MAX_VALUE).connectionName("LuckPerms");
            if (username != null && password != null) {
                builder.userInfo(username, password);
            }
            if (ssl) {
                builder.secure();
            }
        });
        this.messageDispatcher = this.connection.createDispatcher((MessageHandler)new Handler()).subscribe(CHANNEL);
    }

    private Connection createConnection(Throwing.Consumer<Options.Builder> config) {
        try {
            Options.Builder builder = new Options.Builder();
            config.accept(builder);
            return Nats.connect((Options)builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.connection.closeDispatcher(this.messageDispatcher);
            this.connection.close();
        }
        catch (InterruptedException e) {
            this.plugin.getLogger().warn("An error occurred during closing messenger.", e);
        }
    }

    private class Handler
    implements MessageHandler {
        private Handler() {
        }

        public void onMessage(Message message) {
            byte[] data = message.getData();
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])data);
            String messageAsString = input.readUTF();
            NatsMessenger.this.consumer.consumeIncomingMessageAsString(messageAsString);
        }
    }
}

