/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.postgres;

import java.net.SocketException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.common.storage.implementation.sql.SqlStorage;
import me.lucko.luckperms.lib.postgresql.PGConnection;
import me.lucko.luckperms.lib.postgresql.PGNotification;
import me.lucko.luckperms.lib.postgresql.util.PSQLException;
import net.luckperms.api.messenger.IncomingMessageConsumer;
import net.luckperms.api.messenger.Messenger;
import net.luckperms.api.messenger.message.OutgoingMessage;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PostgresMessenger
implements Messenger {
    private static final String CHANNEL = "luckperms:update";
    private final LuckPermsPlugin plugin;
    private final SqlStorage sqlStorage;
    private final IncomingMessageConsumer consumer;
    private NotificationListener listener;
    private SchedulerTask checkConnectionTask;

    public PostgresMessenger(LuckPermsPlugin plugin, SqlStorage sqlStorage, IncomingMessageConsumer consumer) {
        this.plugin = plugin;
        this.sqlStorage = sqlStorage;
        this.consumer = consumer;
    }

    public void init() {
        this.checkAndReopenConnection(true);
        this.checkConnectionTask = this.plugin.getBootstrap().getScheduler().asyncRepeating(() -> this.checkAndReopenConnection(false), 5L, TimeUnit.SECONDS);
    }

    @Override
    public void sendOutgoingMessage(@NonNull OutgoingMessage outgoingMessage) {
        try (Connection connection = this.sqlStorage.getConnectionFactory().getConnection();
             PreparedStatement ps = connection.prepareStatement("SELECT pg_notify(?, ?)");){
            ps.setString(1, CHANNEL);
            ps.setString(2, outgoingMessage.asEncodedString());
            ps.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.checkConnectionTask.cancel();
            if (this.listener != null) {
                this.listener.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkAndReopenConnection(boolean firstStartup) {
        boolean listenerActive;
        boolean bl = listenerActive = this.listener != null && this.listener.isListening();
        if (listenerActive) {
            return true;
        }
        if (!firstStartup) {
            this.plugin.getLogger().warn("Postgres listen/notify connection dropped, trying to re-open the connection");
        }
        try {
            this.listener = new NotificationListener();
            this.plugin.getBootstrap().getScheduler().executeAsync(() -> {
                this.listener.listenAndBind();
                if (!firstStartup) {
                    this.plugin.getLogger().info("Postgres listen/notify connection re-established");
                }
            });
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private class NotificationListener
    implements AutoCloseable {
        private static final int RECEIVE_TIMEOUT_MILLIS = 1000;
        private final AtomicBoolean open = new AtomicBoolean(true);
        private final AtomicReference<Thread> listeningThread = new AtomicReference();

        private NotificationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listenAndBind() {
            try (Connection connection = PostgresMessenger.this.sqlStorage.getConnectionFactory().getConnection();){
                try (Statement s = connection.createStatement();){
                    s.execute("LISTEN \"luckperms:update\"");
                }
                PGConnection pgConnection = connection.unwrap(PGConnection.class);
                this.listeningThread.set(Thread.currentThread());
                while (this.open.get()) {
                    PGNotification[] notifications = pgConnection.getNotifications(1000);
                    if (notifications == null) continue;
                    for (PGNotification notification : notifications) {
                        this.handleNotification(notification);
                    }
                }
            }
            catch (PSQLException e) {
                if (!(e.getCause() instanceof SocketException) || !e.getCause().getMessage().equals("Socket closed")) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.listeningThread.set(null);
            }
        }

        public boolean isListening() {
            return this.listeningThread.get() != null;
        }

        public void handleNotification(PGNotification notification) {
            if (!PostgresMessenger.CHANNEL.equals(notification.getName())) {
                return;
            }
            PostgresMessenger.this.consumer.consumeIncomingMessageAsString(notification.getParameter());
        }

        @Override
        public void close() {
            Thread thread;
            if (this.open.compareAndSet(true, false) && (thread = this.listeningThread.get()) != null) {
                thread.interrupt();
            }
        }
    }
}

