/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.context.serializer.ContextSetConfigurateSerializer;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.node.types.Meta;
import me.lucko.luckperms.common.node.types.Prefix;
import me.lucko.luckperms.common.node.types.Suffix;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.implementation.file.CombinedConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.FileActionLogger;
import me.lucko.luckperms.common.storage.implementation.file.FileIOException;
import me.lucko.luckperms.common.storage.implementation.file.FileUuidCache;
import me.lucko.luckperms.common.storage.implementation.file.SeparatedConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.StorageLocation;
import me.lucko.luckperms.common.storage.implementation.file.loader.ConfigurateLoader;
import me.lucko.luckperms.common.storage.implementation.file.loader.JsonLoader;
import me.lucko.luckperms.common.storage.implementation.file.loader.YamlLoader;
import me.lucko.luckperms.common.util.MoreFiles;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.Types;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.MetaNode;

public abstract class AbstractConfigurateStorage
implements StorageImplementation {
    protected final LuckPermsPlugin plugin;
    private final String implementationName;
    protected final ConfigurateLoader loader;
    protected Path dataDirectory;
    private final String dataDirectoryName;
    private final FileUuidCache uuidCache;
    private Path uuidCacheFile;
    private final FileActionLogger actionLogger;

    protected AbstractConfigurateStorage(LuckPermsPlugin plugin, String implementationName, ConfigurateLoader loader, String dataDirectoryName) {
        this.plugin = plugin;
        this.implementationName = implementationName;
        this.loader = loader;
        this.dataDirectoryName = dataDirectoryName;
        this.uuidCache = new FileUuidCache();
        this.actionLogger = new FileActionLogger(plugin);
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return this.implementationName;
    }

    protected abstract ConfigurationNode readFile(StorageLocation var1, String var2) throws IOException;

    protected abstract void saveFile(StorageLocation var1, String var2, ConfigurationNode var3) throws IOException;

    @Override
    public void init() throws IOException {
        this.dataDirectory = this.plugin.getBootstrap().getDataDirectory().resolve(this.dataDirectoryName);
        MoreFiles.createDirectoriesIfNotExists(this.dataDirectory);
        this.uuidCacheFile = MoreFiles.createFileIfNotExists(this.dataDirectory.resolve("uuidcache.txt"));
        this.uuidCache.load(this.uuidCacheFile);
        this.actionLogger.init(this.dataDirectory.resolve("actions.txt"), this.dataDirectory.resolve("actions.json"));
    }

    @Override
    public void shutdown() {
        this.uuidCache.save(this.uuidCacheFile);
        this.actionLogger.flush();
    }

    @Override
    public void logAction(Action entry) {
        this.actionLogger.logAction(entry);
    }

    @Override
    public Log getLog() throws IOException {
        return this.actionLogger.getLog();
    }

    @Override
    public User loadUser(UUID uniqueId, String username) throws IOException {
        User user = this.plugin.getUserManager().getOrMake(uniqueId, username);
        try {
            ConfigurationNode file = this.readFile(StorageLocation.USERS, uniqueId.toString());
            if (file != null) {
                boolean updatedUsername;
                String name = file.getNode(new Object[]{"name"}).getString();
                String primaryGroup = file.getNode(new Object[]{this.loader instanceof JsonLoader ? "primaryGroup" : "primary-group"}).getString();
                user.getPrimaryGroup().setStoredValue(primaryGroup);
                user.setUsername(name, true);
                user.loadNodesFromStorage(AbstractConfigurateStorage.readNodes(file));
                this.plugin.getUserManager().giveDefaultIfNeeded(user);
                boolean bl = updatedUsername = user.getUsername().isPresent() && (name == null || !user.getUsername().get().equalsIgnoreCase(name));
                if (updatedUsername | user.auditTemporaryNodes()) {
                    this.saveUser(user);
                }
            } else if (this.plugin.getUserManager().isNonDefaultUser(user)) {
                user.loadNodesFromStorage(Collections.emptyList());
                user.getPrimaryGroup().setStoredValue(null);
                this.plugin.getUserManager().giveDefaultIfNeeded(user);
            }
        }
        catch (Exception e) {
            throw new FileIOException(uniqueId.toString(), e);
        }
        return user;
    }

    @Override
    public Map<UUID, User> loadUsers(Set<UUID> uniqueIds) throws Exception {
        HashMap<UUID, User> map = new HashMap<UUID, User>();
        for (UUID uniqueId : uniqueIds) {
            map.put(uniqueId, this.loadUser(uniqueId, null));
        }
        return map;
    }

    @Override
    public void saveUser(User user) throws IOException {
        user.normalData().discardChanges();
        try {
            if (!this.plugin.getUserManager().isNonDefaultUser(user)) {
                this.saveFile(StorageLocation.USERS, user.getUniqueId().toString(), null);
            } else {
                ConfigurationNode file = ConfigurationNode.root();
                if (this instanceof SeparatedConfigurateStorage) {
                    file.getNode(new Object[]{"uuid"}).setValue((Object)user.getUniqueId().toString());
                }
                String name = user.getUsername().orElse("null");
                String primaryGroup = user.getPrimaryGroup().getStoredValue().orElse("default");
                file.getNode(new Object[]{"name"}).setValue((Object)name);
                file.getNode(new Object[]{this.loader instanceof JsonLoader ? "primaryGroup" : "primary-group"}).setValue((Object)primaryGroup);
                this.writeNodes(file, user.normalData().asList());
                this.saveFile(StorageLocation.USERS, user.getUniqueId().toString(), file);
            }
        }
        catch (Exception e) {
            throw new FileIOException(user.getUniqueId().toString(), e);
        }
    }

    @Override
    public Group createAndLoadGroup(String name) throws IOException {
        Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
        try {
            ConfigurationNode file = this.readFile(StorageLocation.GROUPS, name);
            if (file != null) {
                group.loadNodesFromStorage(AbstractConfigurateStorage.readNodes(file));
            } else {
                file = ConfigurationNode.root();
                if (this instanceof SeparatedConfigurateStorage) {
                    file.getNode(new Object[]{"name"}).setValue((Object)group.getName());
                }
                this.writeNodes(file, group.normalData().asList());
                this.saveFile(StorageLocation.GROUPS, name, file);
            }
        }
        catch (Exception e) {
            throw new FileIOException(name, e);
        }
        return group;
    }

    @Override
    public Optional<Group> loadGroup(String name) throws IOException {
        try {
            ConfigurationNode file = this.readFile(StorageLocation.GROUPS, name);
            if (file == null) {
                return Optional.empty();
            }
            Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
            group.loadNodesFromStorage(AbstractConfigurateStorage.readNodes(file));
            return Optional.of(group);
        }
        catch (Exception e) {
            throw new FileIOException(name, e);
        }
    }

    @Override
    public void saveGroup(Group group) throws IOException {
        group.normalData().discardChanges();
        try {
            ConfigurationNode file = ConfigurationNode.root();
            if (this instanceof SeparatedConfigurateStorage) {
                file.getNode(new Object[]{"name"}).setValue((Object)group.getName());
            }
            this.writeNodes(file, group.normalData().asList());
            this.saveFile(StorageLocation.GROUPS, group.getName(), file);
        }
        catch (Exception e) {
            throw new FileIOException(group.getName(), e);
        }
    }

    @Override
    public void deleteGroup(Group group) throws IOException {
        try {
            this.saveFile(StorageLocation.GROUPS, group.getName(), null);
        }
        catch (Exception e) {
            throw new FileIOException(group.getName(), e);
        }
        this.plugin.getGroupManager().unload(group.getName());
    }

    @Override
    public Track createAndLoadTrack(String name) throws IOException {
        Track track = (Track)this.plugin.getTrackManager().getOrMake(name);
        try {
            ConfigurationNode file = this.readFile(StorageLocation.TRACKS, name);
            if (file != null) {
                track.setGroups(file.getNode(new Object[]{"groups"}).getList(Types::asString));
            } else {
                file = ConfigurationNode.root();
                if (this instanceof SeparatedConfigurateStorage) {
                    file.getNode(new Object[]{"name"}).setValue((Object)name);
                }
                file.getNode(new Object[]{"groups"}).setValue(track.getGroups());
                this.saveFile(StorageLocation.TRACKS, name, file);
            }
        }
        catch (Exception e) {
            throw new FileIOException(name, e);
        }
        return track;
    }

    @Override
    public Optional<Track> loadTrack(String name) throws IOException {
        try {
            ConfigurationNode file = this.readFile(StorageLocation.TRACKS, name);
            if (file == null) {
                return Optional.empty();
            }
            Track track = (Track)this.plugin.getTrackManager().getOrMake(name);
            track.setGroups(file.getNode(new Object[]{"groups"}).getList(Types::asString));
            return Optional.of(track);
        }
        catch (Exception e) {
            throw new FileIOException(name, e);
        }
    }

    @Override
    public void saveTrack(Track track) throws IOException {
        try {
            ConfigurationNode file = ConfigurationNode.root();
            if (this instanceof SeparatedConfigurateStorage) {
                file.getNode(new Object[]{"name"}).setValue((Object)track.getName());
            }
            file.getNode(new Object[]{"groups"}).setValue(track.getGroups());
            this.saveFile(StorageLocation.TRACKS, track.getName(), file);
        }
        catch (Exception e) {
            throw new FileIOException(track.getName(), e);
        }
    }

    @Override
    public void deleteTrack(Track track) throws IOException {
        try {
            this.saveFile(StorageLocation.TRACKS, track.getName(), null);
        }
        catch (Exception e) {
            throw new FileIOException(track.getName(), e);
        }
        this.plugin.getTrackManager().unload(track.getName());
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uniqueId, String username) {
        return this.uuidCache.addMapping(uniqueId, username);
    }

    @Override
    public void deletePlayerData(UUID uniqueId) {
        this.uuidCache.removeMapping(uniqueId);
    }

    @Override
    public UUID getPlayerUniqueId(String username) {
        return this.uuidCache.lookupUuid(username);
    }

    @Override
    public String getPlayerName(UUID uniqueId) {
        return this.uuidCache.lookupUsername(uniqueId);
    }

    protected boolean processBulkUpdate(BulkUpdate bulkUpdate, ConfigurationNode node, HolderType holderType) {
        Set<Node> nodes = AbstractConfigurateStorage.readNodes(node);
        Set<Node> results = bulkUpdate.apply(nodes, holderType);
        if (results == null) {
            return false;
        }
        this.writeNodes(node, results);
        return true;
    }

    private static ImmutableContextSet readContexts(ConfigurationNode attributes) {
        ImmutableContextSetImpl.BuilderImpl contextBuilder = new ImmutableContextSetImpl.BuilderImpl();
        ConfigurationNode contextMap = attributes.getNode(new Object[]{"context"});
        if (!contextMap.isVirtual() && contextMap.isMap()) {
            contextBuilder.addAll(ContextSetConfigurateSerializer.deserializeContextSet(contextMap));
        }
        String server = attributes.getNode(new Object[]{"server"}).getString("global");
        contextBuilder.add("server", server);
        String world = attributes.getNode(new Object[]{"world"}).getString("global");
        contextBuilder.add("world", world);
        return contextBuilder.build();
    }

    private static Node readAttributes(NodeBuilder<?, ?> builder, ConfigurationNode attributes) {
        long expiryVal = attributes.getNode(new Object[]{"expiry"}).getLong(0L);
        Instant expiry = expiryVal == 0L ? null : Instant.ofEpochSecond(expiryVal);
        ImmutableContextSet context = AbstractConfigurateStorage.readContexts(attributes);
        return builder.expiry(expiry).context(context).build();
    }

    private static NodeEntry parseNode(ConfigurationNode configNode, String keyFieldName) {
        ConfigurationNode appended;
        String permission;
        Map.Entry entry;
        Map children = configNode.getChildrenMap();
        if (children.isEmpty()) {
            return null;
        }
        if (children.size() == 1 && (entry = (Map.Entry)Iterables.getFirst(children.entrySet(), null)) != null) {
            permission = entry.getKey().toString();
            ConfigurationNode attributes = (ConfigurationNode)entry.getValue();
            if (!permission.equals(keyFieldName) && !permission.isEmpty()) {
                return new NodeEntry(permission, attributes);
            }
        }
        if ((appended = (ConfigurationNode)children.get(keyFieldName)) == null) {
            return null;
        }
        permission = appended.getString("");
        return new NodeEntry(permission, configNode);
    }

    protected static Set<Node> readNodes(ConfigurationNode data) {
        NodeEntry entry;
        NodeEntry entry2;
        String plainValue;
        HashSet<Node> nodes = new HashSet<Node>();
        for (ConfigurationNode appended : data.getNode(new Object[]{"permissions"}).getChildrenList()) {
            plainValue = (String)appended.getValue(Types::strictAsString);
            if (plainValue != null && !plainValue.isEmpty()) {
                nodes.add((Node)NodeBuilders.determineMostApplicable(plainValue).build());
                continue;
            }
            entry2 = AbstractConfigurateStorage.parseNode(appended, "permission");
            if (entry2 == null || entry2.key.isEmpty()) continue;
            nodes.add(AbstractConfigurateStorage.readAttributes(NodeBuilders.determineMostApplicable(entry2.key).value(entry2.attributes.getNode(new Object[]{"value"}).getBoolean(true)), entry2.attributes));
        }
        for (ConfigurationNode appended : data.getNode(new Object[]{"parents"}).getChildrenList()) {
            plainValue = (String)appended.getValue(Types::strictAsString);
            if (plainValue != null) {
                nodes.add(Inheritance.builder(plainValue).build());
                continue;
            }
            entry2 = AbstractConfigurateStorage.parseNode(appended, "group");
            if (entry2 == null || entry2.key.isEmpty()) continue;
            nodes.add(AbstractConfigurateStorage.readAttributes(Inheritance.builder(entry2.key), entry2.attributes));
        }
        for (ConfigurationNode appended : data.getNode(new Object[]{"prefixes"}).getChildrenList()) {
            entry = AbstractConfigurateStorage.parseNode(appended, "prefix");
            if (entry == null) continue;
            nodes.add(AbstractConfigurateStorage.readAttributes(Prefix.builder(entry.key, entry.attributes.getNode(new Object[]{"priority"}).getInt(0)), entry.attributes));
        }
        for (ConfigurationNode appended : data.getNode(new Object[]{"suffixes"}).getChildrenList()) {
            entry = AbstractConfigurateStorage.parseNode(appended, "suffix");
            if (entry == null) continue;
            nodes.add(AbstractConfigurateStorage.readAttributes(Suffix.builder(entry.key, entry.attributes.getNode(new Object[]{"priority"}).getInt(0)), entry.attributes));
        }
        for (ConfigurationNode appended : data.getNode(new Object[]{"meta"}).getChildrenList()) {
            entry = AbstractConfigurateStorage.parseNode(appended, "key");
            if (entry == null || entry.key.isEmpty()) continue;
            nodes.add(AbstractConfigurateStorage.readAttributes(Meta.builder(entry.key, entry.attributes.getNode(new Object[]{"value"}).getString("null")), entry.attributes));
        }
        return nodes;
    }

    private static void writeAttributesTo(ConfigurationNode attributes, Node node, boolean writeValue) {
        if (writeValue) {
            attributes.getNode(new Object[]{"value"}).setValue((Object)node.getValue());
        }
        if (node.hasExpiry()) {
            attributes.getNode(new Object[]{"expiry"}).setValue((Object)node.getExpiry().getEpochSecond());
        }
        if (!node.getContexts().isEmpty()) {
            attributes.getNode(new Object[]{"context"}).setValue((Object)ContextSetConfigurateSerializer.serializeContextSet(node.getContexts()));
        }
    }

    private static boolean isPlain(Node node) {
        return node.getValue() && !node.hasExpiry() && node.getContexts().isEmpty();
    }

    private void appendNode(ConfigurationNode base, String key, ConfigurationNode attributes, String keyFieldName) {
        ConfigurationNode appended = base.appendListNode();
        if (this.loader instanceof YamlLoader && !key.isEmpty()) {
            appended.getNode(new Object[]{key}).setValue((Object)attributes);
        } else {
            appended.getNode(new Object[]{keyFieldName}).setValue((Object)key);
            appended.mergeValuesFrom(attributes);
        }
    }

    private void writeNodes(ConfigurationNode to, Collection<Node> nodes) {
        ConfigurationNode permissionsSection = ConfigurationNode.root();
        if (this instanceof CombinedConfigurateStorage) {
            permissionsSection.setValue(Collections.emptyList());
        }
        ConfigurationNode parentsSection = ConfigurationNode.root();
        ConfigurationNode prefixesSection = ConfigurationNode.root();
        ConfigurationNode suffixesSection = ConfigurationNode.root();
        ConfigurationNode metaSection = ConfigurationNode.root();
        for (Node n : nodes) {
            ConfigurationNode attributes;
            if (this.loader instanceof YamlLoader && AbstractConfigurateStorage.isPlain(n)) {
                if (n instanceof InheritanceNode) {
                    parentsSection.appendListNode().setValue((Object)((InheritanceNode)n).getGroupName());
                    continue;
                }
                if (!NodeType.META_OR_CHAT_META.matches(n)) {
                    permissionsSection.appendListNode().setValue((Object)n.getKey());
                    continue;
                }
            }
            if (n instanceof ChatMetaNode && n.getValue()) {
                ChatMetaNode chatMeta = (ChatMetaNode)n;
                attributes = ConfigurationNode.root();
                attributes.getNode(new Object[]{"priority"}).setValue((Object)chatMeta.getPriority());
                AbstractConfigurateStorage.writeAttributesTo(attributes, n, false);
                switch (chatMeta.getMetaType()) {
                    case PREFIX: {
                        this.appendNode(prefixesSection, chatMeta.getMetaValue(), attributes, "prefix");
                        break;
                    }
                    case SUFFIX: {
                        this.appendNode(suffixesSection, chatMeta.getMetaValue(), attributes, "suffix");
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                continue;
            }
            if (n instanceof MetaNode && n.getValue()) {
                MetaNode meta = (MetaNode)n;
                attributes = ConfigurationNode.root();
                attributes.getNode(new Object[]{"value"}).setValue((Object)meta.getMetaValue());
                AbstractConfigurateStorage.writeAttributesTo(attributes, n, false);
                this.appendNode(metaSection, meta.getMetaKey(), attributes, "key");
                continue;
            }
            if (n instanceof InheritanceNode && n.getValue()) {
                InheritanceNode inheritance = (InheritanceNode)n;
                attributes = ConfigurationNode.root();
                AbstractConfigurateStorage.writeAttributesTo(attributes, n, false);
                this.appendNode(parentsSection, inheritance.getGroupName(), attributes, "group");
                continue;
            }
            ConfigurationNode attributes2 = ConfigurationNode.root();
            AbstractConfigurateStorage.writeAttributesTo(attributes2, n, true);
            this.appendNode(permissionsSection, n.getKey(), attributes2, "permission");
        }
        if (permissionsSection.isList() || this instanceof CombinedConfigurateStorage) {
            to.getNode(new Object[]{"permissions"}).setValue((Object)permissionsSection);
        } else {
            to.removeChild((Object)"permissions");
        }
        if (parentsSection.isList()) {
            to.getNode(new Object[]{"parents"}).setValue((Object)parentsSection);
        } else {
            to.removeChild((Object)"parents");
        }
        if (prefixesSection.isList()) {
            to.getNode(new Object[]{"prefixes"}).setValue((Object)prefixesSection);
        } else {
            to.removeChild((Object)"prefixes");
        }
        if (suffixesSection.isList()) {
            to.getNode(new Object[]{"suffixes"}).setValue((Object)suffixesSection);
        } else {
            to.removeChild((Object)"suffixes");
        }
        if (metaSection.isList()) {
            to.getNode(new Object[]{"meta"}).setValue((Object)metaSection);
        } else {
            to.removeChild((Object)"meta");
        }
    }

    private static final class NodeEntry {
        final String key;
        final ConfigurationNode attributes;

        private NodeEntry(String key, ConfigurationNode attributes) {
            this.key = key;
            this.attributes = attributes;
        }
    }
}

