/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.file;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Properties;
import java.util.function.Function;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.FlatfileConnectionFactory;

public class H2ConnectionFactory
extends FlatfileConnectionFactory {
    private Constructor<?> connectionConstructor;

    public H2ConnectionFactory(Path file) {
        super(file);
    }

    @Override
    public String getImplementationName() {
        return "H2";
    }

    @Override
    public void init(LuckPermsPlugin plugin) {
        this.migrateOldDatabaseFile("luckperms.db.mv.db");
        ClassLoader classLoader = plugin.getDependencyManager().obtainClassLoaderWith(EnumSet.of(Dependency.H2_DRIVER));
        try {
            Class<?> connectionClass = classLoader.loadClass("org.h2.jdbc.JdbcConnection");
            this.connectionConstructor = connectionClass.getConstructor(String.class, Properties.class, String.class, Object.class, Boolean.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        try {
            new MigrateH2ToVersion2(plugin, super.getWriteFile().getParent()).run(this);
        }
        catch (Exception e) {
            plugin.getLogger().warn("Something went wrong whilst upgrading the LuckPerms database. Please report this on GitHub.", e);
        }
    }

    @Override
    protected Connection createConnection(Path file) throws SQLException {
        try {
            return (Connection)this.connectionConstructor.newInstance("jdbc:h2:" + file.toString(), new Properties(), null, null, false);
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Path getWriteFile() {
        Path writeFile = super.getWriteFile();
        return writeFile.getParent().resolve(writeFile.getFileName().toString() + ".mv.db");
    }

    @Override
    public Function<String, String> getStatementProcessor() {
        return s -> s.replace('\'', '`').replace("LIKE", "ILIKE").replace("value", "`value`").replace("``value``", "`value`");
    }

    private static final class MigrateH2ToVersion2 {
        private final LuckPermsPlugin plugin;
        private final Path directory;

        MigrateH2ToVersion2(LuckPermsPlugin plugin, Path directory) {
            this.plugin = plugin;
            this.directory = directory;
        }

        public void run(H2ConnectionFactory newFactory) throws Exception {
            Statement stmt;
            Path oldDatabase = this.directory.resolve("luckperms-h2");
            Path oldDatabaseWriteFile = this.directory.resolve("luckperms-h2.mv.db");
            if (!Files.exists(oldDatabaseWriteFile, new LinkOption[0])) {
                return;
            }
            Path tempMigrationFile = this.directory.resolve("luckperms-h2-migration.sql");
            this.plugin.getLogger().warn("[DB Upgrade] Found an old (v1) H2 database file. LuckPerms will now attempt to upgrade it to v2 (this is a one time operation).");
            try {
                Files.deleteIfExists(tempMigrationFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().warn("[DB Upgrade] Unable to delete temporary data from a previous migration attempt", e);
            }
            this.plugin.getLogger().info("[DB Upgrade] Stage 1: Exporting the old database to an intermediary file...");
            Constructor<?> constructor = this.getConnectionConstructor();
            try (Connection c = this.getConnection(constructor, oldDatabase);){
                stmt = c.createStatement();
                try {
                    stmt.execute(String.format("SCRIPT TO '%s'", tempMigrationFile));
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            this.plugin.getLogger().info("[DB Upgrade] Stage 2: Importing the intermediary file into the new database...");
            c = newFactory.getConnection();
            try {
                stmt = c.createStatement();
                try {
                    stmt.execute(String.format("RUNSCRIPT FROM '%s'", tempMigrationFile));
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            this.plugin.getLogger().info("[DB Upgrade] Stage 3: Tidying up...");
            Files.deleteIfExists(tempMigrationFile);
            Files.move(oldDatabaseWriteFile, this.directory.resolve("luckperms-h2-v1-backup.mv.db"), new CopyOption[0]);
            this.plugin.getLogger().info("[DB Upgrade] All done!");
        }

        private Constructor<?> getConnectionConstructor() {
            this.plugin.getDependencyManager().loadDependencies(Collections.singleton(Dependency.H2_DRIVER_LEGACY));
            ClassLoader classLoader = this.plugin.getDependencyManager().obtainClassLoaderWith(EnumSet.of(Dependency.H2_DRIVER_LEGACY));
            try {
                Class<?> connectionClass = classLoader.loadClass("org.h2.jdbc.JdbcConnection");
                return connectionClass.getConstructor(String.class, Properties.class);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        private Connection getConnection(Constructor<?> constructor, Path file) {
            try {
                return (Connection)constructor.newInstance("jdbc:h2:" + file.toString(), new Properties());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

