/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.misc;

import net.luckperms.api.node.HeldNode;
import net.luckperms.api.node.Node;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NodeEntry<H extends Comparable<H>, N extends Node>
implements HeldNode<H> {
    private final H holder;
    private final N node;

    public static <H extends Comparable<H>, N extends Node> NodeEntry<H, N> of(H holder, N node) {
        return new NodeEntry<H, N>(holder, node);
    }

    private NodeEntry(H holder, N node) {
        this.holder = holder;
        this.node = node;
    }

    @Override
    public @NonNull H getHolder() {
        return this.holder;
    }

    public @NonNull N getNode() {
        return this.node;
    }

    public String toString() {
        return "NodeEntry(holder=" + this.holder + ", node=" + this.node + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeEntry)) {
            return false;
        }
        NodeEntry other = (NodeEntry)o;
        return this.getHolder().equals(other.getHolder()) && this.getNode().equals(other.getNode());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHolder().hashCode();
        result = result * 59 + this.getNode().hashCode();
        return result;
    }
}

