/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.treeview;

import com.google.common.base.Splitter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;
import me.lucko.luckperms.common.cacheddata.type.PermissionCache;
import me.lucko.luckperms.common.http.AbstractHttpClient;
import me.lucko.luckperms.common.http.BytebinClient;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.treeview.ImmutableTreeNode;
import me.lucko.luckperms.common.treeview.PermissionRegistry;
import me.lucko.luckperms.common.treeview.TreeNode;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;

public class TreeView {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private final String rootPosition;
    private final ImmutableTreeNode view;

    public TreeView(PermissionRegistry source, String rootPosition) {
        if (rootPosition.isEmpty() || rootPosition.equals("*")) {
            rootPosition = ".";
        } else if (!rootPosition.equals(".") && rootPosition.endsWith(".")) {
            rootPosition = rootPosition.substring(0, rootPosition.length() - 1);
        }
        this.rootPosition = rootPosition;
        Optional<TreeNode> root = TreeView.findRoot(rootPosition, source);
        this.view = root.map(TreeNode::makeImmutableCopy).orElse(null);
    }

    public boolean hasData() {
        return this.view != null;
    }

    private static Optional<TreeNode> findRoot(String rootPosition, PermissionRegistry source) {
        TreeNode root = source.getRootNode();
        if (rootPosition.equals(".")) {
            return Optional.of(root);
        }
        List parts = Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)rootPosition);
        for (String part : parts) {
            if (!root.getChildren().isPresent()) {
                return Optional.empty();
            }
            Map<String, TreeNode> branch = root.getChildren().get();
            if ((root = branch.get(part)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(root);
    }

    public String uploadPasteData(BytebinClient bytebin, Sender sender, User user, PermissionCache checker) throws IOException, UnsuccessfulRequestException {
        JObject checks;
        if (!this.hasData()) {
            throw new IllegalStateException();
        }
        String prefix = this.rootPosition.equals(".") ? "" : this.rootPosition + ".";
        JsonObject jsonTree = this.view.toJson(prefix);
        JObject metadata = new JObject().add("time", DATE_FORMAT.format(new Date(System.currentTimeMillis()))).add("root", this.rootPosition).add("uploader", new JObject().add("name", sender.getNameWithLocation()).add("uuid", sender.getUniqueId().toString()));
        if (user != null && checker != null) {
            metadata.add("referenceUser", new JObject().add("name", user.getPlainDisplayName()).add("uuid", user.getUniqueId().toString()));
            checks = new JObject();
            for (Map.Entry<Integer, String> node : this.view.getNodeEndings()) {
                String permission = prefix + node.getValue();
                checks.add(permission, checker.checkPermission(permission, CheckOrigin.INTERNAL).result().name().toLowerCase(Locale.ROOT));
            }
        } else {
            checks = null;
        }
        JsonObject payload = new JObject().add("metadata", metadata).add("data", new JObject().add("tree", (JsonElement)jsonTree).consume(obj -> {
            if (checks != null) {
                obj.add("checkResults", checks);
            }
        })).toJson();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(bytesOut), StandardCharsets.UTF_8);){
            GsonProvider.normal().toJson((JsonElement)payload, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytebin.postContent(bytesOut.toByteArray(), AbstractHttpClient.JSON_TYPE).key();
    }
}

