/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.http.AbstractHttpClient;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.PermissionHolderIdentifier;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.webeditor.WebEditorRequest;
import me.lucko.luckperms.common.webeditor.socket.WebEditorSocket;

public class WebEditorSession {
    private WebEditorRequest initialRequest;
    private final LuckPermsPlugin plugin;
    private final Sender sender;
    private final String cmdLabel;
    private final Set<PermissionHolderIdentifier> holders;
    private final Set<String> tracks;
    private WebEditorSocket socket = null;

    public static WebEditorSession create(List<PermissionHolder> holders, List<Track> tracks, Sender sender, String cmdLabel, LuckPermsPlugin plugin) {
        WebEditorRequest initialRequest = WebEditorRequest.generate(holders, tracks, sender, cmdLabel, plugin);
        return new WebEditorSession(initialRequest, plugin, sender, cmdLabel);
    }

    public WebEditorSession(WebEditorRequest initialRequest, LuckPermsPlugin plugin, Sender sender, String cmdLabel) {
        this.initialRequest = initialRequest;
        this.plugin = plugin;
        this.sender = sender;
        this.cmdLabel = cmdLabel;
        this.holders = new LinkedHashSet<PermissionHolderIdentifier>(initialRequest.getHolders().keySet());
        this.tracks = new LinkedHashSet<String>(initialRequest.getTracks().keySet());
    }

    public String open() {
        this.createSocket();
        return this.createInitialSession();
    }

    private void createSocket() {
        block2: {
            try {
                WebEditorSocket socket = new WebEditorSocket(this.plugin, this.sender, this);
                socket.initialize(this.plugin.getBytesocks());
                socket.waitForConnect(5L, TimeUnit.SECONDS);
                this.socket = socket;
                this.plugin.getWebEditorStore().sockets().putSocket(this.sender, this.socket);
            }
            catch (Exception e) {
                if (WebEditorSession.ignoreSocketConnectError(e)) break block2;
                this.plugin.getLogger().warn("Unable to establish socket connection", e);
            }
        }
    }

    private static boolean ignoreSocketConnectError(Exception e) {
        if (e instanceof UnsuccessfulRequestException) {
            UnsuccessfulRequestException req = (UnsuccessfulRequestException)e;
            int code = req.getResponse().code();
            return code == 502 || code == 503;
        }
        return false;
    }

    private String createInitialSession() {
        String id;
        Objects.requireNonNull(this.initialRequest);
        WebEditorRequest request = this.initialRequest;
        this.initialRequest = null;
        if (this.socket != null) {
            this.socket.appendDetailToRequest(request);
        }
        if ((id = this.uploadRequestData(request)) == null) {
            return null;
        }
        String url = this.plugin.getConfiguration().get(ConfigKeys.WEB_EDITOR_URL_PATTERN) + id;
        Message.EDITOR_URL.send(this.sender, url);
        if (this.socket != null) {
            this.socket.scheduleCleanupIfUnused();
        }
        return id;
    }

    public WebEditorSocket getSocket() {
        return this.socket;
    }

    public void includeCreatedGroup(Group group) {
        this.holders.add(group.getIdentifier());
    }

    public void includeCreatedTrack(Track track) {
        this.tracks.add(track.getName());
    }

    public void excludeDeletedUser(User user) {
        this.holders.remove(user.getIdentifier());
    }

    public void excludeDeletedGroup(Group group) {
        this.holders.remove(group.getIdentifier());
    }

    public void excludeDeletedTrack(Track track) {
        this.tracks.remove(track.getName());
    }

    public String createFollowUpSession() {
        List<PermissionHolder> holders = this.holders.stream().map(id -> {
            switch (id.getType()) {
                case "user": {
                    return this.plugin.getStorage().loadUser(UUID.fromString(id.getName()), null);
                }
                case "group": {
                    return this.plugin.getStorage().loadGroup(id.getName()).thenApply(o -> o.orElse(null));
                }
            }
            return null;
        }).filter(Objects::nonNull).map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList());
        List<Track> tracks = this.tracks.stream().map(id -> this.plugin.getStorage().loadTrack((String)id).thenApply(o -> o.orElse(null))).map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList());
        return this.uploadRequestData(WebEditorRequest.generate(holders, tracks, this.sender, this.cmdLabel, this.plugin));
    }

    public String getCommandLabel() {
        return this.cmdLabel;
    }

    private String uploadRequestData(WebEditorRequest request) {
        String pasteId;
        byte[] requestBuf = request.encode();
        try {
            pasteId = this.plugin.getBytebin().postContent(requestBuf, AbstractHttpClient.JSON_TYPE, "editor").key();
        }
        catch (UnsuccessfulRequestException e) {
            Message.EDITOR_HTTP_REQUEST_FAILURE.send(this.sender, e.getResponse().code(), e.getResponse().message());
            return null;
        }
        catch (IOException e) {
            new RuntimeException("Error uploading data to bytebin", e).printStackTrace();
            Message.EDITOR_HTTP_UNKNOWN_FAILURE.send(this.sender);
            return null;
        }
        this.plugin.getWebEditorStore().sessions().addNewSession(pasteId, request);
        return pasteId;
    }
}

