/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor.socket.listener;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Objects;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.webeditor.WebEditorResponse;
import me.lucko.luckperms.common.webeditor.socket.SocketMessageType;
import me.lucko.luckperms.common.webeditor.socket.WebEditorSocket;
import me.lucko.luckperms.common.webeditor.socket.listener.Handler;

public class HandlerChangeRequest
implements Handler {
    private static final String STATE_ACCEPTED = "accepted";
    private static final String STATE_APPLIED = "applied";
    private final WebEditorSocket socket;

    public HandlerChangeRequest(WebEditorSocket socket) {
        this.socket = socket;
    }

    @Override
    public void handle(JsonObject msg) {
        JsonObject data;
        if (!this.socket.getSender().hasPermission(CommandPermission.APPLY_EDITS)) {
            throw new IllegalStateException("Sender does not have applyedits permission");
        }
        String code = msg.get("code").getAsString();
        if (code == null || code.isEmpty()) {
            throw new IllegalArgumentException("Invalid code");
        }
        this.socket.getPlugin().getBootstrap().getScheduler().executeAsync(() -> this.socket.send(SocketMessageType.CHANGE_RESPONSE.builder().add("state", STATE_ACCEPTED).toJson()));
        try {
            data = this.socket.getPlugin().getBytebin().getJsonContent(code).getAsJsonObject();
            Objects.requireNonNull(data);
        }
        catch (IOException | UnsuccessfulRequestException e) {
            throw new RuntimeException("Error reading data", e);
        }
        Message.EDITOR_SOCKET_CHANGES_RECEIVED.send(this.socket.getSender());
        new WebEditorResponse(code, data).apply(this.socket.getPlugin(), this.socket.getSender(), this.socket.getSession(), "lp", false);
        String newSessionCode = this.socket.getSession().createFollowUpSession();
        this.socket.send(SocketMessageType.CHANGE_RESPONSE.builder().add("state", STATE_APPLIED).add("newSessionCode", newSessionCode).toJson());
    }
}

