/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric.listeners;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.lucko.fabric.api.permissions.v0.OfflinePermissionCheckEvent;
import me.lucko.fabric.api.permissions.v0.OptionRequestEvent;
import me.lucko.fabric.api.permissions.v0.PermissionCheckEvent;
import me.lucko.luckperms.common.cacheddata.result.StringResult;
import me.lucko.luckperms.common.cacheddata.result.TristateResult;
import me.lucko.luckperms.common.cacheddata.type.PermissionCache;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.verbose.VerboseCheckTarget;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.fabric.LPFabricPlugin;
import me.lucko.luckperms.fabric.model.MixinUser;
import net.fabricmc.fabric.api.util.TriState;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FabricPermissionsApiListener {
    private final LPFabricPlugin plugin;

    public FabricPermissionsApiListener(LPFabricPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerListeners() {
        PermissionCheckEvent.EVENT.register(this::onPermissionCheck);
        OptionRequestEvent.EVENT.register(this::onOptionRequest);
        OfflinePermissionCheckEvent.EVENT.register(this::onOfflinePermissionCheck);
    }

    private @NonNull TriState onPermissionCheck(class_2172 source, String permission) {
        class_1297 entity;
        if (source instanceof class_2168 && (entity = ((class_2168)source).method_9228()) instanceof class_3222) {
            return this.playerPermissionCheck((class_3222)entity, permission);
        }
        return this.otherPermissionCheck(source, permission);
    }

    private @NonNull Optional<String> onOptionRequest(class_2172 source, String key) {
        class_1297 entity;
        if (source instanceof class_2168 && (entity = ((class_2168)source).method_9228()) instanceof class_3222) {
            return this.playerGetOption((class_3222)entity, key);
        }
        return this.otherGetOption(source, key);
    }

    private @NonNull CompletableFuture<TriState> onOfflinePermissionCheck(UUID uuid, String permission) {
        return this.lookupUser(uuid).thenApplyAsync(user -> {
            PermissionCache permissionData = user.getCachedData().getPermissionData();
            return FabricPermissionsApiListener.fabricTristate(permissionData.checkPermission(permission, CheckOrigin.PLATFORM_API_HAS_PERMISSION).result());
        });
    }

    public CompletableFuture<User> lookupUser(UUID uuid) {
        User user = (User)this.plugin.getUserManager().getIfLoaded(uuid);
        if (user != null) {
            return CompletableFuture.completedFuture(user);
        }
        return this.plugin.getStorage().loadUser(uuid, null);
    }

    private TriState playerPermissionCheck(class_3222 player, String permission) {
        return FabricPermissionsApiListener.fabricTristate(((MixinUser)player).hasPermission(permission));
    }

    private TriState otherPermissionCheck(class_2172 source, String permission) {
        if (source instanceof class_2168) {
            String name = ((class_2168)source).method_9214();
            VerboseCheckTarget target = VerboseCheckTarget.internal(name);
            this.plugin.getVerboseHandler().offerPermissionCheckEvent(CheckOrigin.PLATFORM_API_HAS_PERMISSION, target, QueryOptionsImpl.DEFAULT_CONTEXTUAL, permission, TristateResult.UNDEFINED);
            this.plugin.getPermissionRegistry().offer(permission);
        }
        return TriState.DEFAULT;
    }

    private Optional<String> playerGetOption(class_3222 player, String key) {
        return Optional.ofNullable(((MixinUser)player).getOption(key));
    }

    private Optional<String> otherGetOption(class_2172 source, String key) {
        if (source instanceof class_2168) {
            String name = ((class_2168)source).method_9214();
            VerboseCheckTarget target = VerboseCheckTarget.internal(name);
            this.plugin.getVerboseHandler().offerMetaCheckEvent(CheckOrigin.PLATFORM_API, target, QueryOptionsImpl.DEFAULT_CONTEXTUAL, key, StringResult.nullResult());
        }
        return Optional.empty();
    }

    private static TriState fabricTristate(Tristate tristate) {
        switch (tristate) {
            case TRUE: {
                return TriState.TRUE;
            }
            case FALSE: {
                return TriState.FALSE;
            }
            case UNDEFINED: {
                return TriState.DEFAULT;
            }
        }
        throw new AssertionError();
    }
}

