/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.internal;

import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.internal.ExtendedChunk;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.forge.internal.TileEntityUtils;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.block.BlockState;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;

public class ForgeWorldNativeAccess
implements WorldNativeAccess<LevelChunk, net.minecraft.world.level.block.state.BlockState, BlockPos> {
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private final WeakReference<ServerLevel> world;
    private SideEffectSet sideEffectSet;

    public ForgeWorldNativeAccess(WeakReference<ServerLevel> world) {
        this.world = world;
    }

    private ServerLevel getWorld() {
        return Objects.requireNonNull((ServerLevel)this.world.get(), "The reference to the world was lost");
    }

    @Override
    public void setCurrentSideEffectSet(SideEffectSet sideEffectSet) {
        this.sideEffectSet = sideEffectSet;
    }

    @Override
    public LevelChunk getChunk(int x, int z) {
        return this.getWorld().m_6325_(x, z);
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState toNative(BlockState state) {
        int stateId = BlockStateIdAccess.getBlockStateId(state);
        return BlockStateIdAccess.isValidInternalId(stateId) ? Block.m_49803_((int)stateId) : ForgeAdapter.adapt(state);
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState getBlockState(LevelChunk chunk, BlockPos position) {
        return chunk.m_8055_(position);
    }

    @Override
    @Nullable
    public net.minecraft.world.level.block.state.BlockState setBlockState(LevelChunk chunk, BlockPos position, net.minecraft.world.level.block.state.BlockState state) {
        if (chunk instanceof ExtendedChunk) {
            return ((ExtendedChunk)chunk).setBlockState(position, state, false, this.sideEffectSet.shouldApply(SideEffect.UPDATE));
        }
        return chunk.m_6978_(position, state, false);
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState getValidBlockForPosition(net.minecraft.world.level.block.state.BlockState block, BlockPos position) {
        return Block.m_49931_((net.minecraft.world.level.block.state.BlockState)block, (LevelAccessor)this.getWorld(), (BlockPos)position);
    }

    @Override
    public BlockPos getPosition(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @Override
    public void updateLightingForBlock(BlockPos position) {
        this.getWorld().m_7726_().m_7827_().m_7174_(position);
    }

    @Override
    public boolean updateTileEntity(BlockPos position, com.sk89q.jnbt.CompoundTag tag) {
        CompoundTag nativeTag = NBTConverter.toNative(tag);
        return TileEntityUtils.setTileEntity((Level)this.getWorld(), position, nativeTag);
    }

    @Override
    public void notifyBlockUpdate(LevelChunk chunk, BlockPos position, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        if (chunk.m_7103_()[this.getWorld().m_151564_(position.m_123342_())] != null) {
            this.getWorld().m_7260_(position, oldState, newState, 3);
        }
    }

    @Override
    public boolean isChunkTicking(LevelChunk chunk) {
        return chunk.m_287138_().m_287205_(FullChunkStatus.BLOCK_TICKING);
    }

    @Override
    public void markBlockChanged(LevelChunk chunk, BlockPos position) {
        if (chunk.m_7103_()[this.getWorld().m_151564_(position.m_123342_())] != null) {
            this.getWorld().m_7726_().m_8450_(position);
        }
    }

    @Override
    public void notifyNeighbors(BlockPos pos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        ServerLevel world = this.getWorld();
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS)) {
            world.m_46672_(pos, oldState.m_60734_());
        } else {
            Block block = oldState.m_60734_();
            world.m_46586_(pos.m_122024_(), block, pos);
            world.m_46586_(pos.m_122029_(), block, pos);
            world.m_46586_(pos.m_7495_(), block, pos);
            world.m_46586_(pos.m_7494_(), block, pos);
            world.m_46586_(pos.m_122012_(), block, pos);
            world.m_46586_(pos.m_122019_(), block, pos);
        }
        if (newState.m_60807_()) {
            world.m_46717_(pos, newState.m_60734_());
        }
    }

    @Override
    public void updateBlock(BlockPos pos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        ServerLevel world = this.getWorld();
        newState.m_60696_((Level)world, pos, oldState, false);
    }

    @Override
    public void updateNeighbors(BlockPos pos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState, int recursionLimit) {
        ServerLevel world = this.getWorld();
        oldState.m_60762_((LevelAccessor)world, pos, 2, recursionLimit);
        newState.m_60705_((LevelAccessor)world, pos, 2, recursionLimit);
        newState.m_60762_((LevelAccessor)world, pos, 2, recursionLimit);
    }

    @Override
    public void onBlockStateChange(BlockPos pos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        this.getWorld().m_6559_(pos, oldState, newState);
        newState.onBlockStateChange((LevelReader)this.getWorld(), pos, oldState);
    }
}

