/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.inventorymanagement.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.roundaround.inventorymanagement.roundalib.config.ModConfig;
import me.roundaround.inventorymanagement.roundalib.config.option.ConfigOption;
import me.roundaround.inventorymanagement.roundalib.config.value.Position;
import me.roundaround.inventorymanagement.roundalib.shadow.nightconfig.core.Config;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class PerScreenPositionConfigOption
extends ConfigOption<Map<String, Position>, Builder> {
    public PerScreenPositionConfigOption(Builder builder) {
        super(builder);
    }

    private PerScreenPositionConfigOption(PerScreenPositionConfigOption other) {
        super(other);
    }

    public void set(class_437 screen, boolean isPlayerInventory, Position value) {
        String key = this.getScreenKey(screen, isPlayerInventory);
        ((Map)this.getValue()).put(key, value);
    }

    public void remove(class_437 screen, boolean isPlayerInventory) {
        String key = this.getScreenKey(screen, isPlayerInventory);
        ((Map)this.getValue()).remove(key);
    }

    public Optional<Position> get(class_437 screen, boolean isPlayerInventory) {
        String key;
        Map value = (Map)this.getValue();
        if (value.containsKey(key = this.getScreenKey(screen, isPlayerInventory))) {
            return Optional.of((Position)value.get(key));
        }
        return Optional.empty();
    }

    public String getScreenKey(class_437 screen, boolean isPlayerInventory) {
        return screen.getClass().getName().replaceAll("\\.", "-") + (isPlayerInventory ? "-player" : "-container");
    }

    @Override
    public void deserialize(Object data) {
        Config deserialized = (Config)data;
        Map<String, Object> deserializedMap = deserialized.valueMap();
        HashMap<String, Position> value = new HashMap<String, Position>();
        for (String key : deserializedMap.keySet()) {
            value.put(key, Position.deserialize((String)deserialized.get(key)));
        }
        Map defaultValue = (Map)this.getDefault();
        for (String key : defaultValue.keySet()) {
            value.putIfAbsent(key, (Position)defaultValue.get(key));
        }
        this.setValue(value);
    }

    @Override
    public Object serialize() {
        Config serialized = Config.inMemory();
        Map value = (Map)this.getValue();
        for (String key : value.keySet()) {
            serialized.set(key, (Object)Position.serialize((Position)value.get(key)));
        }
        return serialized;
    }

    public PerScreenPositionConfigOption copy() {
        return new PerScreenPositionConfigOption(this);
    }

    public static Builder builder(ModConfig config, String id, String labelI18nKey) {
        return new Builder(config, id, labelI18nKey);
    }

    public static Builder builder(ModConfig config, String id, class_2561 label) {
        return new Builder(config, id, label);
    }

    public static class Builder
    extends ConfigOption.AbstractBuilder<Map<String, Position>, Builder> {
        private Builder(ModConfig config, String id, class_2561 label) {
            super(config, id, label, new HashMap());
        }

        private Builder(ModConfig config, String id, String labelI18nKey) {
            super(config, id, labelI18nKey, new HashMap());
        }

        public Builder addDefaultEntry(String key, Position position) {
            ((Map)this.defaultValue).put(key, position);
            return this;
        }

        public PerScreenPositionConfigOption build() {
            return new PerScreenPositionConfigOption(this);
        }
    }
}

