/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.integration.BorderIntegration;
import org.popcraft.chunky.integration.Integration;
import org.popcraft.chunky.platform.Border;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;

public class WorldBorderCommand
implements ChunkyCommand {
    private final Chunky chunky;

    public WorldBorderCommand(Chunky chunky) {
        this.chunky = chunky;
    }

    @Override
    public void execute(Sender sender, CommandArguments arguments) {
        Selection previous;
        if (arguments.size() > 0) {
            Optional world = arguments.next().flatMap(arg -> Input.tryWorld(this.chunky, arg));
            if (world.isPresent()) {
                this.chunky.getSelection().world((World)world.get());
            } else {
                sender.sendMessage("help_worldborder", new Object[0]);
                return;
            }
        }
        if (!this.setBorderViaIntegration((previous = this.chunky.getSelection().build()).world())) {
            this.chunky.getSelection().worldborder();
        }
        Selection current = this.chunky.getSelection().build();
        sender.sendMessagePrefixed("format_center", Formatting.number(current.centerX()), Formatting.number(current.centerZ()));
        if (current.radiusX() == current.radiusZ()) {
            sender.sendMessagePrefixed("format_radius", Formatting.number(current.radiusX()));
        } else {
            sender.sendMessagePrefixed("format_radii", Formatting.number(current.radiusX()), Formatting.number(current.radiusZ()));
        }
        if (!previous.shape().equals(current.shape())) {
            sender.sendMessagePrefixed("format_shape", current.shape());
        }
        if (current.radiusX() > (double)this.chunky.getServer().getMaxWorldSize()) {
            sender.sendMessagePrefixed("format_worldborder_too_large", this.chunky.getServer().getMaxWorldSize());
        }
    }

    @Override
    public List<String> suggestions(CommandArguments arguments) {
        if (arguments.size() == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunky.getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        return List.of();
    }

    boolean setBorderViaIntegration(World world) {
        String worldName;
        BorderIntegration worldborder;
        Map<String, Integration> integrations = this.chunky.getServer().getIntegrations();
        if (integrations.containsKey("border") && (worldborder = (BorderIntegration)integrations.get("border")).hasBorder(worldName = world.getName())) {
            Border border = worldborder.getBorder(worldName);
            Vector2 center = border.getCenter();
            this.chunky.getSelection().center(center.getX(), center.getZ()).radiusX(border.getRadiusX()).radiusZ(border.getRadiusZ()).shape(border.getShape());
            return true;
        }
        return false;
    }
}

