/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.client.screen;

import com.kryeit.Missions;
import com.kryeit.client.ClientMissionData;
import com.kryeit.client.ClientsideMissionPacketUtils;
import com.kryeit.client.screen.MissionRerollScreen;
import com.kryeit.client.screen.button.InfoButton;
import com.kryeit.client.screen.button.MissionButton;
import com.kryeit.client.screen.button.RewardsButton;
import com.kryeit.missions.mission_types.create.train.TrainDriverPassengerMission;
import com.kryeit.utils.Utils;
import com.simibubi.create.foundation.utility.Components;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class MissionScreen
extends class_437 {
    public static final class_2960 MISSIONS_TITLE = Missions.asResource("textures/gui/title.png");
    public static final class_2561 CLOSE = Components.translatable((String)"missions.menu.close");
    private ClientMissionData data = null;

    public MissionScreen() {
        super(class_2561.method_30163((String)""));
    }

    protected void method_25426() {
        super.method_25426();
        class_310.method_1551().method_1562().method_2883((class_2596)new class_2799(class_2799.class_2800.field_12775));
        ClientsideMissionPacketUtils.setMissionUpdateHandler(missionData -> {
            this.data = missionData;
        });
        ClientsideMissionPacketUtils.requestMissions();
        this.createCloseButton();
    }

    private void addMissions(ClientMissionData data) {
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 5;
        int leftX = this.field_22789 / 2 - buttonWidth - spacing;
        int rightX = this.field_22789 / 2 + spacing;
        List<ClientMissionData.ClientsideActiveMission> activeMissions = data.activeMissions();
        if (activeMissions.size() != 10) {
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)Components.translatable((String)"Something wrong happened, you don't have 10 missions. Contact an admin"));
            return;
        }
        int missionsPerColumn = 5;
        for (int i = 0; i < missionsPerColumn; ++i) {
            int y = (this.field_22790 - (missionsPerColumn * buttonHeight + (missionsPerColumn - 1) * spacing)) / 2 + i * (buttonHeight + spacing);
            ClientMissionData.ClientsideActiveMission leftColumnMission = activeMissions.get(i);
            class_2561 leftColumnTitle = leftColumnMission.titleString();
            this.method_37063((class_364)this.createMissionButton(leftX, y, leftColumnTitle, leftColumnMission, i, data.rerollPrice()));
            if (i + missionsPerColumn >= activeMissions.size()) continue;
            ClientMissionData.ClientsideActiveMission rightColumnMission = activeMissions.get(i + missionsPerColumn);
            class_2561 rightColumnTitle = rightColumnMission.titleString();
            this.method_37063((class_364)this.createMissionButton(rightX, y, rightColumnTitle, rightColumnMission, i + missionsPerColumn, data.rerollPrice()));
        }
        this.createInfoButton();
        this.createRewardButton(data.hasUnclaimedRewards());
    }

    private MissionButton createMissionButton(int x, int y, class_2561 title, ClientMissionData.ClientsideActiveMission mission, int index, class_1799 rerollPrice) {
        return new MissionButton(x, y, title, mission, button -> {
            if (!mission.isCompleted() && rerollPrice.method_7909() != class_1802.field_8162) {
                class_310.method_1551().method_1507((class_437)new MissionRerollScreen(index, rerollPrice, mission.difficulty()));
            }
        });
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        if (this.data != null) {
            this.addMissions(this.data);
            this.data = null;
        }
        guiGraphics.method_27534(class_310.method_1551().field_1772, this.field_22785, this.field_22789 / 2, 40, 0xFFFFFF);
        this.renderTitle(guiGraphics);
    }

    public void renderTitle(class_332 guiGraphics) {
        guiGraphics.method_25293(MISSIONS_TITLE, this.field_22789 / 2 - 100, this.field_22790 / 35, 200, 44, 0.0f, 0.0f, 256, 56, 256, 256);
    }

    public static List<class_2561> getTooltip(ClientMissionData.ClientsideActiveMission mission) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        DecimalFormatSymbols symbols = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
        symbols.setGroupingSeparator(',');
        symbols.setDecimalSeparator('.');
        ((DecimalFormat)numberFormat).setDecimalFormatSymbols(symbols);
        String requiredAmount = numberFormat.format(mission.requiredAmount());
        class_5250 progress = mission.isCompleted() ? Components.translatable((String)"missions.menu.main.tooltip.progress.completed") : Components.translatable((String)(numberFormat.format(mission.progress()) + "/" + requiredAmount));
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        components.add((class_2561)Components.translatable((String)"missions.menu.main.tooltip.details").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065}));
        String itemName = Utils.removeBrackets(mission.itemRequired().method_7954().getString());
        if (class_1802.field_8162 == mission.itemRequired().method_7909()) {
            if (Objects.equals(mission.missionType(), "train-driver-passenger")) {
                components.add(Utils.getMissionMessage(mission, class_124.field_1068, requiredAmount, TrainDriverPassengerMission.passengersNeeded()));
            } else {
                components.add(Utils.getMissionMessage(mission, class_124.field_1068, requiredAmount));
            }
        } else if (mission.itemRequired().method_7909() instanceof class_1826) {
            components.add(Utils.getMissionMessage(mission, class_124.field_1068, requiredAmount, Utils.getEntityOfSpawnEggForTooltip(mission.itemRequired())));
        } else if (mission.itemRequired().method_7909() instanceof class_1755) {
            components.add(Utils.getMissionMessage(mission, class_124.field_1068, Utils.getFluidFromBucketForTooltip(mission.itemRequired()), requiredAmount));
        } else {
            components.add(Utils.getMissionMessage(mission, class_124.field_1068, requiredAmount, itemName));
        }
        if (!mission.isCompleted()) {
            components.add((class_2561)Components.translatable((String)"missions.menu.main.tooltip.reward", (Object[])new Object[]{mission.rewardAmount(), Utils.removeBrackets(((class_1792)class_7923.field_41178.method_10223(new class_2960(mission.rewardItemLocation()))).method_7854().method_7954().getString())}).method_27692(class_124.field_1076));
        }
        components.add((class_2561)Components.translatable((String)"missions.menu.main.tooltip.progress", (Object[])new Object[]{progress}).method_27692(class_124.field_1060));
        if (!mission.isCompleted()) {
            components.add((class_2561)class_2561.method_43471((String)"missions.menu.main.tooltip.click").method_27692(class_124.field_1063).method_27692(class_124.field_1056));
        }
        return components;
    }

    public boolean method_25421() {
        return false;
    }

    public void createCloseButton() {
        int spacing = 5;
        int buttonWidth = 100;
        int buttonHeight = 20;
        int bottomPadding = 20;
        int x = this.field_22789 / 2 - buttonWidth - spacing - 20;
        int y = this.field_22790 - buttonHeight - bottomPadding;
        this.method_37063((class_364)class_4185.method_46430((class_2561)CLOSE, button -> class_310.method_1551().method_1507(null)).method_46434(x, y, buttonWidth, buttonHeight).method_46431());
    }

    public void createInfoButton() {
        int buttonWidth = 20;
        int buttonHeight = 20;
        int bottomPadding = 20;
        int x = this.field_22789 / 2 - buttonWidth / 2;
        int y = this.field_22790 - buttonHeight - bottomPadding;
        this.method_37063((class_364)new InfoButton(x, y, this));
    }

    public void createRewardButton(boolean rewardsAvailable) {
        int spacing = 5;
        int buttonHeight = 20;
        int bottomPadding = 20;
        int x = this.field_22789 / 2 + spacing + 20;
        int y = this.field_22790 - buttonHeight - bottomPadding;
        this.method_37063((class_364)new RewardsButton(x, y, rewardsAvailable));
    }
}

