/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.missions;

import com.kryeit.client.ClientMissionData;
import com.kryeit.missions.MissionType;
import com.kryeit.missions.MissionTypeRegistry;
import com.kryeit.missions.config.ConfigReader;
import com.kryeit.missions.config.Range;
import com.kryeit.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class DataStorage
implements AutoCloseable {
    private static final File FILE = new File("config/missions/mission_data.nbt");
    private final class_2487 data;

    public DataStorage() {
        try {
            FILE.getParentFile().mkdirs();
            if (!FILE.exists()) {
                this.data = new class_2487();
                this.save();
            } else {
                this.data = class_2507.method_30613((File)FILE);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() {
        try {
            class_2507.method_30614((class_2487)this.data, (File)FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2487 getMissionData(String missionID, UUID player) {
        class_2487 missionData = DataStorage.getOrCreateTag(this.data, "mission_data");
        class_2487 missionIDData = DataStorage.getOrCreateTag(missionData, missionID);
        if (missionIDData.method_10545(player.toString())) {
            return missionIDData.method_10562(player.toString());
        }
        class_2487 newTag = new class_2487();
        missionIDData.method_10566(player.toString(), (class_2520)newTag);
        return newTag;
    }

    private class_2499 getActiveMissionsTag(UUID player) {
        String uuidString = player.toString();
        class_2487 activeMissions = DataStorage.getOrCreateTag(this.data, "active_missions");
        return DataStorage.getOrCreateList(activeMissions, uuidString);
    }

    public List<ActiveMission> getActiveMissions(UUID player) {
        class_2499 list = this.getActiveMissionsTag(player);
        ArrayList<ActiveMission> output = new ArrayList<ActiveMission>();
        for (class_2520 tag : list) {
            output.add(new ActiveMission((class_2487)tag));
        }
        return output;
    }

    public void setCompleted(UUID player, class_2960 item, String missionTypeID) {
        for (class_2520 tag : this.getActiveMissionsTag(player)) {
            class_2487 compound = (class_2487)tag;
            if (!new class_2960(compound.method_10558("item")).equals((Object)item) || !compound.method_10558("mission_id").equals(missionTypeID) || compound.method_10577("completed")) continue;
            compound.method_10556("completed", true);
            break;
        }
    }

    private static List<ConfigReader.MissionTypeConfig> shuffleWeighted(Collection<ConfigReader.MissionTypeConfig> missionTypeConfigs, int length) {
        ArrayList<ConfigReader.MissionTypeConfig> shuffled = new ArrayList<ConfigReader.MissionTypeConfig>(length);
        LinkedList<ConfigReader.MissionTypeConfig> remaining = new LinkedList<ConfigReader.MissionTypeConfig>(missionTypeConfigs);
        for (int i = 0; i < length; ++i) {
            Predicate<ConfigReader.MissionTypeConfig> filter = missionTypeConfig -> !missionTypeConfig.missionType().assignOnlyOnce() || !shuffled.contains(missionTypeConfig) || remaining.stream().allMatch(m -> m.missionType().assignOnlyOnce());
            double totalWeight = remaining.stream().mapToDouble(ConfigReader.MissionTypeConfig::weight).sum();
            double randomNumber = Math.random() * totalWeight;
            double weightSum = 0.0;
            for (int j = 0; j < remaining.size(); ++j) {
                ConfigReader.MissionTypeConfig missionTypeConfig2 = (ConfigReader.MissionTypeConfig)remaining.get(j);
                if (!((weightSum += (double)missionTypeConfig2.weight()) >= randomNumber) || !filter.test(missionTypeConfig2)) continue;
                shuffled.add(missionTypeConfig2);
                if (!missionTypeConfig2.missionType().assignOnlyOnce()) break;
                remaining.remove(j);
                break;
            }
            if (!shuffled.isEmpty() || i != length - 1) continue;
            shuffled.add((ConfigReader.MissionTypeConfig)remaining.get(0));
        }
        return shuffled;
    }

    public void reassignActiveMissions(Map<MissionType, ConfigReader.MissionTypeConfig> missions, UUID player) {
        class_2499 list = this.getActiveMissionsTag(player);
        list.clear();
        for (ConfigReader.MissionTypeConfig missionTypeConfig : DataStorage.shuffleWeighted(missions.values(), 10)) {
            list.add((Object)DataStorage.createActiveMissionTag(missionTypeConfig));
        }
    }

    private static class_2487 createActiveMissionTag(ConfigReader.MissionTypeConfig missionTypeConfig) {
        class_2487 tag = new class_2487();
        ConfigReader.SubMissionConfig subMission = Utils.getRandomEntry(missionTypeConfig.subMissions());
        ConfigReader.Reward reward = Utils.getRandomEntry(subMission.rewards());
        Map.Entry<String, Range> requiredItem = Utils.getRandomEntry(subMission.items().entrySet());
        tag.method_10582("item", requiredItem.getKey());
        tag.method_10556("completed", false);
        tag.method_10582("mission_id", missionTypeConfig.missionType().id());
        tag.method_10569("required_amount", requiredItem.getValue().getRandomValue());
        tag.method_10582("title", Utils.getRandomEntry(subMission.titles()));
        tag.method_10582("reward_item", reward.item());
        tag.method_10569("reward_amount", reward.count().getRandomValue());
        return tag;
    }

    public void reassignActiveMission(Map<MissionType, ConfigReader.MissionTypeConfig> missions, UUID player, int index) {
        class_2499 list = this.getActiveMissionsTag(player);
        ArrayList<ConfigReader.MissionTypeConfig> assignableTypes = new ArrayList<ConfigReader.MissionTypeConfig>(missions.values());
        ConfigReader.MissionTypeConfig missionTypeConfig = DataStorage.shuffleWeighted(assignableTypes, 1).get(0);
        class_2487 newTag = DataStorage.createActiveMissionTag(missionTypeConfig);
        list.method_10606(index, (class_2520)newTag);
    }

    public int getReassignmentsSinceLastReset(UUID player) {
        class_2487 tag = DataStorage.getOrCreateTag(this.data, "reassignments");
        return tag.method_10550(player.toString());
    }

    public void incrementReassignmentsSinceLastReset(UUID player) {
        String uuid = player.toString();
        class_2487 tag = DataStorage.getOrCreateTag(this.data, "reassignments");
        tag.method_10569(uuid, tag.method_10550(uuid) + 1);
    }

    public void resetReassignments(UUID player) {
        class_2487 tag = DataStorage.getOrCreateTag(this.data, "reassignments");
        tag.method_10569(player.toString(), 0);
    }

    public int getLastAssignedDay(UUID player) {
        return this.data.method_10562("last_assigned").method_10550(player.toString());
    }

    public void setLastAssignedDay(UUID player) {
        this.setLastAssignedDay(player, Utils.getDay());
    }

    public void setLastAssignedDay(UUID player, int day) {
        class_2487 lastAssigned = DataStorage.getOrCreateTag(this.data, "last_assigned");
        lastAssigned.method_10569(player.toString(), day);
    }

    public void addReward(UUID player, String item, int amount) {
        class_2487 rewards = DataStorage.getOrCreateTag(this.data, "rewards");
        class_2487 playerRewards = DataStorage.getOrCreateTag(rewards, player.toString());
        playerRewards.method_10569(item, playerRewards.method_10550(item) + amount);
    }

    public Map<String, Integer> getUnclaimedRewards(UUID player) {
        class_2487 rewards = DataStorage.getOrCreateTag(this.data, "rewards");
        HashMap<String, Integer> output = new HashMap<String, Integer>();
        class_2487 playerRewards = rewards.method_10562(player.toString());
        for (String key : playerRewards.method_10541()) {
            output.put(key, playerRewards.method_10550(key));
        }
        return output;
    }

    public void claimRewards(UUID player) {
        this.data.method_10562("rewards").method_10551(player.toString());
    }

    private static class_2487 getOrCreateTag(class_2487 tag, String key) {
        class_2487 compound = tag.method_10562(key);
        if (!tag.method_10545(key)) {
            tag.method_10566(key, (class_2520)compound);
        }
        return compound;
    }

    private static class_2499 getOrCreateList(class_2487 tag, String key) {
        class_2499 list = tag.method_10554(key, 10);
        if (!tag.method_10545(key)) {
            tag.method_10566(key, (class_2520)list);
        }
        return list;
    }

    @Override
    public void close() {
        this.save();
    }

    public static class ActiveMission {
        private final class_2960 item;
        private final boolean isCompleted;
        private final String missionID;
        private final int requiredAmount;
        private final String title;
        private final String rewardItem;
        private final int rewardAmount;

        public int rewardAmount() {
            return this.rewardAmount;
        }

        public String rewardItem() {
            return this.rewardItem;
        }

        private ActiveMission(class_2960 item, boolean isCompleted, String missionID, int requiredAmount, String title, String rewardItem, int rewardAmount) {
            this.item = item;
            this.isCompleted = isCompleted;
            this.missionID = missionID;
            this.requiredAmount = requiredAmount;
            this.title = title;
            this.rewardItem = rewardItem;
            this.rewardAmount = rewardAmount;
        }

        private ActiveMission(class_2487 tag) {
            this(new class_2960(tag.method_10558("item")), tag.method_10577("completed"), tag.method_10558("mission_id"), tag.method_10550("required_amount"), tag.method_10558("title"), tag.method_10558("reward_item"), tag.method_10550("reward_amount"));
        }

        public int requiredAmount() {
            return this.requiredAmount;
        }

        public String missionID() {
            return this.missionID;
        }

        public boolean isCompleted() {
            return this.isCompleted;
        }

        public class_2960 item() {
            return this.item;
        }

        public ClientMissionData.ClientsideActiveMission toClientMission(UUID player) {
            MissionType type = MissionTypeRegistry.INSTANCE.getType(this.missionID());
            return new ClientMissionData.ClientsideActiveMission(class_2561.method_30163((String)this.title), type.difficulty(), this.requiredAmount(), this.missionID(), type.getProgress(player, this.item()), type.getPreviewStack(this.item()), type.getItemStack(this.item()), type.description(), this.isCompleted(), this.rewardAmount, this.rewardItem);
        }
    }
}

