/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.init;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.chipped.ChippedCompat;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.litematica.LitematicaCompat;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.mkb.ModernKeyBindingCompat;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.trinkets.TrinketsCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;

public class ModCompat {
    private static final Map<String, Supplier<Callable<ICompat>>> compatFactories = new HashMap<String, Supplier<Callable<ICompat>>>();
    private static final Map<String, ICompat> loadedCompats = new HashMap<String, ICompat>();

    private ModCompat() {
    }

    public static void compatsSetup() {
        loadedCompats.values().forEach(ICompat::setup);
    }

    public static void initCompats() {
        for (Map.Entry<String, Supplier<Callable<ICompat>>> entry : compatFactories.entrySet()) {
            if (!FabricLoader.getInstance().isModLoaded(entry.getKey())) continue;
            try {
                loadedCompats.put(entry.getKey(), entry.getValue().get().call());
            }
            catch (Exception e) {
                SophisticatedBackpacks.LOGGER.error("Error instantiating compatibility ", (Throwable)e);
            }
        }
        loadedCompats.values().forEach(ICompat::init);
    }

    static {
        compatFactories.put("trinkets", () -> TrinketsCompat::new);
        compatFactories.put("chipped", () -> ChippedCompat::new);
        compatFactories.put("litematica", () -> LitematicaCompat::new);
        compatFactories.put("mkb", () -> ModernKeyBindingCompat::new);
    }
}

