/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.dynlight.lamb;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import top.leonx.dynlight.config.CreateDynLightAllConfigs;
import top.leonx.dynlight.lamb.LambDynLightsDelegate;

public abstract class CreateDynLightSource {
    private final AbstractContraptionEntity contraptionEntity;
    private final class_2338 localPos;
    private class_243 lastPosition;
    private class_243 position;
    private int luminance;
    private int lastLuminance;
    private final int id;
    private long lambDynLightsLastUpdate;
    private class_1923 chunkPosition;
    private class_2338 blockPos;
    private LongOpenHashSet lambdynlights$trackedLitChunkPos = new LongOpenHashSet();

    public CreateDynLightSource(int id, AbstractContraptionEntity entity, class_2338 localPos, int luminance) {
        this.contraptionEntity = entity;
        this.id = id;
        this.luminance = luminance;
        this.lastPosition = class_243.field_1353;
        this.localPos = localPos;
        class_243 worldPos = entity.toGlobalVector(VecHelper.getCenterOf((class_2382)localPos), 1.0f);
        this.setPosition(worldPos);
    }

    private void setPosition(class_243 position) {
        this.position = position;
        int x = class_3532.method_15357((double)position.method_10216());
        int y = class_3532.method_15357((double)position.method_10214());
        int z = class_3532.method_15357((double)position.method_10215());
        this.blockPos = new class_2338(x, y, z);
        this.chunkPosition = new class_1923(this.blockPos);
    }

    public class_2338 blockPosition() {
        return this.blockPos;
    }

    public double getDynamicLightX() {
        return this.position.field_1352;
    }

    public double getDynamicLightY() {
        return this.position.field_1351;
    }

    public double getDynamicLightZ() {
        return this.position.field_1350;
    }

    public class_1937 getDynamicLightWorld() {
        return this.contraptionEntity.method_37908();
    }

    public void resetDynamicLight() {
        this.luminance = 0;
    }

    public int getLuminance() {
        return (int)((double)this.luminance * (Double)CreateDynLightAllConfigs.client().luminanceMultiplier.get());
    }

    public void dynamicLightTick() {
    }

    public void syncPositionAndLuminance() {
        if (this.contraptionEntity.method_37908() == class_310.method_1551().field_1687) {
            int newLuminance;
            class_243 newPosition = this.contraptionEntity.toGlobalVector(VecHelper.getCenterOf((class_2382)this.localPos), 1.0f);
            this.setPosition(newPosition);
            class_3499.class_3501 blockInfo = (class_3499.class_3501)this.contraptionEntity.getContraption().getBlocks().get(this.localPos);
            if (blockInfo != null && (newLuminance = blockInfo.comp_1342().method_26213()) != this.luminance) {
                this.luminance = newLuminance;
            }
        }
    }

    public boolean shouldUpdateDynamicLight() {
        if (!((Boolean)CreateDynLightAllConfigs.client().enableLambDynamicLight.get()).booleanValue() || !LambDynLightsDelegate.getDynamicLightsModeEnabled()) {
            return false;
        }
        int delay = CreateDynLightAllConfigs.client().getUpdateInterval();
        if (delay > 0) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lambDynLightsLastUpdate + (long)delay) {
                return false;
            }
            this.lambDynLightsLastUpdate = currentTime;
        }
        return true;
    }

    public boolean lambdynlights$updateDynamicLight(@NotNull class_761 renderer) {
        if (!this.shouldUpdateDynamicLight()) {
            return false;
        }
        this.syncPositionAndLuminance();
        double deltaX = this.position.method_10216() - this.lastPosition.method_10216();
        double deltaY = this.position.method_10214() - this.lastPosition.method_10214();
        double deltaZ = this.position.method_10215() - this.lastPosition.method_10215();
        int luminance = this.getLuminance();
        if (Math.abs(deltaX) > 0.1 || Math.abs(deltaY) > 0.1 || Math.abs(deltaZ) > 0.1 || luminance != this.lastLuminance) {
            this.lastPosition = new class_243(this.position.method_10216(), this.position.method_10214(), this.position.method_10215());
            this.lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                class_1923 entityChunkPos = this.chunkPosition;
                class_2338.class_2339 chunkPos = new class_2338.class_2339(entityChunkPos.field_9181, class_4076.method_32204((double)this.position.field_1351), entityChunkPos.field_9180);
                LambDynLightsDelegate.scheduleChunkRebuild(renderer, chunkPos);
                LambDynLightsDelegate.updateTrackedChunks(chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                class_2350 directionX = (this.blockPosition().method_10263() & 0xF) >= 8 ? class_2350.field_11034 : class_2350.field_11039;
                class_2350 directionY = (this.blockPosition().method_10264() & 0xF) >= 8 ? class_2350.field_11036 : class_2350.field_11033;
                class_2350 directionZ = (this.blockPosition().method_10260() & 0xF) >= 8 ? class_2350.field_11035 : class_2350.field_11043;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.method_10098(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.method_10098(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.method_10098(directionX.method_10153());
                    } else {
                        chunkPos.method_10098(directionZ.method_10153());
                        chunkPos.method_10098(directionY);
                    }
                    LambDynLightsDelegate.scheduleChunkRebuild(renderer, chunkPos);
                    LambDynLightsDelegate.updateTrackedChunks(chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                }
            }
            this.lambdynlights$scheduleTrackedChunksRebuild(renderer);
            this.lambdynlights$trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    public void lambdynlights$scheduleTrackedChunksRebuild(@NotNull class_761 renderer) {
        if (this.contraptionEntity.method_37908() == class_310.method_1551().field_1687) {
            LongIterator longIterator = this.lambdynlights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LambDynLightsDelegate.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

