/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createcobblestone.CreateCobblestoneMod;
import net.createcobblestone.index.Config;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class GeneratorType {
    private static final Map<String, GeneratorType> ID_TO_TYPE = new HashMap<String, GeneratorType>();
    private static final Map<class_2960, GeneratorType> BLOCK_TO_TYPE = new HashMap<class_2960, GeneratorType>();
    private final String id;
    private final class_2960 block;
    private final int generatorStress;
    private final float outputPerSecondPerRpm;
    private final int generatorStorage;
    public static GeneratorType NONE;

    public static void init() {
        ID_TO_TYPE.clear();
        BLOCK_TO_TYPE.clear();
        CreateCobblestoneMod.LOGGER.info("Generator types cleared");
        NONE = GeneratorType.initializeNewType("none", class_2246.field_10124.arch$registryName(), -1, -1.0f, -1);
    }

    public static GeneratorType initializeNewType(String id, class_2960 block, int generatorStress, float outputPerSecondPerRpm, int generatorStorage) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Generator type ID cannot be null or empty");
        }
        id = id.toLowerCase();
        if (BLOCK_TO_TYPE.get(block) != null) {
            CreateCobblestoneMod.LOGGER.error("Error initializing generator, generator type with block {} already exists (existing id: {}, new id: {})", new Object[]{block, BLOCK_TO_TYPE.get(block).getId(), id});
            return BLOCK_TO_TYPE.get(block);
        }
        GeneratorType type = new GeneratorType(id, block, generatorStress, outputPerSecondPerRpm, generatorStorage);
        ID_TO_TYPE.put(id.toLowerCase(), type);
        BLOCK_TO_TYPE.put(block, type);
        if (((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) {
            CreateCobblestoneMod.LOGGER.info("Generator type {} initialized with block {}", (Object)id, (Object)block);
        }
        return type;
    }

    private GeneratorType(String id, class_2960 block, int generatorStress, float outputPerSecondPerRpm, int generatorStorage) {
        this.id = id;
        this.block = block;
        this.generatorStress = generatorStress;
        this.outputPerSecondPerRpm = outputPerSecondPerRpm;
        this.generatorStorage = generatorStorage;
    }

    public int getGeneratorStress() {
        if (this.generatorStress == -1) {
            return (Integer)Config.common().generatorStress.get();
        }
        return this.generatorStress;
    }

    public float getOutputPerSecondPerRpm() {
        if (this.outputPerSecondPerRpm == -1.0f) {
            return ((Double)Config.common().outputPerSecondPerRpm.get()).floatValue();
        }
        return this.outputPerSecondPerRpm;
    }

    public int getStorage() {
        if (this.generatorStorage == -1) {
            return (Integer)Config.common().maxStorage.get();
        }
        return this.generatorStorage;
    }

    public String getId() {
        return this.id;
    }

    public class_2248 getBlock() throws NullPointerException {
        return (class_2248)class_7923.field_41175.method_10223(this.block);
    }

    public class_1792 getItem() throws NullPointerException {
        return this.getBlock().method_8389();
    }

    public boolean isLoaded() {
        return ID_TO_TYPE.get(this.id) != null;
    }

    @NotNull
    public static GeneratorType fromId(String id) {
        GeneratorType type = GeneratorType.ensureType(ID_TO_TYPE.get(id.toLowerCase()));
        if (type == NONE) {
            switch (id.toLowerCase()) {
                case "cobblestone": {
                    id = "createcobblestone:generator_types/cobblestone.json";
                    break;
                }
                case "stone": {
                    id = "createcobblestone:generator_types/stone.json";
                    break;
                }
                case "basalt": {
                    id = "createcobblestone:generator_types/basalt.json";
                    break;
                }
                case "limestone": {
                    id = "createcobblestone:generator_types/limestone.json";
                    break;
                }
                case "scoria": {
                    id = "createcobblestone:generator_types/scoria.json";
                    break;
                }
                case "deepslate": {
                    id = "createcobblestone:generator_types/deepslate.json";
                    break;
                }
                case "cobbled_deepslate": {
                    id = "createcobblestone:generator_types/cobbled_deepslate.json";
                }
            }
            type = GeneratorType.ensureType(ID_TO_TYPE.get(id));
            if (type == NONE && id.equals("createcobblestone:generator_types/deepslate.json") || id.equals("createcobblestone:generator_types/cobbled_deepslate.json")) {
                CreateCobblestoneMod.LOGGER.error("Deepslate generators are now added using a data pack. Please install it from the mod page. (generator: {})", (Object)id);
            }
        }
        return type;
    }

    @NotNull
    public static GeneratorType fromBlock(class_2248 block) {
        return GeneratorType.ensureType(BLOCK_TO_TYPE.get(block.arch$registryName()));
    }

    @NotNull
    public static GeneratorType fromItem(class_1792 item) {
        return GeneratorType.ensureType(BLOCK_TO_TYPE.get(item.arch$registryName()));
    }

    public static List<GeneratorType> getTypes() {
        return new ArrayList<GeneratorType>(ID_TO_TYPE.values());
    }

    @NotNull
    private static GeneratorType ensureType(GeneratorType type) {
        return type == null ? NONE : type;
    }
}

