/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class CBCJsonResourceReloadListener
extends class_4080<Multimap<class_2960, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Gson gson;
    private final String directory;

    public CBCJsonResourceReloadListener(Gson gson, String directory) {
        this.gson = gson;
        this.directory = directory;
    }

    protected Multimap<class_2960, JsonElement> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMultimap map = HashMultimap.create();
        int i = this.directory.length() + 1;
        for (Map.Entry entry : resourceManager.method_14488(this.directory, path -> path.method_12832().endsWith(".json")).entrySet()) {
            class_2960 loco = (class_2960)entry.getKey();
            String string = loco.method_12832();
            class_2960 loc2 = CBCUtils.location(loco.method_12836(), string.substring(i, string.length() - PATH_SUFFIX_LENGTH));
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonElement.class);
                    if (jsonElement != null) {
                        map.put((Object)loc2, (Object)jsonElement);
                        continue;
                    }
                    LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)loc2, (Object)loco);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var20) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{loc2, loco, var20});
            }
        }
        return map;
    }
}

