/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_armor_properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import rbasamoyai.createbigcannons.base.BlockStatePredicateHelper;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.block_armor_properties.SimpleBlockArmorProperties;

public record VariantBlockArmorProperties(SimpleBlockArmorProperties defaultProperties, Map<class_2680, SimpleBlockArmorProperties> propertiesByState) implements BlockArmorPropertiesProvider
{
    @Override
    public double hardness(class_1937 level, class_2680 state, class_2338 pos, boolean recurse) {
        return this.propertiesByState.getOrDefault(state, this.defaultProperties).hardness(level, state, pos, recurse);
    }

    @Override
    public double toughness(class_1937 level, class_2680 state, class_2338 pos, boolean recurse) {
        return this.propertiesByState.getOrDefault(state, this.defaultProperties).toughness(level, state, pos, recurse);
    }

    @Override
    public List<class_2680> containedBlockStates(class_1937 level, class_2680 state, class_2338 pos, boolean recurse) {
        return List.of(state);
    }

    public static VariantBlockArmorProperties fromJson(class_2248 block, JsonObject obj) {
        class_2689 definition = block.method_9595();
        HashSet states = new HashSet(definition.method_11662());
        Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
        if (obj.has("variants") && obj.get("variants").isJsonObject()) {
            JsonObject variants = obj.getAsJsonObject("variants");
            for (String key : variants.keySet()) {
                Predicate<class_2680> pred = BlockStatePredicateHelper.variantPredicate((class_2689<class_2248, class_2680>)definition, key);
                JsonElement el = variants.get(key);
                if (!el.isJsonObject()) {
                    throw new JsonSyntaxException("Invalid info for variant '" + key + "''");
                }
                JsonObject variantInfo = el.getAsJsonObject();
                SimpleBlockArmorProperties properties = SimpleBlockArmorProperties.fromJson(variantInfo);
                Iterator stateIter = states.iterator();
                while (stateIter.hasNext()) {
                    class_2680 state = (class_2680)stateIter.next();
                    if (!pred.test(state)) continue;
                    propertiesByState.put(state, properties);
                    stateIter.remove();
                }
            }
        }
        SimpleBlockArmorProperties defaultProperties = SimpleBlockArmorProperties.fromJson(obj);
        return new VariantBlockArmorProperties(defaultProperties, (Map<class_2680, SimpleBlockArmorProperties>)propertiesByState);
    }

    public void toNetwork(class_2540 buf) {
        this.defaultProperties.toNetwork(buf);
        buf.method_10804(this.propertiesByState.size());
        for (Map.Entry<class_2680, SimpleBlockArmorProperties> entry : this.propertiesByState.entrySet()) {
            buf.method_10804(class_2248.method_9507((class_2680)entry.getKey()));
            entry.getValue().toNetwork(buf);
        }
    }

    public static VariantBlockArmorProperties fromNetwork(class_2540 buf) {
        SimpleBlockArmorProperties defaultProperties = SimpleBlockArmorProperties.fromNetwork(buf);
        int sz = buf.method_10816();
        Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
        for (int i = 0; i < sz; ++i) {
            class_2680 state = class_2248.method_9531((int)buf.method_10816());
            SimpleBlockArmorProperties properties = SimpleBlockArmorProperties.fromNetwork(buf);
            propertiesByState.put(state, properties);
        }
        return new VariantBlockArmorProperties(defaultProperties, (Map<class_2680, SimpleBlockArmorProperties>)propertiesByState);
    }
}

