/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_mount;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.class_1944;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class CannonMountInstance
extends BlockEntityInstance<CannonMountBlockEntity>
implements DynamicInstance {
    private OrientedData rotatingMount;
    private OrientedData rotatingMountShaft;
    private RotatingData pitchShaft;
    private RotatingData yawShaft;

    public CannonMountInstance(MaterialManager dispatcher, CannonMountBlockEntity tile) {
        super(dispatcher, (class_2586)tile);
    }

    public void init() {
        super.init();
        int blockLight = this.world.method_8314(class_1944.field_9282, this.pos);
        int skyLight = this.world.method_8314(class_1944.field_9284, this.pos);
        class_2350 vertical = (class_2350)this.blockState.method_11654((class_2769)class_2741.field_28062);
        class_2350 facing = (class_2350)this.blockState.method_11654((class_2769)class_2741.field_12481);
        class_2350.class_2351 pitchAxis = facing.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        Material rotatingMaterial = this.materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING);
        Instancer shaftInstance = rotatingMaterial.getModel((class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)class_2741.field_12496, (Comparable)pitchAxis));
        Instancer halfShaftInstance = rotatingMaterial.getModel(AllPartialModels.SHAFT_HALF, this.blockState, vertical);
        this.rotatingMount = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(CBCBlockPartials.ROTATING_MOUNT, this.blockState).createInstance();
        this.rotatingMount.setPosition(this.getInstancePosition().method_10093(vertical.method_10153()));
        this.rotatingMountShaft = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(CBCBlockPartials.CANNON_CARRIAGE_AXLE, this.blockState, class_2350.field_11043).createInstance();
        this.rotatingMountShaft.setPosition(this.getInstancePosition().method_10079(vertical, -2));
        this.pitchShaft = (RotatingData)shaftInstance.createInstance();
        this.pitchShaft.setRotationAxis(pitchAxis).setRotationOffset(this.getRotationOffset(pitchAxis)).setColor(((CannonMountBlockEntity)this.blockEntity).getPitchInterface()).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.yawShaft = (RotatingData)halfShaftInstance.createInstance();
        this.yawShaft.setRotationAxis(class_2350.class_2351.field_11052).setRotationOffset(this.getRotationOffset(class_2350.class_2351.field_11052)).setColor(((CannonMountBlockEntity)this.blockEntity).getYawInterface()).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.transformModels();
    }

    public void remove() {
        this.rotatingMount.delete();
        this.rotatingMountShaft.delete();
        this.pitchShaft.delete();
        this.yawShaft.delete();
    }

    private void transformModels() {
        class_2350 facing = (class_2350)this.blockState.method_11654((class_2769)class_2741.field_12481);
        class_2350.class_2351 pitchAxis = facing.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        this.updateRotation(this.pitchShaft, pitchAxis, ((CannonMountBlockEntity)this.blockEntity).getPitchSpeed(), true);
        this.updateRotation(this.yawShaft, class_2350.class_2351.field_11052, ((CannonMountBlockEntity)this.blockEntity).getYawSpeed(), false);
    }

    protected void updateRotation(RotatingData instance, class_2350.class_2351 axis, float speed, boolean pitch) {
        instance.setRotationAxis(axis).setRotationOffset(this.getRotationOffset(axis)).setRotationalSpeed(speed).setColor(pitch ? ((CannonMountBlockEntity)this.blockEntity).getPitchInterface() : ((CannonMountBlockEntity)this.blockEntity).getYawInterface());
    }

    protected float getRotationOffset(class_2350.class_2351 axis) {
        float offset = ICogWheel.isLargeCog((class_2680)this.blockState) ? 11.25f : 0.0f;
        double d = ((axis == class_2350.class_2351.field_11048 ? 0 : this.pos.method_10263()) + (axis == class_2350.class_2351.field_11052 ? 0 : this.pos.method_10264()) + (axis == class_2350.class_2351.field_11051 ? 0 : this.pos.method_10260())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }

    public void beginFrame() {
        this.transformModels();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        boolean upsideDown = this.blockState.method_11654((class_2769)class_2741.field_28062) == class_2350.field_11036;
        float yaw = ((CannonMountBlockEntity)this.blockEntity).getYawOffset(partialTicks);
        Quaternionf qyaw = upsideDown ? class_7833.field_40718.rotationDegrees(180.0f).mul((Quaternionfc)class_7833.field_40716.rotationDegrees(yaw)) : class_7833.field_40716.rotationDegrees(-yaw);
        this.rotatingMount.setRotation(qyaw);
        float pitch = ((CannonMountBlockEntity)this.blockEntity).getPitchOffset(partialTicks);
        Quaternionf qpitch = upsideDown ? class_7833.field_40714.rotationDegrees(pitch) : class_7833.field_40714.rotationDegrees(-pitch);
        Quaternionf qyaw1 = new Quaternionf((Quaternionfc)qyaw);
        qyaw1.mul((Quaternionfc)qpitch);
        this.rotatingMountShaft.setRotation(qyaw1);
    }

    public void updateLight() {
        super.updateLight();
        class_2350 vertical = ((class_2350)this.blockState.method_11654((class_2769)class_2741.field_28062)).method_10153();
        this.relight(this.pos.method_10093(vertical), new FlatLit[]{this.rotatingMount});
        this.relight(this.pos.method_10079(vertical, 2), new FlatLit[]{this.rotatingMountShaft});
        this.relight(this.pos, new FlatLit[]{this.pitchShaft});
        this.relight(this.pos, new FlatLit[]{this.yawShaft});
    }
}

