/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.CannonContraptionTypeRegistry;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.ICannonContraptionType;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountBlockPropertiesProvider;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountBlockPropertiesSerializer;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountEntityPropertiesProvider;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountEntityPropertiesSerializer;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class CannonMountPropertiesHandler {
    private static final Map<class_2591<?>, Map<ICannonContraptionType, CannonMountBlockPropertiesProvider>> BLOCK_MOUNT_PROPERTIES = new Reference2ObjectOpenHashMap();
    private static final Map<class_1299<?>, Map<ICannonContraptionType, CannonMountEntityPropertiesProvider>> ENTITY_MOUNT_PROPERTIES = new Reference2ObjectOpenHashMap();
    private static final Map<class_2591<?>, CannonMountBlockPropertiesSerializer<?>> BLOCK_MOUNT_SERIALIZERS = new Reference2ReferenceOpenHashMap();
    private static final Map<class_1299<?>, CannonMountEntityPropertiesSerializer> ENTITY_MOUNT_SERIALIZERS = new Reference2ReferenceOpenHashMap();
    private static final CannonMountBlockPropertiesProvider FALLBACK_BLOCK = new CannonMountBlockPropertiesProvider(){

        @Override
        public float maximumElevation(class_1937 level, class_2680 state, class_2338 pos) {
            return 0.0f;
        }

        @Override
        public float maximumDepression(class_1937 level, class_2680 state, class_2338 pos) {
            return 0.0f;
        }
    };
    private static final CannonMountEntityPropertiesProvider FALLBACK_ENTITY = new CannonMountEntityPropertiesProvider(){

        @Override
        public float maximumElevation(class_1297 entity) {
            return 0.0f;
        }

        @Override
        public float maximumDepression(class_1297 entity) {
            return 0.0f;
        }
    };

    public static <T extends CannonMountBlockPropertiesSerializer<?>> T registerBlockMountSerializer(class_2591<?> type, T ser) {
        if (BLOCK_MOUNT_SERIALIZERS.containsKey(type)) {
            throw new IllegalStateException("Serializer for block entity " + CBCRegistryUtils.getBlockEntityTypeLocation(type) + " already registered");
        }
        BLOCK_MOUNT_SERIALIZERS.put(type, ser);
        return ser;
    }

    public static <T extends CannonMountEntityPropertiesSerializer> T registerEntityMountSerializer(class_1299<?> type, T ser) {
        if (ENTITY_MOUNT_SERIALIZERS.containsKey(type)) {
            throw new IllegalStateException("Serializer for block entity " + CBCRegistryUtils.getEntityTypeLocation(type) + " already registered");
        }
        ENTITY_MOUNT_SERIALIZERS.put(type, ser);
        return ser;
    }

    public static CannonMountBlockPropertiesProvider getProperties(class_2586 be, ICannonContraptionType contraptionType) {
        return CannonMountPropertiesHandler.getProperties(be.method_11017(), contraptionType);
    }

    public static CannonMountBlockPropertiesProvider getProperties(class_2591<?> beType, ICannonContraptionType contraptionType) {
        return BLOCK_MOUNT_PROPERTIES.containsKey(beType) ? BLOCK_MOUNT_PROPERTIES.get(beType).getOrDefault(contraptionType, FALLBACK_BLOCK) : FALLBACK_BLOCK;
    }

    public static CannonMountEntityPropertiesProvider getProperties(class_1297 entity, ICannonContraptionType contraptionType) {
        return CannonMountPropertiesHandler.getProperties(entity.method_5864(), contraptionType);
    }

    public static CannonMountEntityPropertiesProvider getProperties(class_1299<?> entityType, ICannonContraptionType contraptionType) {
        return ENTITY_MOUNT_PROPERTIES.containsKey(entityType) ? ENTITY_MOUNT_PROPERTIES.get(entityType).getOrDefault(contraptionType, FALLBACK_ENTITY) : FALLBACK_ENTITY;
    }

    public static void writeBuf(class_2540 buf) {
        Map<ICannonContraptionType, Object> map;
        buf.method_10804(BLOCK_MOUNT_PROPERTIES.size());
        for (Map.Entry<class_2591<?>, Map<ICannonContraptionType, CannonMountBlockPropertiesProvider>> entry : BLOCK_MOUNT_PROPERTIES.entrySet()) {
            buf.method_10812(CBCRegistryUtils.getBlockEntityTypeLocation(entry.getKey()));
            map = entry.getValue();
            buf.method_10804(map.size());
            for (Map.Entry<ICannonContraptionType, CannonMountBlockPropertiesProvider> entry2 : map.entrySet()) {
                buf.method_10812(CannonContraptionTypeRegistry.getKey(entry2.getKey()));
                CannonMountPropertiesHandler.toNetworkCasted(buf, entry.getKey(), entry2.getValue());
            }
        }
        buf.method_10804(ENTITY_MOUNT_PROPERTIES.size());
        for (Map.Entry<Object, Map<ICannonContraptionType, Object>> entry : ENTITY_MOUNT_PROPERTIES.entrySet()) {
            buf.method_10812(CBCRegistryUtils.getEntityTypeLocation((class_1299)entry.getKey()));
            map = entry.getValue();
            buf.method_10804(map.size());
            for (Map.Entry<ICannonContraptionType, Object> entry3 : map.entrySet()) {
                buf.method_10812(CannonContraptionTypeRegistry.getKey(entry3.getKey()));
                CannonMountPropertiesHandler.toNetworkCasted(buf, (class_1299)entry.getKey(), (CannonMountEntityPropertiesProvider)entry3.getValue());
            }
        }
    }

    private static <T extends CannonMountBlockPropertiesProvider> void toNetworkCasted(class_2540 buf, class_2591<?> beType, T properties) {
        CannonMountBlockPropertiesSerializer<?> ser = BLOCK_MOUNT_SERIALIZERS.get(beType);
        ser.toNetwork(properties, buf);
    }

    private static <T extends CannonMountEntityPropertiesProvider> void toNetworkCasted(class_2540 buf, class_1299<?> entityType, T properties) {
        CannonMountEntityPropertiesSerializer ser = ENTITY_MOUNT_SERIALIZERS.get(entityType);
        ser.toNetwork(properties, buf);
    }

    public static void readBuf(class_2540 buf) {
        BLOCK_MOUNT_PROPERTIES.clear();
        int blockSz = buf.method_10816();
        for (int i = 0; i < blockSz; ++i) {
            class_2960 beTypeLoc = buf.method_10810();
            class_2591<?> beType = CBCRegistryUtils.getBlockEntityType(beTypeLoc);
            CannonMountBlockPropertiesSerializer<?> ser = BLOCK_MOUNT_SERIALIZERS.get(beType);
            int mapSz = buf.method_10816();
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
            for (int j = 0; j < mapSz; ++j) {
                class_2960 contraptionTypeLoc = buf.method_10810();
                ICannonContraptionType contraptionType = CannonContraptionTypeRegistry.get(contraptionTypeLoc);
                map.put(contraptionType, ser.fromNetwork(buf));
            }
            BLOCK_MOUNT_PROPERTIES.put(beType, (Map<ICannonContraptionType, CannonMountBlockPropertiesProvider>)map);
        }
        ENTITY_MOUNT_PROPERTIES.clear();
        int entitySz = buf.method_10816();
        for (int i = 0; i < entitySz; ++i) {
            class_2960 entityTypeLoc = buf.method_10810();
            class_1299<?> entityType = CBCRegistryUtils.getEntityType(entityTypeLoc);
            CannonMountEntityPropertiesSerializer ser = ENTITY_MOUNT_SERIALIZERS.get(entityType);
            int mapSz = buf.method_10816();
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
            for (int j = 0; j < mapSz; ++j) {
                class_2960 contraptionTypeLoc = buf.method_10810();
                ICannonContraptionType contraptionType = CannonContraptionTypeRegistry.get(contraptionTypeLoc);
                map.put(contraptionType, ser.fromNetwork(buf));
            }
            ENTITY_MOUNT_PROPERTIES.put(entityType, (Map<ICannonContraptionType, CannonMountEntityPropertiesProvider>)map);
        }
    }

    public static void syncTo(class_3222 player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundSyncCannonMountPropertiesPacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundSyncCannonMountPropertiesPacket(), server);
    }

    public record ClientboundSyncCannonMountPropertiesPacket(@Nullable class_2540 buf) implements RootPacket
    {
        public ClientboundSyncCannonMountPropertiesPacket() {
            this(null);
        }

        public static ClientboundSyncCannonMountPropertiesPacket copyOf(class_2540 buf) {
            return new ClientboundSyncCannonMountPropertiesPacket(new class_2540(buf.copy()));
        }

        @Override
        public void rootEncode(class_2540 buf) {
            CannonMountPropertiesHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, class_2547 listener, @Nullable class_3222 sender) {
            if (this.buf != null) {
                CannonMountPropertiesHandler.readBuf(this.buf);
            }
        }
    }

    public static class EntityReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final EntityReloadListener INSTANCE = new EntityReloadListener();

        public EntityReloadListener() {
            super(GSON, "cannon_mounts/entities");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 profiler) {
            ENTITY_MOUNT_PROPERTIES.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    String[] pathComponents = loc.method_12832().split("/");
                    class_2960 entityLoc = CBCUtils.location(loc.method_12836(), pathComponents[0]);
                    class_2960 cannonTypeLoc = CBCUtils.location(pathComponents[1], pathComponents[2]);
                    class_1299<?> entityType = CBCRegistryUtils.getOptionalEntityType(entityLoc).orElseThrow(() -> new JsonSyntaxException("Unknown entity type '" + entityLoc + "'"));
                    ICannonContraptionType contraptionType = CannonContraptionTypeRegistry.getOptional(cannonTypeLoc).orElseThrow(() -> new JsonSyntaxException("Unknown cannon contraption type '" + cannonTypeLoc + "'"));
                    if (!ENTITY_MOUNT_SERIALIZERS.containsKey(entityType)) continue;
                    CannonMountEntityPropertiesSerializer ser = ENTITY_MOUNT_SERIALIZERS.get(entityType);
                    if (!ENTITY_MOUNT_PROPERTIES.containsKey(entityType)) {
                        ENTITY_MOUNT_PROPERTIES.put(entityType, (Map<ICannonContraptionType, CannonMountEntityPropertiesProvider>)new Reference2ObjectOpenHashMap());
                    }
                    Map<ICannonContraptionType, CannonMountEntityPropertiesProvider> mountMap = ENTITY_MOUNT_PROPERTIES.get(entityType);
                    mountMap.put(contraptionType, (CannonMountEntityPropertiesProvider)ser.fromJson(entityType, contraptionType, el.getAsJsonObject()));
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class BlockEntityReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final BlockEntityReloadListener INSTANCE = new BlockEntityReloadListener();

        public BlockEntityReloadListener() {
            super(GSON, "cannon_mounts/block_entities");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 profiler) {
            BLOCK_MOUNT_PROPERTIES.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    String[] pathComponents = loc.method_12832().split("/");
                    class_2960 blockEntityLoc = CBCUtils.location(loc.method_12836(), pathComponents[0]);
                    class_2960 cannonTypeLoc = CBCUtils.location(pathComponents[1], pathComponents[2]);
                    class_2591<?> beType = CBCRegistryUtils.getOptionalBlockEntityType(blockEntityLoc).orElseThrow(() -> new JsonSyntaxException("Unknown block entity type '" + blockEntityLoc + "'"));
                    ICannonContraptionType contraptionType = CannonContraptionTypeRegistry.getOptional(cannonTypeLoc).orElseThrow(() -> new JsonSyntaxException("Unknown cannon contraption type '" + cannonTypeLoc + "'"));
                    if (!BLOCK_MOUNT_SERIALIZERS.containsKey(beType)) continue;
                    CannonMountBlockPropertiesSerializer<?> ser = BLOCK_MOUNT_SERIALIZERS.get(beType);
                    if (!BLOCK_MOUNT_PROPERTIES.containsKey(beType)) {
                        BLOCK_MOUNT_PROPERTIES.put(beType, (Map<ICannonContraptionType, CannonMountBlockPropertiesProvider>)new Reference2ObjectOpenHashMap());
                    }
                    Map<ICannonContraptionType, CannonMountBlockPropertiesProvider> mountMap = BLOCK_MOUNT_PROPERTIES.get(beType);
                    mountMap.put(contraptionType, (CannonMountBlockPropertiesProvider)ser.fromJson(beType, contraptionType, el.getAsJsonObject()));
                }
                catch (Exception exception) {}
            }
        }
    }
}

