/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_8110;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCDamageTypes;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.ImpactExplosion;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionPropertiesHandler;
import rbasamoyai.createbigcannons.munitions.config.FluidDragHandler;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.EntityDamagePropertiesComponent;
import rbasamoyai.createbigcannons.network.ClientboundPlayBlockHitEffectPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundPreciseMotionSyncPacket;

public abstract class AbstractCannonProjectile
extends class_1676 {
    protected static final class_2940<Byte> ID_FLAGS = class_2945.method_12791(AbstractCannonProjectile.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Float> PROJECTILE_MASS = class_2945.method_12791(AbstractCannonProjectile.class, (class_2941)class_2943.field_13320);
    protected int inGroundTime = 0;
    @Nullable
    protected class_243 inGroundPos = null;
    protected float damage;
    protected int inFluidTime = 0;
    protected int penetrationTime = 0;
    @Nullable
    protected class_243 nextVelocity = null;
    @Nullable
    protected class_243 orientation = null;
    protected class_2680 lastPenetratedBlock = class_2246.field_10124.method_9564();
    protected boolean removeNextTick = false;
    protected int localSoundCooldown;
    protected WeakHashMap<class_1297, Integer> untouchableEntities = new WeakHashMap();

    protected AbstractCannonProjectile(class_1299<? extends AbstractCannonProjectile> type, class_1937 level) {
        super(type, level);
        this.damage = this.getDamageProperties().entityDamage();
        this.setProjectileMass(this.getBallisticProperties().durabilityMass());
    }

    @Nonnull
    public abstract EntityDamagePropertiesComponent getDamageProperties();

    public void method_5773() {
        if (this.removeNextTick) {
            this.method_31472();
            return;
        }
        class_1923 cpos = new class_1923(this.method_24515());
        if (this.method_37908().field_9236 || this.method_37908().method_8393(cpos.field_9181, cpos.field_9180)) {
            class_1937 entry;
            super.method_5773();
            if (this.nextVelocity != null) {
                boolean stop;
                boolean bl = stop = this.nextVelocity.method_1027() < 1.0E-4;
                if (!this.method_37908().field_9236 || stop) {
                    if (stop) {
                        this.setInGround(true);
                        this.setGroundPos(this.method_19538());
                    }
                    this.method_18799(this.nextVelocity);
                }
                this.nextVelocity = null;
            }
            if (!this.isInGround()) {
                this.clipAndDamage();
            }
            this.onTickRotate();
            if (this.isInGround()) {
                this.method_18799(class_243.field_1353);
                if (!this.method_37908().field_9236) {
                    if (this.shouldFall()) {
                        this.setInGround(false);
                        this.setGroundPos(null);
                    } else if (!this.canLingerInGround()) {
                        ++this.inGroundTime;
                        if (this.inGroundTime == 400) {
                            this.method_31472();
                        }
                    }
                }
            } else {
                this.inGroundTime = 0;
                class_243 oldVel = this.method_18798();
                class_243 oldPos = this.method_19538();
                if (this.nextVelocity != null) {
                    class_243 newPos = oldPos.method_1019(oldVel);
                    this.method_33574(newPos);
                } else {
                    class_243 accel = this.getForces(oldPos, oldVel);
                    class_243 newPos = oldPos.method_1019(oldVel).method_1019(accel.method_1021(0.5));
                    this.method_33574(newPos);
                    this.method_18799(oldVel.method_1019(accel));
                }
                this.method_36456(AbstractCannonProjectile.method_26960((float)this.field_5982, (float)this.method_36454()));
                this.method_36457(AbstractCannonProjectile.method_26960((float)this.field_6004, (float)this.method_36455()));
            }
            Iterator<Map.Entry<class_1297, Integer>> iter = this.untouchableEntities.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                if (entry.getKey().method_31481() || entry.getValue() > 0 && (Integer)entry.getValue() - 1 == 0) {
                    iter.remove();
                    continue;
                }
                if ((Integer)entry.getValue() <= 0) continue;
                entry.setValue((Integer)entry.getValue() - 1);
            }
            if (this.inFluidTime > 0) {
                --this.inFluidTime;
            }
            if (this.penetrationTime > 0) {
                --this.penetrationTime;
            }
            if (this.localSoundCooldown > 0) {
                --this.localSoundCooldown;
            }
            if ((entry = this.method_37908()) instanceof class_3218) {
                class_3218 slevel = (class_3218)entry;
                if (!this.method_31481() && ((Boolean)CBCConfigs.SERVER.munitions.projectilesCanChunkload.get()).booleanValue()) {
                    class_1923 cpos1 = new class_1923(this.method_24515());
                    RitchiesProjectileLib.queueForceLoad((class_3218)slevel, (int)cpos1.field_9181, (int)cpos1.field_9180);
                }
            }
        }
    }

    protected void onTickRotate() {
    }

    protected class_243 getForces(class_243 position, class_243 velocity) {
        return velocity.method_1029().method_1021(-this.getDragForce()).method_1031(0.0, this.getGravity(), 0.0);
    }

    public class_243 getOrientation() {
        return this.orientation == null ? this.method_18798() : this.orientation;
    }

    public void setOrientation(class_243 orientation) {
        this.orientation = orientation;
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
        if (this.field_6012 < 2) {
            return;
        }
        super.method_5759(x, y, z, yRot, xRot, lerpSteps, teleport);
    }

    public void setLocalSoundCooldown(int value) {
        this.localSoundCooldown = value;
    }

    public int getLocalSoundCooldown() {
        return this.localSoundCooldown;
    }

    /*
     * WARNING - void declaration
     */
    protected void clipAndDamage() {
        class_243 pos;
        ProjectileContext projCtx = new ProjectileContext(this, (CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get()));
        class_243 currentStart = pos = this.method_19538();
        double reach = (double)Math.max(this.method_17681(), this.method_17682()) * 0.5;
        double t = 1.0;
        int MAX_ITER = 100;
        class_243 originalVel = this.method_18798();
        class_243 accel = this.getForces(pos, originalVel);
        class_243 trajectory = originalVel.method_1019(accel);
        class_243 finalEnd = pos.method_1019(trajectory);
        double velMag = trajectory.method_1033();
        double vmRecip = 1.0 / velMag;
        boolean shouldRemove = false;
        boolean stop = false;
        for (int p = 0; p < MAX_ITER; ++p) {
            void var20_17;
            void var20_20;
            class_3965 fluidResult;
            if (velMag * t < 0.01) {
                this.lastPenetratedBlock = class_2246.field_10124.method_9564();
                break;
            }
            class_243 class_2432 = currentStart.method_1019(trajectory.method_1021(t));
            class_3965 class_39652 = this.method_37908().method_17742(new class_3959(currentStart, class_2432, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (class_39652.method_17783() != class_239.class_240.field_1333) {
                class_243 class_2433 = class_39652.method_17784();
            }
            if (p == 0 && (fluidResult = this.method_37908().method_17742(new class_3959(currentStart, (class_243)var20_20, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, (class_1297)this))).method_17783() != class_239.class_240.field_1333) {
                class_2338 fluidPos = fluidResult.method_17777();
                class_2680 state = this.method_37908().method_8320(fluidPos);
                if (state.method_26204() instanceof class_2404) {
                    if (this.inFluidTime <= 0 && (stop = this.onImpactFluid(projCtx, state, this.method_37908().method_8316(fluidPos), fluidResult.method_17784(), fluidResult))) {
                        class_243 class_2434 = class_39652.method_17784();
                    }
                    this.inFluidTime = 2;
                }
            }
            if (this.onClip(projCtx, currentStart, (class_243)var20_17)) {
                shouldRemove = true;
                break;
            }
            class_243 disp = var20_17.method_1020(currentStart);
            class_238 currentMovementRegion = this.method_5829().method_18804(disp).method_1014(1.0).method_997(currentStart.method_1020(pos));
            class_243 endStart = currentStart;
            void endCopy = var20_17;
            class_238 thisBB = this.method_5829();
            for (class_1297 target : this.method_37908().method_8335((class_1297)this, currentMovementRegion)) {
                class_238 targetBB;
                if (projCtx.hasHitEntity(target) || !this.method_26958(target) || !(targetBB = target.method_5829()).method_994(thisBB) && !targetBB.method_1014(reach).method_992(endStart, (class_243)endCopy).isPresent()) continue;
                projCtx.addEntity(target);
            }
            if (stop) break;
            currentStart = var20_17;
            t -= disp.method_1033() * vmRecip;
            if (class_39652.method_17783() != class_239.class_240.field_1333) {
                class_2338 bpos = class_39652.method_17777().method_10062();
                class_2680 state = this.method_37908().method_8500(bpos).method_8320(bpos);
                ImpactResult result = this.calculateBlockPenetration(projCtx, state, class_39652);
                switch (result.kinematics) {
                    case PENETRATE: {
                        this.lastPenetratedBlock = state;
                        this.penetrationTime = 2;
                        break;
                    }
                    case BOUNCE: {
                        this.method_18799(trajectory.method_1021(1.0 - t));
                        class_243 normal = CBCUtils.getSurfaceNormalVector(this.method_37908(), class_39652);
                        double elasticity = 1.7f;
                        this.nextVelocity = trajectory.method_1020(normal.method_1021(normal.method_1026(trajectory) * elasticity));
                        this.setLocalSoundCooldown(3);
                        stop = true;
                        break;
                    }
                    case STOP: {
                        this.method_18799(trajectory.method_1021(1.0 - t));
                        this.nextVelocity = class_243.field_1353;
                        this.lastPenetratedBlock = state;
                        this.penetrationTime = 2;
                        this.setLocalSoundCooldown(3);
                        stop = true;
                    }
                }
                shouldRemove |= result.shouldRemove;
            }
            if (shouldRemove || stop || t <= 0.0) break;
        }
        for (class_1297 class_12972 : projCtx.hitEntities()) {
            shouldRemove |= this.onHitEntity(class_12972, projCtx);
        }
        if (!this.method_37908().field_9236) {
            if (projCtx.griefState() != CBCCfgMunitions.GriefState.NO_DAMAGE) {
                class_243 oldVel = this.method_18798();
                for (Map.Entry<class_2338, Float> entry : projCtx.getQueuedExplosions().entrySet()) {
                    class_243 impactPos = class_243.method_24953((class_2382)((class_2382)entry.getKey()));
                    ImpactExplosion explosion = new ImpactExplosion(this.method_37908(), (class_1297)this, this.indirectArtilleryFire(false), impactPos.field_1352, impactPos.field_1351, impactPos.field_1350, entry.getValue().floatValue(), class_1937.class_7867.field_40889);
                    CreateBigCannons.handleCustomExplosion(this.method_37908(), explosion);
                }
                this.method_18799(oldVel);
            }
            for (ClientboundPlayBlockHitEffectPacket clientboundPlayBlockHitEffectPacket : projCtx.getPlayedEffects()) {
                NetworkPlatform.sendToClientTracking(clientboundPlayBlockHitEffectPacket, (class_1297)this);
            }
        }
        if (!this.method_37908().field_9236 || !stop) {
            this.orientation = trajectory;
        }
        if (shouldRemove) {
            this.removeNextTick = true;
        }
    }

    protected boolean canHitSurface() {
        return this.lastPenetratedBlock.method_26215() && this.penetrationTime == 0;
    }

    protected boolean onClip(ProjectileContext ctx, class_243 start, class_243 end) {
        return false;
    }

    protected abstract ImpactResult calculateBlockPenetration(ProjectileContext var1, class_2680 var2, class_3965 var3);

    protected boolean onImpactFluid(ProjectileContext projectileContext, class_2680 blockState, class_3610 fluidState, class_243 impactPos, class_3965 fluidHitResult) {
        boolean bounced;
        class_243 pos = this.method_19538();
        class_243 accel = this.getForces(this.method_19538(), this.method_18798());
        class_243 curVel = this.method_18798().method_1019(accel);
        class_243 normal = CBCUtils.getSurfaceNormalVector(this.method_37908(), fluidHitResult);
        double incidence = Math.max(0.0, curVel.method_1029().method_1026(normal.method_22882()));
        double velMag = curVel.method_1033();
        double mass = this.getProjectileMass();
        double incidentVel = velMag * incidence;
        double momentum = mass * incidentVel;
        double projectileDeflection = this.getBallisticProperties().deflection();
        double fluidDensity = FluidDragHandler.getFluidDrag(fluidState);
        boolean canBounce = (Boolean)CBCConfigs.SERVER.munitions.projectilesCanBounce.get();
        double baseChance = CBCConfigs.SERVER.munitions.baseProjectileFluidBounceChance.getF();
        boolean criticalAngle = projectileDeflection > 0.01 && incidence <= projectileDeflection;
        boolean buoyant = fluidDensity > 0.01 && momentum < fluidDensity;
        double incidenceFactor = criticalAngle ? Math.max(0.0, 1.0 - incidence / projectileDeflection) : 0.0;
        double massFactor = buoyant ? 0.0 : Math.max(0.0, 1.0 - momentum / fluidDensity);
        double chance = Math.max(baseChance, incidenceFactor * massFactor);
        boolean bl = bounced = canBounce && criticalAngle && buoyant && this.method_37908().method_8409().method_43058() < chance;
        if (bounced) {
            this.method_18799(fluidHitResult.method_17784().method_1020(pos));
            double elasticity = 1.7f;
            this.nextVelocity = curVel.method_1020(normal.method_1021(normal.method_1026(curVel) * elasticity));
        }
        if (!this.method_37908().field_9236) {
            class_243 effectNormal = bounced ? normal.method_1021(incidentVel) : curVel.method_22882();
            class_243 fluidExplosionPos = fluidHitResult.method_17784();
            projectileContext.addPlayedEffect(new ClientboundPlayBlockHitEffectPacket(blockState, this.method_5864(), bounced, true, fluidExplosionPos.field_1352, fluidExplosionPos.field_1351, fluidExplosionPos.field_1350, (float)effectNormal.field_1352, (float)effectNormal.field_1351, (float)effectNormal.field_1350));
        }
        return bounced;
    }

    protected boolean onHitEntity(class_1297 entity, ProjectileContext projectileContext) {
        if (this.getProjectileMass() <= 0.0f) {
            return false;
        }
        if (!this.method_37908().field_9236) {
            EntityDamagePropertiesComponent properties = this.getDamageProperties();
            entity.method_18799(this.method_18798().method_1021((double)this.getKnockback(entity)));
            class_1282 source = this.getEntityDamage(entity);
            if (properties == null || properties.ignoresInvulnerability()) {
                entity.field_6008 = 0;
            }
            entity.method_5643(source, this.damage);
            if (properties == null || !properties.rendersInvulnerable()) {
                entity.field_6008 = 0;
            }
            float penalty = entity.method_5805() ? 2.0f : 0.2f;
            this.setProjectileMass(Math.max(this.getProjectileMass() - penalty, 0.0f));
        }
        return this.onImpact((class_239)new class_3966(entity), new ImpactResult(ImpactResult.KinematicOutcome.PENETRATE, false), projectileContext);
    }

    protected boolean onImpact(class_239 hitResult, ImpactResult impactResult, ProjectileContext projectileContext) {
        return false;
    }

    protected class_1282 getEntityDamage(class_1297 entity) {
        return this.indirectArtilleryFire(this.getDamageProperties().ignoresEntityArmor());
    }

    protected float getKnockback(class_1297 target) {
        return this.getDamageProperties().knockback();
    }

    public boolean method_5643(class_1282 source, float damage) {
        return false;
    }

    protected void method_5693() {
        this.field_6011.method_12784(ID_FLAGS, (Object)0);
        this.field_6011.method_12784(PROJECTILE_MASS, (Object)Float.valueOf(0.0f));
    }

    public void setInGround(boolean inGround) {
        if (inGround) {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(ID_FLAGS) | 1)));
        } else {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(ID_FLAGS) & 0xFE)));
        }
        super.method_24830(inGround);
    }

    public boolean isInGround() {
        return ((Byte)this.field_6011.method_12789(ID_FLAGS) & 1) != 0;
    }

    public void setGroundPos(@Nullable class_243 groundPos) {
        this.inGroundPos = groundPos;
    }

    @Nullable
    public class_243 getGroundPos() {
        return this.inGroundPos;
    }

    public void method_24830(boolean onGround) {
        this.setInGround(onGround);
    }

    private boolean shouldFall() {
        return this.isInGround() && this.inGroundPos != null && this.method_37908().method_18026(new class_238(this.inGroundPos, this.inGroundPos).method_1014(0.06));
    }

    public void updateKinematics(ClientboundPreciseMotionSyncPacket packet) {
        if (this.method_18798().method_1027() > 1.0E-4) {
            this.orientation = this.method_18798();
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("ProjectileMass", this.getProjectileMass());
        tag.method_10556("InGround", this.isInGround());
        if (this.inGroundPos != null) {
            tag.method_10566("InGroundPos", (class_2520)this.method_5846(new double[]{this.inGroundPos.field_1352, this.inGroundPos.field_1351, this.inGroundPos.field_1350}));
        }
        tag.method_10548("Damage", this.damage);
        if (this.nextVelocity != null) {
            tag.method_10566("NextMotion", (class_2520)this.method_5846(new double[]{this.nextVelocity.field_1352, this.nextVelocity.field_1351, this.nextVelocity.field_1350}));
        }
        if (this.orientation != null) {
            tag.method_10566("Orientation", (class_2520)this.method_5846(new double[]{this.orientation.field_1352, this.orientation.field_1351, this.orientation.field_1350}));
        }
        tag.method_10566("LastPenetration", (class_2520)class_2512.method_10686((class_2680)this.lastPenetratedBlock));
        if (this.removeNextTick) {
            tag.method_10556("RemoveNextTick", true);
        }
    }

    public void method_5749(class_2487 tag) {
        class_2499 posTag;
        class_2499 orientationTag;
        class_2499 nextMotion;
        super.method_5749(tag);
        this.setProjectileMass(tag.method_10583("ProjectileMass"));
        this.setInGround(tag.method_10577("InGround"));
        this.damage = tag.method_10583("Damage");
        class_2499 motionTag = tag.method_10554("Motion", 6);
        this.method_18800(motionTag.method_10611(0), motionTag.method_10611(1), motionTag.method_10611(2));
        this.nextVelocity = tag.method_10573("NextMotion", 9) ? ((nextMotion = tag.method_10554("NextMotion", 6)).size() == 3 ? new class_243(nextMotion.method_10611(0), nextMotion.method_10611(1), nextMotion.method_10611(2)) : null) : null;
        this.orientation = tag.method_10573("Orientation", 9) ? ((orientationTag = tag.method_10554("Orientation", 6)).size() == 3 ? new class_243(orientationTag.method_10611(0), orientationTag.method_10611(1), orientationTag.method_10611(2)) : null) : this.method_18798();
        this.inGroundPos = tag.method_10573("InGroundPos", 9) ? ((posTag = tag.method_10554("InGroundPos", 6)).size() == 3 ? new class_243(posTag.method_10611(0), posTag.method_10611(1), posTag.method_10611(2)) : null) : null;
        this.lastPenetratedBlock = tag.method_10573("LastPenetration", 10) ? class_2512.method_10681((class_7871)this.method_37908().method_45448(CBCRegistryUtils.getBlockRegistryKey()), (class_2487)tag.method_10562("LastPenetration")) : class_2246.field_10124.method_9564();
        this.removeNextTick = tag.method_10545("RemoveNextTick");
    }

    public void baseWriteSpawnData(class_2540 buf) {
        class_243 vel = this.method_18798();
        class_243 orientation = this.orientation == null ? vel : this.orientation;
        buf.writeFloat(this.method_36455()).writeFloat(this.method_36454()).writeDouble(vel.field_1352).writeDouble(vel.field_1351).writeDouble(vel.field_1350).writeDouble(orientation.field_1352).writeDouble(orientation.field_1351).writeDouble(orientation.field_1350);
    }

    public void baseReadSpawnData(class_2540 buf) {
        this.method_36457(buf.readFloat());
        this.method_36456(buf.readFloat());
        this.method_18800(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.orientation = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void setProjectileMass(float power) {
        this.field_6011.method_12778(PROJECTILE_MASS, (Object)Float.valueOf(power));
    }

    public float getProjectileMass() {
        return ((Float)this.field_6011.method_12789(PROJECTILE_MASS)).floatValue();
    }

    public static void build(class_1299.class_1300<? extends AbstractCannonProjectile> builder) {
        builder.method_27299(16).method_27300(1).method_19947().method_17687(0.8f, 0.8f);
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return 0.0f;
    }

    protected class_238 method_33332() {
        class_238 box = super.method_33332();
        return box.method_989(0.0, -box.method_17940() * 0.5, 0.0);
    }

    public class_243 method_31166(float partialTicks) {
        class_243 eyePos = super.method_31166(partialTicks);
        return this.isInGround() && this.orientation != null ? eyePos.method_1020(this.orientation.method_1029().method_1021(0.1)) : eyePos;
    }

    protected double getGravity() {
        return this.method_5740() ? 0.0 : this.getBallisticProperties().gravity() * DimensionMunitionPropertiesHandler.getProperties(this.method_37908()).gravityMultiplier();
    }

    protected double getDragForce() {
        BallisticPropertiesComponent properties = this.getBallisticProperties();
        double vel = this.method_18798().method_1033();
        double formDrag = properties.drag();
        double density = DimensionMunitionPropertiesHandler.getProperties(this.method_37908()).dragMultiplier();
        class_3610 fluidState = this.method_37908().method_8316(this.method_24515());
        if (!fluidState.method_15769()) {
            density += FluidDragHandler.getFluidDrag(fluidState);
        }
        double drag = formDrag * density * vel;
        if (properties.isQuadraticDrag()) {
            drag *= vel;
        }
        return Math.min(drag, vel);
    }

    @Nonnull
    protected abstract BallisticPropertiesComponent getBallisticProperties();

    public void setChargePower(float power) {
    }

    public boolean method_26958(class_1297 entity) {
        if (!super.method_26958(entity)) {
            return false;
        }
        if (entity instanceof class_1676) {
            return false;
        }
        return !this.untouchableEntities.containsKey(entity);
    }

    public void addUntouchableEntity(class_1297 entity, int duration) {
        if (entity.method_31481()) {
            return;
        }
        if (duration < 1) {
            throw new IllegalArgumentException("Use #addAlwaysUntouchableEntity when duration < 1 (was " + duration + ")");
        }
        this.untouchableEntities.put(entity, duration);
    }

    public void addAlwaysUntouchableEntity(class_1297 entity) {
        this.untouchableEntities.put(entity, -1);
    }

    public void removeUntouchableEntity(class_1297 entity) {
        this.untouchableEntities.remove(entity);
    }

    public boolean canLingerInGround() {
        return false;
    }

    public class_1282 indirectArtilleryFire(boolean bypassArmor) {
        return new CannonDamageSource((class_6880<class_8110>)CannonDamageSource.getDamageRegistry(this.method_37908()).method_40290(CBCDamageTypes.CANNON_PROJECTILE), bypassArmor);
    }

    public record ImpactResult(KinematicOutcome kinematics, boolean shouldRemove) {

        public static enum KinematicOutcome {
            PENETRATE,
            STOP,
            BOUNCE;

        }
    }
}

