/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.MutablePair;

public interface IBlockGetter {
    public class_2680 getBlockState(class_2338 var1);

    public class_2586 getBlockEntity(class_2338 var1);

    public boolean isClientSide();

    public void updateBlockEntity(SmartBlockEntity var1, class_2338 var2);

    public void updateBlockState(class_2680 var1, class_2338 var2);

    public static class WorldBlockGetter
    implements IBlockGetter {
        private final class_1922 level;
        private final boolean isClientSide;

        public WorldBlockGetter(class_1920 level) {
            this.level = level;
            this.isClientSide = true;
        }

        public WorldBlockGetter(class_1937 level) {
            this.level = level;
            this.isClientSide = level.field_9236;
        }

        @Override
        public class_2680 getBlockState(class_2338 pos) {
            return this.level.method_8320(pos);
        }

        @Override
        public class_2586 getBlockEntity(class_2338 pos) {
            return this.level.method_8321(pos);
        }

        @Override
        public void updateBlockEntity(SmartBlockEntity be, class_2338 pos) {
        }

        @Override
        public void updateBlockState(class_2680 state, class_2338 pos) {
        }

        @Override
        public boolean isClientSide() {
            return this.isClientSide;
        }
    }

    public static class ContraptionBlockGetter
    implements IBlockGetter {
        private final AbstractContraptionEntity contraptionEntity;

        public ContraptionBlockGetter(AbstractContraptionEntity contraptionEntity) {
            this.contraptionEntity = contraptionEntity;
        }

        @Override
        public class_2680 getBlockState(class_2338 pos) {
            Contraption contraption = this.contraptionEntity.getContraption();
            return contraption.getBlocks().containsKey(pos) ? ((class_3499.class_3501)contraption.getBlocks().get(pos)).comp_1342() : null;
        }

        @Override
        public class_2586 getBlockEntity(class_2338 pos) {
            Contraption contraption = this.contraptionEntity.getContraption();
            if (contraption.presentBlockEntities.containsKey(pos)) {
                return (class_2586)contraption.presentBlockEntities.get(pos);
            }
            MutablePair actor = contraption.getActorAt(pos);
            if (actor == null || actor.getRight() == null) {
                return null;
            }
            MovementContext ctx = (MovementContext)actor.getRight();
            if (ctx.blockEntityData == null) {
                return null;
            }
            return class_2586.method_11005((class_2338)pos, (class_2680)this.getBlockState(pos), (class_2487)ctx.blockEntityData);
        }

        @Override
        public boolean isClientSide() {
            Contraption contraption = this.contraptionEntity.getContraption();
            return contraption.getContraptionWorld().method_8608();
        }

        @Override
        public void updateBlockEntity(SmartBlockEntity be, class_2338 pos) {
            Contraption contraption = this.contraptionEntity.getContraption();
            MutablePair actor = contraption.getActorAt(pos);
            if (actor == null || actor.getRight() == null) {
                return;
            }
            MovementContext ctx = (MovementContext)actor.getRight();
            be.method_11007(ctx.blockEntityData);
        }

        @Override
        public void updateBlockState(class_2680 state, class_2338 pos) {
            Contraption contraption = this.contraptionEntity.getContraption();
            class_3499.class_3501 info = (class_3499.class_3501)contraption.getBlocks().get(pos);
            contraption.getBlocks().put(pos, new class_3499.class_3501(pos, state, info.comp_1343()));
        }
    }
}

