/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.foundation.utility.Lang;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.block.IBlockGetter;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.AdvancedDisplaySource;
import de.mrjulsen.crn.block.display.properties.StaticTextDisplaySettings;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.registry.ModDisplayTypes;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_5250;

public class AdvancedDisplayTarget
extends DisplayTarget {
    private static boolean running = false;
    private static boolean threadRunning = false;
    private static final Queue<Runnable> workerTasks = new ConcurrentLinkedQueue<Runnable>();

    public static void start() {
        if (running) {
            AdvancedDisplayTarget.stop();
        }
        while (running && threadRunning) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        workerTasks.clear();
        running = true;
        new Thread(() -> {
            threadRunning = true;
            CreateRailwaysNavigator.LOGGER.info("Advanced Display Data Manager has been started.");
            while (running) {
                while (!workerTasks.isEmpty()) {
                    try {
                        workerTasks.poll().run();
                    }
                    catch (Exception e) {
                        CreateRailwaysNavigator.LOGGER.info("Error while process Advanced Display Data. " + e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            workerTasks.clear();
            CreateRailwaysNavigator.LOGGER.info("Advanced Display Data Manager has been stopped.");
            threadRunning = false;
        }, "Advanced Display Data Manager").start();
    }

    public static void stop() {
        CreateRailwaysNavigator.LOGGER.info("Stopping Advanced Display Data Manager...");
        running = false;
    }

    private static void queueAdvancedDisplayWorkerTask(Runnable task) {
        workerTasks.add(task);
    }

    public void acceptText(int line, List<class_5250> text, DisplayLinkContext context) {
        class_2487 nbt = context.sourceConfig();
        class_2586 class_25862 = context.getTargetBlockEntity();
        if (class_25862 instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity = (AdvancedDisplayBlockEntity)class_25862;
            if (ModCommonEvents.hasServer()) {
                AdvancedDisplayBlockEntity controller = blockEntity.getController(new IBlockGetter.WorldBlockGetter(blockEntity.method_10997()));
                if (controller == null) {
                    return;
                }
                long dayTime = context.getTargetBlockEntity().method_10997().method_8532();
                boolean advancedDisplaySource = context.blockEntity().activeSource instanceof AdvancedDisplaySource;
                AdvancedDisplayTarget.queueAdvancedDisplayWorkerTask(() -> {
                    if (advancedDisplaySource) {
                        String filter = context.sourceConfig().method_10558("Filter");
                        if (controller.getDisplayType().category().getSource() != EDisplayType.EDisplayTypeDataSource.PLATFORM) {
                            if (!((Boolean)ModCommonConfig.AUTO_UPDATE_DISPLAY_TYPE.get()).booleanValue()) {
                                return;
                            }
                            if (controller.getDisplayType().category() != EDisplayType.PLATFORM) {
                                AdvancedDisplaysRegistry.DisplayTypeResourceKey displayType = filter.contains("*") ? ModDisplayTypes.DEPARTURE_BOARD_TABLE : (controller.getDisplayProperties().singleLined() ? ModDisplayTypes.PLATFORM_RUNNING_TEXT : ModDisplayTypes.PLATFORM_TABLE);
                                ModCommonEvents.getCurrentServer().ifPresent(server -> server.method_40000(() -> controller.applyToAll(x -> {
                                    x.setDisplayType(displayType, null);
                                    x.notifyUpdate();
                                })));
                            }
                        }
                        List<StationDisplayData> preds = AdvancedDisplayTarget.prepare(filter, controller.getDisplayProperties().platformDisplayTrainsCount().apply(controller));
                        controller.setData(preds, filter, GlobalSettings.getInstance().getOrCreateStationTagFor(filter).getInfoForStation(filter), dayTime);
                        ModCommonEvents.getCurrentServer().ifPresent(x -> x.method_40000(() -> ((AdvancedDisplayBlockEntity)controller).notifyUpdate()));
                    } else {
                        if (controller.getDisplayType() != ModDisplayTypes.RICH_TEXT && !((Boolean)ModCommonConfig.AUTO_UPDATE_DISPLAY_TYPE.get()).booleanValue()) {
                            return;
                        }
                        StaticTextDisplaySettings settings = controller.getSettingsAs(StaticTextDisplaySettings.class).orElse(new StaticTextDisplaySettings());
                        int currentLine = line;
                        for (class_5250 comp : text) {
                            StaticTextDisplaySettings.TextComponent component = new StaticTextDisplaySettings.TextComponent(class_2561.class_2562.method_10867((class_2561)comp));
                            component.setTextAlignment(EAlignment.LEFT);
                            component.setXScale(0.4f);
                            component.setMinXScale(0.4f);
                            component.setYScale(0.4f);
                            component.setY((float)currentLine * 5.5f);
                            if (currentLine >= settings.getComponentsCount()) {
                                settings.addComponent(component);
                            } else {
                                settings.setComponent(currentLine, component);
                            }
                            if (++currentLine < controller.getYSize() * 3 - 1) continue;
                            break;
                        }
                        ModCommonEvents.getCurrentServer().ifPresent(x -> x.method_40000(() -> controller.applyToAll(a -> {
                            a.setDisplayType(ModDisplayTypes.RICH_TEXT, settings);
                            a.notifyUpdate();
                        })));
                    }
                });
            }
        }
    }

    public static List<StationDisplayData> prepare(String filter, int maxLines) {
        ArrayList<StationDisplayData> result = new ArrayList<StationDisplayData>(maxLines);
        int i = 0;
        for (TrainStop stop : TrainUtils.getDeparturesAtStationName(filter, null, false)) {
            result.add(StationDisplayData.of(stop));
            if (++i < maxLines) continue;
            break;
        }
        return result;
    }

    public boolean isReserved(int line, class_2586 target, DisplayLinkContext context) {
        return super.isReserved(line, target, context) || target instanceof AdvancedDisplayBlockEntity;
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        AdvancedDisplayBlockEntity controller = this.getController(context);
        if (controller == null) {
            return new DisplayTargetStats(1, 1024, (DisplayTarget)this);
        }
        return new DisplayTargetStats(context.blockEntity().activeSource instanceof AdvancedDisplaySource ? 1 : 50, 1024, (DisplayTarget)this);
    }

    public class_2561 getLineOptionText(int line) {
        return Lang.translateDirect((String)"display_target.advanced_display.component", (Object[])new Object[]{line + 1});
    }

    private AdvancedDisplayBlockEntity getController(DisplayLinkContext context) {
        class_2586 teIn = context.getTargetBlockEntity();
        if (!(teIn instanceof AdvancedDisplayBlockEntity)) {
            return null;
        }
        AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)teIn;
        return be.getController(new IBlockGetter.WorldBlockGetter(be.method_10997()));
    }

    public class_238 getMultiblockBounds(class_1936 level, class_2338 pos) {
        class_238 baseShape = super.getMultiblockBounds(level, pos);
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof AdvancedDisplayBlockEntity)) {
            return baseShape;
        }
        AdvancedDisplayBlockEntity fdbe = (AdvancedDisplayBlockEntity)be;
        AdvancedDisplayBlockEntity controller = fdbe.getController(new IBlockGetter.WorldBlockGetter(fdbe.method_10997()));
        if (controller == null) {
            return baseShape;
        }
        class_2382 normal = controller.getDirection().method_10170().method_10163();
        return baseShape.method_996(controller.method_11016().method_10059((class_2382)pos)).method_1012((double)(normal.method_10263() * (controller.getXSize() - 1)), (double)(1 - controller.getYSize()), (double)(normal.method_10260() * (controller.getXSize() - 1)));
    }
}

