/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.GuiBuilderWrapper;
import de.mrjulsen.crn.block.display.properties.components.IPlatformWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowArrivalSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;

public class DepartureBoardDisplayTableSettings
extends BasicDisplaySettings
implements ITimeDisplaySetting,
ITrainNameWidthSetting,
IPlatformWidthSetting,
IShowArrivalSetting,
IShowLineColorSetting {
    protected static final String NBT_INFO_WIDTH = "InfoWidth";
    protected static final String NBT_STOPOVERS_WIDTH = "StopoversWidth";
    protected ETimeDisplay timeDisplay = ETimeDisplay.ABS;
    protected byte trainNameWidth = (byte)16;
    protected byte platformWidth = (byte)16;
    protected boolean showArrival = false;
    protected boolean showLineColor = false;
    protected float infoWidthPercentage = 0.25f;
    protected float stopoversWidthPercentage = 0.33f;

    @Override
    public void deserializeNbt(class_2487 nbt) {
        super.deserializeNbt(nbt);
        if (nbt.method_10545("TimeDisplay")) {
            this.timeDisplay = ETimeDisplay.getById(nbt.method_10571("TimeDisplay"));
        }
        if (nbt.method_10545("TrainNameWidth")) {
            this.trainNameWidth = nbt.method_10571("TrainNameWidth");
        }
        if (nbt.method_10545("PlatformWidth")) {
            this.platformWidth = nbt.method_10571("PlatformWidth");
        }
        if (nbt.method_10545("ShowArrival")) {
            this.showArrival = nbt.method_10577("ShowArrival");
        }
        if (nbt.method_10545("ShowLineColor")) {
            this.showLineColor = nbt.method_10577("ShowLineColor");
        }
        if (nbt.method_10545(NBT_INFO_WIDTH)) {
            this.infoWidthPercentage = MathUtils.clamp((float)nbt.method_10583(NBT_INFO_WIDTH), (float)0.0f, (float)1.0f);
        }
        if (nbt.method_10545(NBT_STOPOVERS_WIDTH)) {
            this.stopoversWidthPercentage = MathUtils.clamp((float)nbt.method_10583(NBT_STOPOVERS_WIDTH), (float)0.0f, (float)1.0f);
        }
    }

    @Override
    public void serializeNbt(class_2487 nbt) {
        super.serializeNbt(nbt);
        nbt.method_10567("TimeDisplay", this.timeDisplay.getId());
        nbt.method_10567("TrainNameWidth", this.trainNameWidth);
        nbt.method_10567("PlatformWidth", this.platformWidth);
        nbt.method_10556("ShowArrival", this.showArrival);
        nbt.method_10556("ShowLineColor", this.showLineColor);
        nbt.method_10548(NBT_INFO_WIDTH, this.infoWidthPercentage);
        nbt.method_10548(NBT_STOPOVERS_WIDTH, this.stopoversWidthPercentage);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildTimeDisplayGui(context);
        this.buildTrainNameGui(context, false, false);
        this.buildPlatformWidthGui(context, false);
        GuiBuilderWrapper.buildDepartureBoardTableGui(this, context);
        this.buildShowArrivalGui(context);
        this.buildShowLineColorGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyTimeDisplaySetting(oldSettings);
        this.copyTrainNameSetting(oldSettings);
        this.copyPlatformWidthSetting(oldSettings);
        this.copyShowArrivalSetting(oldSettings);
        this.copyShowLineColorSetting(oldSettings);
    }

    @Override
    public ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    @Override
    public void setTimeDisplay(ETimeDisplay display) {
        this.timeDisplay = display;
    }

    @Override
    public byte getPlatformWidth() {
        return this.platformWidth;
    }

    @Override
    public void setPlatformWidth(byte b) {
        this.platformWidth = b;
    }

    @Override
    public byte getTrainNameWidth() {
        return this.trainNameWidth;
    }

    @Override
    public void setTrainNameWidth(byte b) {
        this.trainNameWidth = b;
    }

    @Override
    public boolean showArrival() {
        return this.showArrival;
    }

    @Override
    public void setShowArrival(boolean b) {
        this.showArrival = b;
    }

    public float getInfoWidthPercentage() {
        return this.infoWidthPercentage;
    }

    public float getStopoversWidthPercentage() {
        return this.stopoversWidthPercentage;
    }

    public void setInfoWidthPercentage(float f) {
        this.infoWidthPercentage = MathUtils.clamp((float)f, (float)0.0f, (float)1.0f);
    }

    public void setStopoversWidthPercentage(float f) {
        this.stopoversWidthPercentage = MathUtils.clamp((float)f, (float)0.0f, (float)1.0f);
    }

    public void setInfoWidthPercentageInt(byte f) {
        this.infoWidthPercentage = (float)MathUtils.clamp((int)f, (int)0, (int)100) / 100.0f;
    }

    public void setStopoversWidthPercentageInt(byte f) {
        this.stopoversWidthPercentage = (float)MathUtils.clamp((int)f, (int)0, (int)100) / 100.0f;
    }

    @Override
    public boolean showLineColor() {
        return this.showLineColor;
    }

    @Override
    public void setShowLineColor(boolean b) {
        this.showLineColor = b;
    }
}

