/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.IPlatformWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowArrivalSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowTimeAndDateSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;

public class PlatformDisplayTableSettings
extends BasicDisplaySettings
implements ITimeDisplaySetting,
ITrainNameWidthSetting,
IPlatformWidthSetting,
IShowArrivalSetting,
IShowLineColorSetting,
IShowTimeAndDateSetting {
    protected ETimeDisplay timeDisplay = ETimeDisplay.ABS;
    protected byte trainNameWidth = (byte)16;
    protected byte platformWidth = (byte)-1;
    protected boolean showArrival = true;
    protected boolean showLineColor = false;
    protected boolean showTimeAndDate = true;

    @Override
    public void deserializeNbt(class_2487 nbt) {
        super.deserializeNbt(nbt);
        if (nbt.method_10545("TimeDisplay")) {
            this.timeDisplay = ETimeDisplay.getById(nbt.method_10571("TimeDisplay"));
        }
        if (nbt.method_10545("TrainNameWidth")) {
            this.trainNameWidth = nbt.method_10571("TrainNameWidth");
        }
        if (nbt.method_10545("PlatformWidth")) {
            this.platformWidth = nbt.method_10571("PlatformWidth");
        }
        if (nbt.method_10545("ShowArrival")) {
            this.showArrival = nbt.method_10577("ShowArrival");
        }
        if (nbt.method_10545("ShowLineColor")) {
            this.showLineColor = nbt.method_10577("ShowLineColor");
        }
        if (nbt.method_10545("ShowTime")) {
            this.showTimeAndDate = nbt.method_10577("ShowTime");
        }
    }

    @Override
    public void serializeNbt(class_2487 nbt) {
        super.serializeNbt(nbt);
        nbt.method_10567("TimeDisplay", this.timeDisplay.getId());
        nbt.method_10567("TrainNameWidth", this.trainNameWidth);
        nbt.method_10567("PlatformWidth", this.platformWidth);
        nbt.method_10556("ShowArrival", this.showArrival);
        nbt.method_10556("ShowLineColor", this.showLineColor);
        nbt.method_10556("ShowTime", this.showTimeAndDate);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildTimeDisplayGui(context);
        this.buildTrainNameGui(context, true, false);
        this.buildPlatformWidthGui(context, true);
        this.buildShowArrivalGui(context);
        this.buildShowLineColorGui(context);
        this.buildShowTimeAndDateGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyTimeDisplaySetting(oldSettings);
        this.copyTrainNameSetting(oldSettings);
        this.copyPlatformWidthSetting(oldSettings);
        this.copyShowArrivalSetting(oldSettings);
        this.copyShowLineColorSetting(oldSettings);
        this.copyShowTimeAndDateSetting(oldSettings);
    }

    @Override
    public ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    @Override
    public void setTimeDisplay(ETimeDisplay display) {
        this.timeDisplay = display;
    }

    @Override
    public byte getPlatformWidth() {
        return this.platformWidth;
    }

    @Override
    public void setPlatformWidth(byte b) {
        this.platformWidth = b;
    }

    @Override
    public byte getTrainNameWidth() {
        return this.trainNameWidth;
    }

    @Override
    public void setTrainNameWidth(byte b) {
        this.trainNameWidth = b;
    }

    @Override
    public boolean showArrival() {
        return this.showArrival;
    }

    @Override
    public void setShowArrival(boolean b) {
        this.showArrival = b;
    }

    @Override
    public boolean showLineColor() {
        return this.showLineColor;
    }

    @Override
    public void setShowLineColor(boolean b) {
        this.showLineColor = b;
    }

    @Override
    public void setShowTimeAndDate(boolean showTimeAndDate) {
        this.showTimeAndDate = showTimeAndDate;
    }

    @Override
    public boolean showTimeAndDate() {
        return this.showTimeAndDate;
    }
}

