/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.GuiBuilderWrapper;
import de.mrjulsen.crn.block.display.properties.components.IStaticTextSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextBackgroundColorSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextPosSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextScaleSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextWidthSetting;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class StaticTextDisplaySettings
extends BasicDisplaySettings
implements IStaticTextSetting,
ITextScaleSetting,
ITextPosSetting,
ITextWidthSetting,
ITextBackgroundColorSetting {
    public static final byte MAX_COMPONENTS = 50;
    private static final String NBT_COMPONENTS = "Components";
    private static final String NBT_SELECTED_COMPONENT = "SelectedComponent";
    private final List<TextComponent> components = new ArrayList<TextComponent>();
    protected byte selectedComponent = 0;

    public StaticTextDisplaySettings() {
        this.components.add(new TextComponent("Hello World"));
    }

    @Override
    public void deserializeNbt(class_2487 nbt) {
        super.deserializeNbt(nbt);
        if (nbt.method_10545(NBT_COMPONENTS)) {
            this.components.clear();
            this.components.addAll(nbt.method_10554(NBT_COMPONENTS, 10).stream().map(x -> TextComponent.fromNbt((class_2487)x)).toList());
        }
        if (nbt.method_10545(NBT_SELECTED_COMPONENT)) {
            this.selectedComponent = nbt.method_10571(NBT_SELECTED_COMPONENT);
        }
        if (this.components.isEmpty()) {
            this.components.add(new TextComponent("Hello World"));
        }
        this.verifyComponents();
    }

    @Override
    public void serializeNbt(class_2487 nbt) {
        this.verifyComponents();
        super.serializeNbt(nbt);
        class_2499 list = new class_2499();
        int k = 0;
        for (TextComponent component : this.components) {
            list.add((Object)component.toNbt());
            if (++k < 50) continue;
            break;
        }
        nbt.method_10566(NBT_COMPONENTS, (class_2520)list);
        nbt.method_10567(NBT_SELECTED_COMPONENT, this.selectedComponent);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        GuiBuilderWrapper.buildStaticTextBaseGui(this, context);
        this.buildStaticTextGui(context);
        this.buildTextPosGui(context);
        this.buildTextScaleGui(context);
        this.buildTextMaxWidthGui(context);
        this.buildTextBackgroundColorGui(context);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        currentIndex = this.getSelectedComponentIndex();
        if (!(oldSettings instanceof StaticTextDisplaySettings)) ** GOTO lbl-1000
        o = (StaticTextDisplaySettings)oldSettings;
        if (!o.components.isEmpty() && this != o) {
            this.components.clear();
            for (i = 0; i < o.getComponentsCount(); i = (int)((byte)(i + 1))) {
                this.components.add(new TextComponent());
                this.selectedComponent = (byte)i;
                o.selectedComponent = (byte)i;
                this.copyStaticTextSettings(oldSettings);
                this.copyTextScaleSettings(oldSettings);
                this.copyTextPosSettings(oldSettings);
                this.copyTextMaxWidthSetting(oldSettings);
                this.copyTextBackgroundColorSettings(oldSettings);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.copyStaticTextSettings(oldSettings);
            this.copyTextScaleSettings(oldSettings);
            this.copyTextPosSettings(oldSettings);
            this.copyTextMaxWidthSetting(oldSettings);
            this.copyTextBackgroundColorSettings(oldSettings);
        }
        this.setSelectedComponentIndex(currentIndex);
    }

    public TextComponent getSelectedComponent() {
        return this.components.isEmpty() ? new TextComponent() : this.components.get(MathUtils.clamp((int)this.selectedComponent, (int)0, (int)(this.components.size() - 1)));
    }

    public List<TextComponent> getComponents() {
        return ImmutableList.copyOf(this.components);
    }

    public void addComponent(TextComponent component) {
        this.components.add(component);
        this.verifyComponents();
    }

    public void setComponent(int index, TextComponent component) {
        this.components.set(index, component);
    }

    public int getComponentsCount() {
        return this.components.size();
    }

    public byte getSelectedComponentIndex() {
        return this.selectedComponent;
    }

    public void setSelectedComponentIndex(int index) {
        this.selectedComponent = (byte)MathUtils.clamp((int)index, (int)0, (int)(this.components.size() - 1));
    }

    @Override
    public String getStaticText() {
        return this.getSelectedComponent().staticText;
    }

    @Override
    public void setStaticText(String text) {
        this.getSelectedComponent().staticText = text;
    }

    @Override
    public float getXScale() {
        return this.getSelectedComponent().xScale;
    }

    @Override
    public void setXScale(float xScale) {
        this.getSelectedComponent().xScale = xScale;
    }

    @Override
    public float getYScale() {
        return this.getSelectedComponent().yScale;
    }

    @Override
    public void setYScale(float f) {
        this.getSelectedComponent().yScale = f;
    }

    @Override
    public float getMinXScale() {
        return this.getSelectedComponent().minXScale;
    }

    @Override
    public void setMinXScale(float f) {
        this.getSelectedComponent().minXScale = f;
    }

    @Override
    public ITextWidthSetting.TextScaleBounds getBoundsAction() {
        return this.getSelectedComponent().bounds;
    }

    @Override
    public void setBoundsAction(ITextWidthSetting.TextScaleBounds action) {
        this.getSelectedComponent().bounds = action;
    }

    @Override
    public float getX() {
        return this.getSelectedComponent().x;
    }

    @Override
    public void setX(float x) {
        this.getSelectedComponent().x = x;
    }

    @Override
    public float getY() {
        return this.getSelectedComponent().y;
    }

    @Override
    public void setY(float y) {
        this.getSelectedComponent().y = y;
    }

    @Override
    public EAlignment getTextAlignment() {
        return this.getSelectedComponent().alignment;
    }

    @Override
    public void setTextAlignment(EAlignment alignment) {
        this.getSelectedComponent().alignment = alignment;
    }

    @Override
    public float getTextMaxWidth() {
        return this.getSelectedComponent().maxWidth;
    }

    @Override
    public void setTextMaxWidth(float s) {
        this.getSelectedComponent().maxWidth = s;
    }

    @Override
    public int getTextBackgroundColor() {
        return this.getSelectedComponent().backgroundColor;
    }

    @Override
    public void setTextBackgroundColor(int color) {
        this.getSelectedComponent().backgroundColor = color;
    }

    @Override
    public boolean isFullLabelBackgroundColor() {
        return this.getSelectedComponent().fullLabelColor;
    }

    @Override
    public void setFullLabelBackgroundColor(boolean b) {
        this.getSelectedComponent().fullLabelColor = b;
    }

    public void verifyComponents() {
        int k;
        TextComponent current = this.getSelectedComponentIndex() > 0 && this.getSelectedComponentIndex() < this.components.size() ? this.components.get(this.getSelectedComponentIndex()) : null;
        Iterator<TextComponent> components = this.components.iterator();
        int i = 1;
        while (components.hasNext()) {
            TextComponent comp = components.next();
            if (i > 50 || comp.staticText == null || comp.staticText.isBlank()) {
                components.remove();
            }
            ++i;
        }
        int n = k = current == null ? -1 : this.components.indexOf(current);
        if (k < 0) {
            this.setSelectedComponentIndex(this.getSelectedComponentIndex());
        }
    }

    public void createNewComponent() {
        if (this.components.size() < 50) {
            this.components.add(new TextComponent());
        }
    }

    public static class TextComponent {
        String staticText = "";
        float xScale = 0.75f;
        float yScale = 0.75f;
        float minXScale = 0.75f;
        ITextWidthSetting.TextScaleBounds bounds = ITextWidthSetting.DEFAULT_BOUNDS_ACTION;
        float x = 0.0f;
        float y = 2.5f;
        float maxWidth = 250.0f;
        EAlignment alignment = ITextPosSetting.DEFAULT_TEXT_ALIGNMENT;
        int backgroundColor = 0;
        boolean fullLabelColor = false;

        public TextComponent() {
        }

        public TextComponent(String text) {
            this.staticText = text;
        }

        public String getStaticText() {
            return this.staticText;
        }

        public void setStaticText(String text) {
            this.staticText = text == null ? "" : text;
        }

        public float getXScale() {
            return this.xScale;
        }

        public void setXScale(float xScale) {
            this.xScale = xScale;
        }

        public float getYScale() {
            return this.yScale;
        }

        public void setYScale(float f) {
            this.yScale = f;
        }

        public float getMinXScale() {
            return this.minXScale;
        }

        public void setMinXScale(float f) {
            this.minXScale = f;
        }

        public ITextWidthSetting.TextScaleBounds getBoundsAction() {
            return this.bounds;
        }

        public void setBoundsAction(ITextWidthSetting.TextScaleBounds action) {
            this.bounds = action;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
        }

        public EAlignment getTextAlignment() {
            return this.alignment;
        }

        public void setTextAlignment(EAlignment alignment) {
            this.alignment = alignment;
        }

        public float getTextMaxWidth() {
            return this.maxWidth;
        }

        public void setTextMaxWidth(float s) {
            this.maxWidth = s;
        }

        public int getTextBackgroundColor() {
            return this.backgroundColor;
        }

        public void setTextBackgroundColor(int color) {
            this.backgroundColor = color;
        }

        public boolean isFullLabelBackgroundColor() {
            return this.fullLabelColor;
        }

        public void setFullLabelBackgroundColor(boolean b) {
            this.fullLabelColor = b;
        }

        public static TextComponent fromNbt(class_2487 nbt) {
            TextComponent comp = new TextComponent();
            if (nbt.method_10545("StaticText")) {
                comp.staticText = nbt.method_10558("StaticText");
            }
            if (nbt.method_10545("XScale")) {
                comp.xScale = nbt.method_10583("XScale");
            }
            if (nbt.method_10545("YScale")) {
                comp.yScale = nbt.method_10583("YScale");
            }
            if (nbt.method_10545("MinXScale")) {
                comp.minXScale = nbt.method_10583("MinXScale");
            }
            if (nbt.method_10545("BoundsAction")) {
                comp.bounds = ITextWidthSetting.TextScaleBounds.getByIndex(nbt.method_10571("BoundsAction"));
            }
            if (nbt.method_10545("PosX")) {
                comp.x = nbt.method_10583("PosX");
            }
            if (nbt.method_10545("PosY")) {
                comp.y = nbt.method_10583("PosY");
            }
            if (nbt.method_10545("TextMaxWidth")) {
                comp.maxWidth = nbt.method_10583("TextMaxWidth");
            }
            if (nbt.method_10545("TextAlignment")) {
                comp.alignment = EAlignment.getById((int)nbt.method_10550("TextAlignment"));
            }
            if (nbt.method_10545("TextBackgroundColor")) {
                comp.backgroundColor = nbt.method_10550("TextBackgroundColor");
            }
            if (nbt.method_10545("FullLabelBackgroundColor")) {
                comp.fullLabelColor = nbt.method_10577("FullLabelBackgroundColor");
            }
            return comp;
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("StaticText", this.staticText);
            nbt.method_10548("XScale", this.xScale);
            nbt.method_10548("YScale", this.yScale);
            nbt.method_10548("MinXScale", this.minXScale);
            nbt.method_10567("BoundsAction", this.bounds.getIndex());
            nbt.method_10548("PosX", this.x);
            nbt.method_10548("PosY", this.y);
            nbt.method_10548("TextMaxWidth", this.maxWidth);
            nbt.method_10569("TextAlignment", this.alignment.getId());
            nbt.method_10569("TextBackgroundColor", this.backgroundColor);
            nbt.method_10556("FullLabelBackgroundColor", this.fullLabelColor);
            return nbt;
        }

        public String toString() {
            return this.staticText;
        }
    }
}

