/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.DepartureBoardDisplayTableSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class BERDepartureBoardTable
implements AbstractAdvancedDisplayRenderer<DepartureBoardDisplayTableSettings> {
    private final class_5250 textTrainTerminates = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final String keyDeparture = "gui.createrailwaysnavigator.departure";
    private static final String keyTrain = "gui.createrailwaysnavigator.line";
    private static final String keyDestination = "gui.createrailwaysnavigator.destination";
    private static final String keyPlatform = "gui.createrailwaysnavigator.platform";
    private static final String keyVia = "gui.createrailwaysnavigator.via";
    private static final String keyTooSmall = "gui.createrailwaysnavigator.too_small";
    private static final int MIN_SIZE = 4;
    private static final float LINE_HEIGHT = 5.4f;
    private static final float Y_OFFSET = 5.4f;
    private static final float SPACING = 2.0f;
    private static final float TIME_LABEL_MAX_WIDTH = 12.0f;
    private static final float REAL_TIME_LABEL_MAX_WIDTH = 12.0f;
    private boolean showInfoLine = false;
    private class_5250 infoLineText = TextUtils.empty();
    private int maxLines = 0;
    private final BERLabel statusLabel = new BERLabel((class_2561)TextUtils.empty()).setCentered(true).setScale(0.4f, 0.4f).setYScale(0.4f).setColor(-15658735).setBackground(-1, true).setScrollingSpeed(2.0f);
    private final BERLabel tooSmallLabel = new BERLabel((class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.too_small")).setCentered(false).setScale(0.4f, 0.4f).setYScale(0.4f).setPos(3.0f, 3.0f);
    private BERLabel[][] lines = new BERLabel[0][];
    private final BERLabel[] headlines = new BERLabel[LineComponent.values().length];

    public BERDepartureBoardTable() {
        this.headlines[LineComponent.TIME.i()] = new BERLabel().setText((class_2561)CustomLanguage.translate(keyDeparture).method_27692(class_124.field_1067).method_27692(class_124.field_1056)).setYScale(0.4f).setMaxWidth(12.5f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setPos(0.0f, 3.0f).setMaxWidth(0.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        this.headlines[LineComponent.TRAIN_NAME.i()] = new BERLabel().setText((class_2561)CustomLanguage.translate(keyTrain).method_27692(class_124.field_1067).method_27692(class_124.field_1056)).setYScale(0.4f).setScrollingSpeed(2.0f).setMaxWidth(14.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setPos(0.0f, 3.0f).setMaxWidth(0.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        this.headlines[LineComponent.PLATFORM.i()] = new BERLabel().setText((class_2561)CustomLanguage.translate(keyPlatform).method_27692(class_124.field_1067).method_27692(class_124.field_1056)).setYScale(0.4f).setScale(0.4f, 0.2f).setPos(0.0f, 3.0f).setMaxWidth(0.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        this.headlines[LineComponent.DESTINATION.i()] = new BERLabel().setText((class_2561)CustomLanguage.translate(keyDestination).method_27692(class_124.field_1067).method_27692(class_124.field_1056)).setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setPos(0.0f, 3.0f).setMaxWidth(0.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        this.headlines[LineComponent.STOPOVERS.i()] = new BERLabel().setText((class_2561)CustomLanguage.translate(keyVia).method_27692(class_124.field_1067).method_27692(class_124.field_1056)).setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setPos(0.0f, 3.0f).setMaxWidth(0.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        this.headlines[LineComponent.INFO.i()] = new BERLabel().setText((class_2561)TextUtils.empty()).setPos(0.0f, 3.0f).setMaxWidth(0.0f, BERLabel.BoundsHitReaction.CUT_OFF);
    }

    @Override
    public void renderTick(float deltaTime) {
        this.statusLabel.renderTick();
        DLUtils.doIfNotNull((Object)this.lines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                BERLabel[] line = x[i];
                if (line == null) continue;
                for (int k = 0; k < line.length; ++k) {
                    DLUtils.doIfNotNull((Object)line[k], y -> y.renderTick());
                }
            }
        });
        for (int k = 0; k < this.headlines.length; ++k) {
            DLUtils.doIfNotNull((Object)this.headlines[k], y -> y.renderTick());
        }
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        BERUtils.fillColor(graphics, (float)2.0f, (float)6.9f, (float)0.0f, (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 4), (float)0.25f, (int)(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)light);
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() < 4) {
            this.tooSmallLabel.render(graphics, light);
            return;
        }
        for (int k = 0; k < this.headlines.length; ++k) {
            DLUtils.doIfNotNull((Object)this.headlines[k], y -> y.render((RenderGraphics)graphics, light));
        }
        for (int i = 0; i < this.lines.length && i < this.maxLines; ++i) {
            graphics.poseStack().method_22903();
            if (i % 2 == 1) {
                BERUtils.fillColor(graphics, (float)2.0f, (float)(7.4f + (float)i * 5.4f), (float)0.0f, (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 4), (float)5.4f, (int)(0x40000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)));
                graphics.poseStack().method_46416(0.0f, 0.0f, 0.05f);
            }
            for (int k = 0; k < this.lines[i].length; ++k) {
                DLUtils.doIfNotNull((Object)this.lines[i][k], x -> x.render((RenderGraphics)graphics, light));
            }
            graphics.poseStack().method_22909();
        }
        if (this.showInfoLine) {
            this.statusLabel.render(graphics, light);
        }
    }

    private Optional<class_2561> getStatusInfo(AdvancedDisplayBlockEntity blockEntity, StationDisplayData data, boolean singleTrain) {
        if (!(data.getTrainData().hasStatusInfo() && data.getStationData().isDepartureDelayed() || data.getStationData().isStationChanged() || data.isNextSectionExcluded())) {
            return Optional.empty();
        }
        ArrayList<Object> content = new ArrayList<Object>();
        if (data.getTrainData().isCancelled()) {
            content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.cancelled"));
        }
        if (data.isNextSectionExcluded()) {
            content.add(this.textTrainTerminates);
        }
        if (data.getStationData().isDepartureDelayed()) {
            String delay = ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA ? ModUtils.timeRemainingString(data.getStationData().getDepartureTimeDeviation()) : String.valueOf(TimeUtils.formatToMinutes((long)data.getStationData().getDepartureTimeDeviation()));
            class_5250 delayComponent = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delayed", delay);
            if (((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ABS) {
                delayComponent.method_27693(" ").method_10852((class_2561)CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delay_abs_suffix"));
            }
            content.add(delayComponent);
        }
        if (data.getStationData().isStationChanged()) {
            if (!data.getStationData().getScheduledStation().tagId().equals(data.getStationData().getRealTimeStation().tagId())) {
                content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_and_station_changed", data.getStationData().getRealTimeStation().tagName(), data.getStationData().getRealTimeStation().info().platform()));
            } else {
                content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_changed", data.getStationData().getRealTimeStation().info().platform()));
            }
        }
        for (TrainStatus.CompiledTrainStatus status : data.getTrainData().getStatus()) {
            content.add(status.text());
        }
        if (singleTrain) {
            return Optional.ofNullable(TextUtils.concat(content));
        }
        return Optional.ofNullable(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.information_about_train", data.getTrainData().getName()).method_27693(": ").method_10852((class_2561)TextUtils.concat((class_2561)TextUtils.text((String)" - "), content)));
    }

    @Override
    public void update(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        List<StationDisplayData> preds = blockEntity.getStops().stream().filter(x -> !(x.isNextSectionExcluded() && !((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).showArrival() || x.getTrainData().isCancelled() && DragonLib.getCurrentWorldTime() >= x.getStationData().getScheduledDepartureTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue())).toList();
        MutableBoolean shouldShowLine = new MutableBoolean(false);
        this.infoLineText = TextUtils.concat((class_2561)TextUtils.text((String)"  +++  "), (class_2561[])((class_2561[])preds.stream().limit(this.maxLines).filter(x -> x.getTrainData().hasStatusInfo() && x.getStationData().isDepartureDelayed() || x.getStationData().isStationChanged()).flatMap(x -> {
            shouldShowLine.setTrue();
            return this.getStatusInfo(blockEntity, (StationDisplayData)x, false).stream();
        }).toArray(class_2561[]::new)));
        this.showInfoLine = shouldShowLine.isTrue();
        if (!this.showInfoLine) {
            this.infoLineText = TextUtils.empty();
        }
        int defaultMaxLines = blockEntity.getYSizeScaled() * 3 - 2;
        this.maxLines = defaultMaxLines - (this.showInfoLine ? 1 : 0);
        int maxIndices = Math.max(0, Math.min(this.maxLines, preds.size()));
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || this.lines == null || this.lines.length != maxIndices) {
            this.updateLayout(blockEntity, preds, maxIndices);
        }
        for (int i = 0; i < this.lines.length && i < preds.size(); ++i) {
            StationDisplayData stop = preds.get(i);
            this.updateContent(blockEntity, stop, i, false, 0.0f, 0.0f, 0.0f);
        }
        this.statusLabel.setText((class_2561)this.infoLineText).setPos(3.0f, (float)(blockEntity.getYSizeScaled() * 16) - 12.0f * this.statusLabel.getYScale() - 2.0f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(ColorUtils.brightnessDependingFontColor((int)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (int)-1118482, (int)-15658735));
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, List<StationDisplayData> preds, int maxIndices) {
        DepartureBoardDisplayTableSettings settings = (DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity);
        if (blockEntity.getXSizeScaled() < 4) {
            this.tooSmallLabel.setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
            return;
        }
        boolean hasStopovers = blockEntity.getXSizeScaled() - 4 >= 4;
        boolean hasInfo = blockEntity.getXSizeScaled() - 4 >= 7;
        BERLabel hTimeLabel = this.headlines[LineComponent.TIME.i()];
        hTimeLabel.setPos(3.0f, hTimeLabel.getY()).setMaxWidth(12.0f + (!this.isSmall(blockEntity) ? 12.0f : 0.0f) + 2.0f, BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        BERLabel hTrainLabel = this.headlines[LineComponent.TRAIN_NAME.i()];
        hTrainLabel.setPos(hTimeLabel.getX() + hTimeLabel.getMaxWidth() + 2.0f, hTrainLabel.getY()).setMaxWidth((float)settings.getTrainNameWidth(), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        BERLabel hPlatformLabel = this.headlines[LineComponent.PLATFORM.i()];
        float hPlatformLabelWidth = settings.getPlatformWidth();
        hPlatformLabel.setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - Math.min(hPlatformLabelWidth, hPlatformLabel.getTextWidth()), hPlatformLabel.getY()).setMaxWidth(hPlatformLabelWidth, BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        float remainingSpace = (float)(blockEntity.getXSizeScaled() * 16 - 3) - hTrainLabel.getX() - hTrainLabel.getMaxWidth() - (float)settings.getPlatformWidth() - 2.0f;
        float infoSpace = hasInfo ? remainingSpace * settings.getInfoWidthPercentage() - 2.0f : 0.0f;
        float stopoversSpace = hasStopovers ? remainingSpace * settings.getStopoversWidthPercentage() - 2.0f : 0.0f;
        float destinationSpace = remainingSpace - infoSpace - stopoversSpace - 6.0f;
        BERLabel hStopoversLabel = this.headlines[LineComponent.STOPOVERS.i()];
        hStopoversLabel.setPos(hasStopovers ? hTrainLabel.getX() + hTrainLabel.getMaxWidth() + 2.0f : 0.0f, hStopoversLabel.getY()).setMaxWidth(hasStopovers ? stopoversSpace : 0.0f, BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        BERLabel hDestinationLabel = this.headlines[LineComponent.DESTINATION.i()];
        hDestinationLabel.setPos(hasStopovers ? hStopoversLabel.getX() + hStopoversLabel.getMaxWidth() + 2.0f : hTrainLabel.getX() + hTrainLabel.getMaxWidth() + 2.0f, hDestinationLabel.getY()).setMaxWidth(Math.min(hDestinationLabel.getX() + destinationSpace, (float)(blockEntity.getXSizeScaled() * 16 - 3) - hPlatformLabel.getTextWidth() - 2.0f) - hDestinationLabel.getX(), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        BERLabel hInfoLabel = this.headlines[LineComponent.INFO.i()];
        hInfoLabel.setPos(hasInfo ? hDestinationLabel.getX() + hDestinationLabel.getMaxWidth() + 2.0f : 0.0f, hDestinationLabel.getY()).setMaxWidth(hasInfo ? Math.min(hInfoLabel.getX() + (infoSpace - 2.0f), (float)(blockEntity.getXSizeScaled() * 16 - 3) - hInfoLabel.getX() - hPlatformLabel.getTextWidth() - 2.0f) - hInfoLabel.getX() : 0.0f, BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        this.lines = new BERLabel[maxIndices][];
        for (int i = 0; i < this.lines.length; ++i) {
            StationDisplayData stop = preds.get(i);
            this.lines[i] = this.createLine(blockEntity, stop, i, hasStopovers, hasInfo);
            this.updateContent(blockEntity, stop, i, true, stopoversSpace, infoSpace, destinationSpace);
        }
        this.statusLabel.setBackground(0xFF000000 | settings.getFontColor() & 0xFFFFFF, true).setColor(ColorUtils.brightnessDependingFontColor((int)settings.getFontColor(), (int)-1118482, (int)-15658735));
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index, boolean layoutUpdate, float stopoversSize, float infoLineWidth, float destinationWidth) {
        boolean hasInfo;
        DepartureBoardDisplayTableSettings settings = (DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity);
        boolean isLast = settings.showArrival() && stop.shouldShowArrivalOfTrain() || stop.isNextSectionExcluded();
        boolean showInfoLine = stop.getStationData().isDepartureDelayed() && stop.getTrainData().hasStatusInfo() || stop.getStationData().isStationChanged() || stop.isNextSectionExcluded();
        BERLabel[] components = this.lines[index];
        BERLabel timeLabel = components[LineComponent.TIME.i()].setText((class_2561)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), settings.getTimeDisplay() == ETimeDisplay.ETA)));
        BERLabel realTimeLabel = components[LineComponent.REAL_TIME.i()].setText((class_2561)(this.isSmall(blockEntity) ? TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), settings.getTimeDisplay() == ETimeDisplay.ETA)) : TextUtils.text((String)(stop.getTrainData().isCancelled() ? " \u274c " : (stop.getStationData().isDepartureDelayed() ? ModUtils.formatTime(stop.getRealTime(), settings.getTimeDisplay() == ETimeDisplay.ETA) : ""))))).setColor(this.isSmall(blockEntity) ? 0xFF000000 | settings.getFontColor() & 0xFFFFFF : ColorUtils.brightnessDependingFontColor((int)settings.getFontColor(), (int)-1118482, (int)-15658735));
        BERLabel trainLabel = components[LineComponent.TRAIN_NAME.i()].setText((class_2561)TextUtils.text((String)stop.getTrainData().getName()));
        if (settings.showLineColor() && stop.getTrainData().hasColor()) {
            trainLabel.setBackground(0xFF000000 | stop.getTrainData().getColor() & 0xFFFFFF, false).setColor(ColorUtils.brightnessDependingFontColor((int)stop.getTrainData().getColor(), (int)-1118482, (int)-15658735));
        } else {
            trainLabel.setBackground(0, false).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        }
        BERLabel destinationLabel = components[LineComponent.DESTINATION.i()].setText((class_2561)(isLast ? CustomLanguage.translate("gui.createrailwaysnavigator.schedule_board.train_from", stop.getFirstStopName()) : TextUtils.text((String)stop.getStationData().getDestination())));
        BERLabel stopoversLabel = components[LineComponent.STOPOVERS.i()];
        boolean hasTransfers = stopoversLabel != null;
        BERLabel infoLabel = components[LineComponent.INFO.i()];
        boolean bl = hasInfo = infoLabel != null;
        if (hasTransfers) {
            stopoversLabel.setText((class_2561)(isLast ? TextUtils.empty() : TextUtils.concat((class_2561)TextUtils.text((String)" \u25cf "), stop.getStopovers().stream().map(a -> TextUtils.text((String)a)).toList())));
        }
        if (hasInfo) {
            if (showInfoLine) {
                infoLabel.setText(this.getStatusInfo(blockEntity, stop, true).orElse((class_2561)TextUtils.empty())).setColor(ColorUtils.brightnessDependingFontColor((int)settings.getFontColor(), (int)-1118482, (int)-15658735));
            } else {
                infoLabel.setText((class_2561)TextUtils.empty());
            }
        }
        BERLabel platformLabel = components[LineComponent.PLATFORM.i()];
        platformLabel.setText((class_2561)TextUtils.text((String)stop.getStationData().getRealTimeStation().info().platform())).setMaxWidth((float)settings.getPlatformWidth(), BERLabel.BoundsHitReaction.SCALE_SCROLL).setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - platformLabel.getTextWidth(), 8.4f + (float)index * 5.4f);
        if (stop.getStationData().isStationChanged()) {
            platformLabel.setBackground(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, false).setColor(-15658735);
        } else {
            platformLabel.setBackground(0, false).setColor(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        }
        if (layoutUpdate) {
            timeLabel.setPos(this.headlines[LineComponent.TIME.i()].getX(), 8.4f + (float)index * 5.4f);
            realTimeLabel.setPos(timeLabel.getX() + timeLabel.getMaxWidth() + 2.0f, 8.4f + (float)index * 5.4f);
            trainLabel.setPos(this.headlines[LineComponent.TRAIN_NAME.i()].getX(), 8.4f + (float)index * 5.4f);
            destinationLabel.setPos(this.headlines[LineComponent.DESTINATION.i()].getX(), 8.4f + (float)index * 5.4f).setMaxWidth(destinationWidth, BERLabel.BoundsHitReaction.SCALE_SCROLL);
            if (hasTransfers) {
                stopoversLabel.setPos(hasTransfers ? this.headlines[LineComponent.STOPOVERS.i()].getX() : 0.0f, 8.4f + (float)index * 5.4f + 0.5f).setMaxWidth(hasTransfers ? stopoversSize : 0.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL);
            }
            if (hasInfo) {
                infoLabel.setPos(showInfoLine ? this.headlines[LineComponent.INFO.i()].getX() : 0.0f, 8.4f + (float)index * 5.4f).setMaxWidth(showInfoLine ? infoLineWidth : 0.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL);
            }
        }
    }

    private BERLabel[] createLine(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index, boolean withStopovers, boolean withInfo) {
        BERLabel[] components = new BERLabel[LineComponent.values().length];
        boolean isSmall = this.isSmall(blockEntity);
        components[LineComponent.TIME.i()] = new BERLabel().setYScale(0.4f).setMaxWidth(isSmall ? -2.0f : 12.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        components[LineComponent.REAL_TIME.i()] = new BERLabel().setYScale(0.4f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        if (!isSmall) {
            components[LineComponent.REAL_TIME.i()].setBackground(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, false).setColor(-15658735);
        }
        components[LineComponent.TRAIN_NAME.i()] = new BERLabel().setYScale(0.4f).setScrollingSpeed(2.0f).setMaxWidth((float)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTrainNameWidth(), BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        components[LineComponent.PLATFORM.i()] = new BERLabel().setYScale(0.4f).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        components[LineComponent.DESTINATION.i()] = new BERLabel().setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        if (withStopovers) {
            components[LineComponent.STOPOVERS.i()] = new BERLabel().setYScale(0.3f).setScrollingSpeed(2.0f).setScale(0.3f, 0.2f).setColor(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        }
        if (withInfo) {
            components[LineComponent.INFO.i()] = new BERLabel().setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setColor(-15658735).setBackground(0xFF000000 | ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, true);
        }
        return components;
    }

    private boolean isSmall(AdvancedDisplayBlockEntity blockEntity) {
        return blockEntity.getXSizeScaled() <= 4;
    }

    private static enum LineComponent {
        TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4),
        STOPOVERS(5),
        INFO(6);

        int index;

        private LineComponent(int index) {
            this.index = index;
        }

        public int i() {
            return this.index;
        }
    }
}

