/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PassengerInformationScrollingTextSettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class BERPassengerInfoSimple
implements AbstractAdvancedDisplayRenderer<PassengerInformationScrollingTextSettings> {
    private final class_5250 textTrainTerminatesHere = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.this_train_terminates_there").method_27693(" ").method_10852((class_2561)CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.passengers_leave_train"));
    private final class_5250 textTrainTerminated = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyDate = "gui.createrailwaysnavigator.route_overview.date";
    private static final int TICKS_PER_SLIDE = 100;
    private TrainExitSide exitSide = TrainExitSide.UNKNOWN;
    private final BERLabel label = new BERLabel().setPos(3.0f, 5.5f).setYScale(0.75f).setScale(0.75f, 0.75f).setCentered(true).setScrollingSpeed(2.0f);

    @Override
    public void renderTick(float deltaTime) {
        this.label.renderTick();
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isOutOfService()) {
            return;
        }
        float uv = 0.00390625f;
        TrainExitSide side = this.exitSide;
        if (backSide) {
            side = side.getOpposite();
        }
        switch (side) {
            case RIGHT: {
                BERUtils.renderTexture((class_2960)ModGuiIcons.ICON_LOCATION, graphics, (boolean)false, (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 3 - 8), (float)4.0f, (float)0.0f, (float)8.0f, (float)8.0f, (float)(uv * (float)ModGuiIcons.ARROW_RIGHT.getU()), (float)(uv * (float)ModGuiIcons.ARROW_RIGHT.getV()), (float)(uv * (float)(ModGuiIcons.ARROW_RIGHT.getU() + 16)), (float)(uv * (float)(ModGuiIcons.ARROW_RIGHT.getV() + 16)), (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationScrollingTextSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor()), (int)light);
                break;
            }
            case LEFT: {
                BERUtils.renderTexture((class_2960)ModGuiIcons.ICON_LOCATION, graphics, (boolean)false, (float)3.0f, (float)4.0f, (float)0.0f, (float)8.0f, (float)8.0f, (float)(uv * (float)ModGuiIcons.ARROW_LEFT.getU()), (float)(uv * (float)ModGuiIcons.ARROW_LEFT.getV()), (float)(uv * (float)(ModGuiIcons.ARROW_LEFT.getU() + 16)), (float)(uv * (float)(ModGuiIcons.ARROW_LEFT.getV() + 16)), (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationScrollingTextSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor()), (int)light);
                break;
            }
        }
        graphics.poseStack().method_22903();
        switch (side) {
            case LEFT: {
                graphics.poseStack().method_46416(10.0f, 0.0f, 0.0f);
                break;
            }
        }
        this.label.render(graphics, light);
        graphics.poseStack().method_22909();
    }

    @Override
    public void update(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason data) {
        if (blockEntity.getTrainData() == null || blockEntity.getTrainData().getState().isOutOfService()) {
            return;
        }
        PassengerInformationScrollingTextSettings settings = (PassengerInformationScrollingTextSettings)this.getDisplaySettings(blockEntity);
        TrainExitSide trainExitSide = settings.showExit() ? (blockEntity.getTrainData().isWaitingAtStation() ? this.exitSide : (TrainExitSide)((Object)blockEntity.relativeExitDirection.get())) : (this.exitSide = TrainExitSide.UNKNOWN);
        if (blockEntity.getTrainData().getState() == TrainDisplayData.State.AT_TERMINUS) {
            this.label.setText((class_2561)this.textTrainTerminated);
        } else if (!blockEntity.getTrainData().getNextStop().isPresent()) {
            this.label.setText((class_2561)(settings.getTrainTextComponents().showTrainName() ? TextUtils.text((String)blockEntity.getTrainData().getTrainData().getName()) : TextUtils.empty()));
        } else if (blockEntity.getTrainData().isWaitingAtStation()) {
            this.label.setText((class_2561)TextUtils.text((String)blockEntity.getTrainData().getNextStop().get().getRealTimeStation().tagName()));
        } else if (blockEntity.getTrainData().getNextStop().get().getRealTimeArrivalTime() - DragonLib.getCurrentWorldTime() < (long)((Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()).intValue()) {
            class_5250 txt = CustomLanguage.translate(keyNextStop, blockEntity.getTrainData().getNextStop().get().getRealTimeStation().tagName());
            if (blockEntity.getTrainData().getState().isTerminating(((PassengerInformationScrollingTextSettings)this.getDisplaySettings(blockEntity)).showDoNotBoardText())) {
                txt = TextUtils.concatWithStarChars((class_2561[])new class_2561[]{txt, this.textTrainTerminatesHere});
            }
            this.label.setText((class_2561)txt);
        } else {
            int slides = 3;
            int slide = (int)(DragonLib.getCurrentWorldTime() % 300L) / 100;
            if (slide == 1 && !settings.showTimeAndDate()) {
                ++slide;
            }
            if (slide == 2 && !settings.showStats()) {
                ++slide;
            }
            switch (slide %= 3) {
                case 0: {
                    this.label.setText((class_2561)TextUtils.text((String)((String)(settings.getTrainTextComponents().showTrainName() ? blockEntity.getTrainData().getTrainData().getName() + " " : "") + (settings.getTrainTextComponents().showDestination() && blockEntity.getTrainData().getCurrentStop().isPresent() ? blockEntity.getTrainData().getCurrentStop().get().getDestination() : ""))));
                    break;
                }
                case 1: {
                    this.label.setText((class_2561)CustomLanguage.translate(keyDate, blockEntity.method_10997().method_8532() / 24000L, ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false)));
                    break;
                }
                case 2: {
                    this.label.setText((class_2561)ModUtils.calcSpeedString(blockEntity.getTrainData().getSpeed(), (ESpeedUnit)((Object)ModClientConfig.SPEED_UNIT.get())));
                }
            }
            this.exitSide = TrainExitSide.UNKNOWN;
        }
        this.label.setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6 - (this.exitSide == TrainExitSide.UNKNOWN ? 0 : 10)), BERLabel.BoundsHitReaction.SCROLL).setColor(0xFF000000 | ((PassengerInformationScrollingTextSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
    }
}

