/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PlatformDisplayFocusSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5250;

public class BERPlatformInformative
implements AbstractAdvancedDisplayRenderer<PlatformDisplayFocusSettings> {
    private static final String keyFollowingTrains = "gui.createrailwaysnavigator.following_trains";
    private final class_5250 textTrainTerminatesHere = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final float LINE_HEIGHT = 5.4f;
    private int maxLines = 0;
    private boolean showInfoLine = false;
    private class_2561 infoLineText = TextUtils.empty();
    private BERLabel statusLabel;
    private final BERLabel platformLabel = new BERLabel().setYScale(0.8f).setScale(0.6f, 0.5f);
    private BERLabel[] focusArea;
    private BERLabel[][] lines;
    private final BERLabel followingTrainsLabel = new BERLabel((class_2561)CustomLanguage.translate("gui.createrailwaysnavigator.following_trains")).setPos(3.0f, 16.0f).setScale(0.2f, 0.2f).setYScale(0.2f);

    @Override
    public void renderTick(float deltaTime) {
        DLUtils.doIfNotNull((Object)this.statusLabel, x -> x.renderTick());
        DLUtils.doIfNotNull((Object)this.platformLabel, x -> x.renderTick());
        DLUtils.doIfNotNull((Object)this.focusArea, x -> {
            for (int i = 0; i < ((BERLabel[])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], y -> y.renderTick());
            }
        });
        DLUtils.doIfNotNull((Object)this.lines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], y -> {
                    for (int j = 0; j < ((BERLabel[])y).length; ++j) {
                        DLUtils.doIfNotNull((Object)y[j], z -> z.renderTick());
                    }
                });
            }
        });
    }

    private boolean isExtendedDisplay(AdvancedDisplayBlockEntity blockEntity) {
        return blockEntity.getYSize() > 1;
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (this.isExtendedDisplay((AdvancedDisplayBlockEntity)graphics.blockEntity())) {
            BERUtils.fillColor(graphics, (float)2.5f, (float)15.5f, (float)0.0f, (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 5), (float)0.25f, (int)(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)light);
            this.followingTrainsLabel.setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF);
            this.followingTrainsLabel.render(graphics, light);
        }
        DLUtils.doIfNotNull((Object)this.focusArea, a -> {
            for (int i = 0; i < ((BERLabel[])a).length; ++i) {
                BERLabel label = a[i];
                if (label == null) continue;
                graphics.poseStack().method_22903();
                if (backSide) {
                    float maxWidth = ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16;
                    if (i == LineComponent.TIME.i()) {
                        graphics.poseStack().method_46416(-label.getX() + maxWidth - 3.0f - label.getTextWidth(), 0.0f, 0.0f);
                    } else if (i == LineComponent.REAL_TIME.i()) {
                        graphics.poseStack().method_46416(-label.getX() + maxWidth - 3.0f - label.getTextWidth(), 0.0f, 0.0f);
                    } else if (i == LineComponent.TRAIN_NAME.i()) {
                        graphics.poseStack().method_46416(-label.getX() + maxWidth - 3.0f - label.getTextWidth(), 0.0f, 0.0f);
                    } else if (i == LineComponent.DESTINATION.i()) {
                        graphics.poseStack().method_46416(-label.getX() + 5.0f + this.platformLabel.getMaxWidth(), 0.0f, 0.0f);
                    } else if (i == LineComponent.STOPOVERS.i()) {
                        graphics.poseStack().method_46416(-label.getX() + 5.0f + this.platformLabel.getMaxWidth(), 0.0f, 0.0f);
                    } else if (i == LineComponent.PLATFORM.i()) {
                        graphics.poseStack().method_46416(-label.getX() + 3.0f, 0.0f, 0.0f);
                    }
                }
                label.render((RenderGraphics)graphics, light);
                graphics.poseStack().method_22909();
            }
        });
        DLUtils.doIfNotNull((Object)this.lines, x -> {
            for (BERLabel[] line : x) {
                if (line == null) continue;
                for (BERLabel label : line) {
                    if (label == null) continue;
                    label.render((RenderGraphics)graphics, light);
                }
            }
        });
        graphics.poseStack().method_22903();
        if (this.statusLabel != null && !this.statusLabel.getText().getString().isBlank()) {
            graphics.poseStack().method_22903();
            if (backSide) {
                graphics.poseStack().method_46416(-this.statusLabel.getX() + 5.0f + this.platformLabel.getMaxWidth(), 0.0f, 0.0f);
            }
            DLUtils.doIfNotNull((Object)this.statusLabel, x -> x.render((RenderGraphics)graphics, light));
            graphics.poseStack().method_22909();
        }
        if (backSide && this.platformLabel != null) {
            graphics.poseStack().method_46416((float)(-((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 + 6) + this.platformLabel.getTextWidth(), 0.0f, 0.0f);
        }
        this.platformLabel.render(graphics, light);
        graphics.poseStack().method_22909();
    }

    @Override
    public void update(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        List<StationDisplayData> preds = blockEntity.getStops().stream().filter(x -> !x.getTrainData().isCancelled() || DragonLib.getCurrentWorldTime() < x.getStationData().getScheduledDepartureTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue()).toList();
        if (preds.isEmpty()) {
            this.lines = null;
            this.focusArea = null;
            this.statusLabel = null;
            float platformWidth = Math.min((float)(blockEntity.getXSizeScaled() * 16 - 8), ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).isAutoPlatformWidthNextStop() ? this.platformLabel.getTextWidth() : (float)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getPlatformWidthNextStop());
            this.platformLabel.setText((class_2561)TextUtils.text((String)(blockEntity.isPlatformFixed() && blockEntity.getStationInfo() != null ? blockEntity.getStationInfo().platform() : "")).method_27692(class_124.field_1067)).setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - Math.min(platformWidth, this.platformLabel.getTextWidth()), 3.0f).setMaxWidth(platformWidth, BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
            return;
        }
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || this.lines == null || this.focusArea == null) {
            this.updateLayout(blockEntity, preds);
        }
        boolean bl = this.showInfoLine = preds.get(0).getStationData().isDepartureDelayed() && preds.get(0).getTrainData().hasStatusInfo() || preds.get(0).getStationData().isStationChanged() || preds.get(0).isNextSectionExcluded();
        if (this.showInfoLine) {
            ArrayList<Object> content = new ArrayList<Object>();
            if (preds.get(0).getTrainData().isCancelled()) {
                content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.cancelled"));
            } else {
                String delay;
                TrainStopDisplayData displayData = preds.get(0).getStationData();
                String string = delay = ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA ? ModUtils.timeRemainingString(displayData.getDepartureTimeDeviation()) : String.valueOf(TimeUtils.formatToMinutes((long)displayData.getDepartureTimeDeviation()));
                if (preds.get(0).isNextSectionExcluded()) {
                    content.add(this.textTrainTerminatesHere);
                }
                if (displayData.isDepartureDelayed()) {
                    class_5250 delayComponent = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delayed", delay);
                    if (((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ABS) {
                        delayComponent.method_27693(" ").method_10852((class_2561)CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delay_abs_suffix"));
                    }
                    content.add(delayComponent);
                }
                if (displayData.isStationChanged() && !blockEntity.isAllowedOnDisplay(displayData.getRealTimeStation())) {
                    if (!displayData.getScheduledStation().tagId().equals(displayData.getRealTimeStation().tagId())) {
                        content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_and_station_changed", displayData.getRealTimeStation().tagName(), displayData.getRealTimeStation().info().platform()));
                    } else {
                        content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_changed", displayData.getRealTimeStation().info().platform()));
                    }
                }
                for (TrainStatus.CompiledTrainStatus status : preds.get(0).getTrainData().getStatus()) {
                    content.add(status.text());
                }
            }
            this.infoLineText = TextUtils.concat((class_2561)TextUtils.text((String)"  +++  "), content);
        } else {
            this.infoLineText = TextUtils.empty();
        }
        this.updateFocusContent(blockEntity, preds.get(0));
        for (int i = 1; i < this.lines.length && i < preds.size(); ++i) {
            StationDisplayData stop = preds.get(i);
            this.updateTableContent(blockEntity, stop, i);
        }
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, List<StationDisplayData> preds) {
        BERLabel stopoversLabel;
        BERLabel destinationLabel;
        BERLabel trainNameLabel;
        BERLabel realTimeLabel;
        BERLabel timeLabel;
        this.focusArea = new BERLabel[7];
        this.lines = new BERLabel[0][];
        this.followingTrainsLabel.setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.focusArea[LineComponent.TIME.i()] = timeLabel = new BERLabel().setPos(3.0f, 3.0f).setYScale(0.4f).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.focusArea[LineComponent.REAL_TIME.i()] = realTimeLabel = new BERLabel().setPos(3.0f, 7.0f).setYScale(0.4f).setScale(0.4f, 0.2f).setBackground(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, false).setColor(-15658735);
        this.focusArea[LineComponent.TRAIN_NAME.i()] = trainNameLabel = new BERLabel().setPos(3.0f, 7.0f).setYScale(0.3f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.IGNORE).setScale(0.3f, 0.15f).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.platformLabel.setYScale(0.8f).setScale(0.6f, 0.5f).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.focusArea[LineComponent.DESTINATION.i()] = destinationLabel = new BERLabel().setYScale(0.6f).setScale(0.6f, 0.4f).setScrollingSpeed(2.0f).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.focusArea[LineComponent.STOPOVERS.i()] = stopoversLabel = new BERLabel().setYScale(0.2f).setScale(0.2f, 0.1f).setScrollingSpeed(2.0f).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.statusLabel = new BERLabel().setText(this.infoLineText).setYScale(0.3f).setScale(0.3f, 0.3f).setScrollingSpeed(2.0f).setBackground(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, true).setColor(-15658735);
        if (this.isExtendedDisplay(blockEntity)) {
            this.maxLines = (blockEntity.getYSizeScaled() - 1) * 3;
            int maxIndices = Math.min(this.maxLines, preds.size());
            this.lines = new BERLabel[Math.max(maxIndices, 0)][];
            for (int i = 1; i < this.lines.length; ++i) {
                StationDisplayData stop = preds.get(i);
                this.lines[i] = this.createTableLine(blockEntity, stop, i);
            }
        }
    }

    private BERLabel[] createTableLine(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        BERLabel[] components = new BERLabel[5];
        components[LineComponent.TIME.i()] = new BERLabel().setYScale(0.4f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        components[LineComponent.REAL_TIME.i()] = new BERLabel().setYScale(0.4f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setBackground(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, false).setColor(-15658735);
        components[LineComponent.TRAIN_NAME.i()] = new BERLabel().setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        components[LineComponent.PLATFORM.i()] = new BERLabel().setYScale(0.4f).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        components[LineComponent.DESTINATION.i()] = new BERLabel().setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        return components;
    }

    private void updateFocusContent(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop) {
        PlatformDisplayFocusSettings settings = (PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity);
        boolean isLast = settings.showArrival() && stop.shouldShowArrivalOfTrain() || stop.isNextSectionExcluded();
        this.followingTrainsLabel.setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        BERLabel timeLabel = this.focusArea[LineComponent.TIME.i()].setText((class_2561)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
        BERLabel realTimeLabel = this.focusArea[LineComponent.REAL_TIME.i()].setText((class_2561)TextUtils.text((String)(stop.isDelayed() ? ModUtils.formatTime(stop.getRealTime(), ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA) : ""))).setColor(ColorUtils.brightnessDependingFontColor((int)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (int)-1118482, (int)-15658735));
        byte trainNameWidth = settings.getTrainNameWidthNextStop();
        BERLabel trainNameLabel = this.focusArea[LineComponent.TRAIN_NAME.i()];
        trainNameLabel.setText((class_2561)TextUtils.text((String)stop.getTrainData().getName())).setPos(3.0f, 7.0f + (stop.isDelayed() ? 4.5f : 0.0f)).setMaxWidth(settings.isAutoTrainNameWidthNextStop() ? trainNameLabel.getTextWidth() : (float)trainNameWidth, BERLabel.BoundsHitReaction.SCALE_SCROLL).setBackground(settings.showLineColor() && stop.getTrainData().hasColor() ? 0xFF000000 | stop.getTrainData().getColor() & 0xFFFFFF : 0, false);
        if (settings.showLineColor() && stop.getTrainData().hasColor()) {
            trainNameLabel.setBackground(0xFF000000 | stop.getTrainData().getColor() & 0xFFFFFF, false).setColor(ColorUtils.brightnessDependingFontColor((int)stop.getTrainData().getColor(), (int)-1118482, (int)-15658735));
        } else {
            trainNameLabel.setBackground(0, false).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        }
        this.platformLabel.setText((class_2561)TextUtils.text((String)(blockEntity.isPlatformFixed() ? blockEntity.getStationInfo().platform() : stop.getStationData().getRealTimeStation().info().platform())).method_27692(class_124.field_1067));
        float x = 5.0f + Math.max(trainNameLabel.getMaxWidth(), Math.max(timeLabel.getTextWidth(), realTimeLabel.getTextWidth()));
        float platformWidth = Math.min((float)(blockEntity.getXSizeScaled() * 16 - 3) - x, settings.isAutoPlatformWidthNextStop() ? this.platformLabel.getTextWidth() : (float)settings.getPlatformWidthNextStop());
        this.platformLabel.setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - Math.min(platformWidth, this.platformLabel.getTextWidth()), 3.0f).setMaxWidth(platformWidth, BERLabel.BoundsHitReaction.SCALE_SCROLL);
        float w = (float)(blockEntity.getXSizeScaled() * 16 - 5) - platformWidth - x;
        this.focusArea[LineComponent.DESTINATION.i()].setText((class_2561)(isLast ? CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.arrival") : TextUtils.text((String)stop.getStationData().getDestination()))).setPos(x, 8.5f).setMaxWidth(w, BERLabel.BoundsHitReaction.SCALE_SCROLL);
        this.focusArea[LineComponent.STOPOVERS.i()].setText((class_2561)(isLast ? CustomLanguage.translate("gui.createrailwaysnavigator.schedule_board.train_from", stop.getFirstStopName()) : TextUtils.concat((class_2561)TextUtils.text((String)" \u25cf "), stop.getStopovers().stream().map(a -> TextUtils.text((String)a)).toList()))).setPos(x, 6.0f).setMaxWidth(w, BERLabel.BoundsHitReaction.SCALE_SCROLL);
        this.statusLabel.setText(this.infoLineText).setPos(x, 2.5f).setMaxWidth(w, BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(ColorUtils.brightnessDependingFontColor((int)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (int)-1118482, (int)-15658735));
    }

    private void updateTableContent(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        PlatformDisplayFocusSettings settings = (PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity);
        boolean isLast = settings.showArrival() && stop.shouldShowArrivalOfTrain() || stop.isNextSectionExcluded();
        BERLabel[] components = this.lines[index];
        components[LineComponent.TIME.i()].setText((class_2561)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
        components[LineComponent.REAL_TIME.i()].setText((class_2561)TextUtils.text((String)(stop.getTrainData().isCancelled() ? " \u274c " : (stop.getStationData().isDepartureDelayed() ? ModUtils.formatTime(isLast ? stop.getStationData().getRealTimeArrivalTime() : stop.getStationData().getRealTimeDepartureTime(), ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA) : "")))).setColor(ColorUtils.brightnessDependingFontColor((int)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (int)-1118482, (int)-15658735));
        BERLabel trainNameLabel = components[LineComponent.TRAIN_NAME.i()].setText((class_2561)TextUtils.text((String)stop.getTrainData().getName())).setBackground(settings.showLineColor() && stop.getTrainData().hasColor() ? 0xFF000000 | stop.getTrainData().getColor() & 0xFFFFFF : 0, false);
        if (settings.showLineColor() && stop.getTrainData().hasColor()) {
            trainNameLabel.setBackground(0xFF000000 | stop.getTrainData().getColor() & 0xFFFFFF, false).setColor(ColorUtils.brightnessDependingFontColor((int)stop.getTrainData().getColor(), (int)-1118482, (int)-15658735));
        } else {
            trainNameLabel.setBackground(0, false).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        }
        components[LineComponent.PLATFORM.i()].setText((class_2561)(blockEntity.isPlatformFixed() ? TextUtils.empty() : TextUtils.text((String)stop.getStationData().getRealTimeStation().info().platform())));
        components[LineComponent.DESTINATION.i()].setText((class_2561)(isLast ? CustomLanguage.translate("gui.createrailwaysnavigator.schedule_board.train_from", stop.getFirstStopName()) : TextUtils.text((String)stop.getStationData().getDestination())));
        int x = 3;
        components[LineComponent.TIME.i()].setPos((float)x, 14.0f + (float)index * 5.4f);
        x = (int)((float)x + (components[LineComponent.TIME.i()].getTextWidth() + 2.0f));
        components[LineComponent.REAL_TIME.i()].setPos((float)x, 14.0f + (float)index * 5.4f);
        x = (int)((float)x + (components[LineComponent.REAL_TIME.i()].getTextWidth() + 2.0f + (float)(!components[LineComponent.REAL_TIME.i()].getText().getString().isEmpty() ? 2 : 0)));
        float trainNameWidth = settings.isAutoTrainNameWidth() ? trainNameLabel.getTextWidth() : (float)settings.getTrainNameWidth();
        trainNameLabel.setPos((float)x, 14.0f + (float)index * 5.4f).setMaxWidth(trainNameWidth, BERLabel.BoundsHitReaction.SCALE_SCROLL);
        x = (int)((float)x + (trainNameLabel.getMaxWidth() + 2.0f));
        BERLabel platformLabel = components[LineComponent.PLATFORM.i()];
        float platformWidth = settings.isAutoPlatformWidth() ? platformLabel.getTextWidth() : (float)settings.getPlatformWidth();
        platformLabel.setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - platformLabel.getTextWidth(), 14.0f + (float)index * 5.4f).setMaxWidth(platformWidth, BERLabel.BoundsHitReaction.SCALE_SCROLL);
        if (stop.getStationData().isStationChanged()) {
            platformLabel.setBackground(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, false).setColor(-15658735);
        } else {
            platformLabel.setBackground(0, false).setColor(0xFF000000 | ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        }
        components[LineComponent.DESTINATION.i()].setPos((float)x, 14.0f + (float)index * 5.4f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 3 - x) - platformWidth - 3.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL);
    }

    private static enum LineComponent {
        TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4),
        STOPOVERS(5);

        int index;

        private LineComponent(int index) {
            this.index = index;
        }

        public int i() {
            return this.index;
        }
    }
}

