/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay.pages;

import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5348;

public class NextConnectionsPage
extends AbstractRouteDetailsPage {
    private final List<TrainStop> nextConnections = new ArrayList<TrainStop>();
    private static final String keyNextConnections = "gui.createrailwaysnavigator.route_overview.next_connections";
    private static final int CONNECTION_ENTRIES_PER_PAGE = 3;
    private static final int TIME_PER_CONNECTIONS_SUBPAGE = 200;
    private int connectionsSubPageTime = 0;
    private int connectionsSubPageIndex = 0;
    private int connectionsSubPagesCount = 0;
    private final Runnable afterFirstCycle;
    private int cycles;

    public NextConnectionsPage(ClientRoute route, Runnable afterFirstCycle) {
        super(route);
        this.afterFirstCycle = afterFirstCycle;
        DataAccessor.getFromServer((Object)new ModAccessorTypes.DeparturesData(route.getCurrentPart().getNextStop().getRealTimeStationTag().tagId(), route.getCurrentPart().getNextStop().getTrainId(), true), ModAccessorTypes.GET_DEPARTURES_AT, stops -> {
            if (stops.isEmpty()) {
                afterFirstCycle.run();
                return;
            }
            this.nextConnections.addAll((Collection<TrainStop>)stops);
            this.connectionsSubPagesCount = this.nextConnections.size() / 3 + (this.nextConnections.size() % 3 == 0 ? 0 : 1);
        });
    }

    @Override
    public boolean isImportant() {
        return false;
    }

    public boolean hasConnections() {
        return !this.nextConnections.isEmpty();
    }

    public void method_1865() {
        super.method_1865();
        if (this.nextConnections.isEmpty()) {
            return;
        }
        ++this.connectionsSubPageTime;
        if ((this.connectionsSubPageTime %= 200) == 0) {
            ++this.connectionsSubPageIndex;
            if ((this.connectionsSubPageIndex %= this.connectionsSubPagesCount) == 0) {
                ++this.cycles;
                if (this.cycles == 1) {
                    DLUtils.doIfNotNull((Object)this.afterFirstCycle, x -> x.run());
                }
            }
        }
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)5, (int)4, (class_5348)CustomLanguage.translate(keyNextConnections).method_27692(class_124.field_1067), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        int y = 16;
        int spacing = 5;
        int timeWidth = 30;
        int trainNameWidth = 40;
        for (int i = this.connectionsSubPageIndex * 3; i < (this.connectionsSubPageIndex + 1) * 3 && i < this.nextConnections.size(); ++i) {
            TrainStop stop = this.nextConnections.get(i);
            String terminus = stop.getDisplayTitle();
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)5, (int)y, (String)TimeUtils.parseTime((long)stop.getScheduledDepartureTime(), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)40, (int)y, (class_5348)GuiUtils.ellipsisString((class_327)this.font, (class_2561)TextUtils.text((String)stop.getTrainName()), (int)40), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(this.width() - 5), (int)y, (String)stop.getRealTimeStationTag().info().platform(), (int)-2368549, (EAlignment)EAlignment.RIGHT, (boolean)false);
            int terminusWidth = this.width() - 10 + 30 + 40 + 15 - this.font.method_1727(stop.getRealTimeStationTag().info().platform());
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)85, (int)y, (class_5348)GuiUtils.ellipsisString((class_327)this.font, (class_2561)TextUtils.text((String)terminus), (int)terminusWidth), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            y += 12;
        }
        y = 52;
        int dotSize = 4;
        int center = this.width() / 2 - 2;
        int startX = center - 8 * (this.connectionsSubPagesCount - 1);
        for (int i = 0; i < this.connectionsSubPagesCount; ++i) {
            if (this.connectionsSubPageIndex == i) {
                GuiUtils.drawBox((Graphics)graphics, (GuiAreaDefinition)new GuiAreaDefinition(startX + 8 * i - 1, y - 1, 6, 6), (int)-5592406, (int)-1);
                continue;
            }
            GuiUtils.drawBox((Graphics)graphics, (GuiAreaDefinition)new GuiAreaDefinition(startX + 8 * i, y, 4, 4), (int)-7829368, (int)-2368549);
        }
    }
}

