/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class CRNListBox<T, W extends class_364 & class_4068>
extends DLScrollableWidgetContainer {
    private final class_437 parent;
    private final DLAbstractScrollBar<?> scrollBar;
    private int contentHeight = 0;
    private final Map<W, T> values = new HashMap<W, T>();

    public CRNListBox(class_437 parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar) {
        super(x, y, width, height);
        this.parent = parent;
        this.scrollBar = scrollBar;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.setMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }

    public class_437 getParent() {
        return this.parent;
    }

    public void displayData(List<T> data, BiFunction<T, Integer, W> createItem) {
        this.clearWidgets();
        this.values.clear();
        this.contentHeight = 0;
        for (int i = 0; i < data.size(); ++i) {
            T entry = data.get(i);
            class_364 widget = (class_364)createItem.apply(entry, i);
            if (widget == null) continue;
            ((IDragonLibWidget)widget).set_x(this.x());
            ((IDragonLibWidget)widget).set_width(this.width());
            ((IDragonLibWidget)widget).set_y(this.y() + this.contentHeight);
            this.addRenderableWidget(widget);
            this.values.put(widget, entry);
            this.contentHeight += ((IDragonLibWidget)widget).height();
        }
        this.scrollBar.setMaxScroll(this.contentHeight);
    }

    public Set<Map.Entry<W, T>> getEntries() {
        return this.values.entrySet();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollBar.getScrollValue() > 0.0) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        }
        if (this.scrollBar.getScrollValue() < (double)this.scrollBar.getMaxScroll()) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
        }
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }
}

