/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class DLNewListBox<T, W extends Entry<T, W>>
extends DLScrollableWidgetContainer {
    private final class_437 parent;
    private final DLAbstractScrollBar<?> scrollBar;
    private int contentHeight = 0;
    private final Map<W, T> values = new HashMap<W, T>();
    private final List<W> entryWidgets = new ArrayList<W>();
    private List<T> currentData = null;
    private EntryBuilderContext<T, W> itemBuilderContext;
    private W draggedEntry;
    private double relMousePosY;
    private int dropIndex = 0;
    private int markerYPos;

    public DLNewListBox(class_437 parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar) {
        super(x, y, width, height);
        this.parent = parent;
        this.scrollBar = scrollBar;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.setMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }

    public class_437 getParent() {
        return this.parent;
    }

    public void displayData(List<T> data, EntryBuilderContext<T, W> createItem) {
        this.clearWidgets();
        this.values.clear();
        this.entryWidgets.clear();
        this.currentData = data;
        this.itemBuilderContext = createItem;
        this.contentHeight = 0;
        for (int i = 0; i < data.size(); ++i) {
            T entry = data.get(i);
            W widget = createItem.build(this, i, entry);
            if (widget == null) continue;
            widget.set_x(this.x());
            widget.set_width(this.width());
            widget.set_y(this.y() + this.contentHeight);
            this.entryWidgets.add((W)((Object)((Entry)this.addRenderableWidget((class_364)widget))));
            this.values.put(widget, entry);
            this.contentHeight += widget.height();
        }
        this.scrollBar.setMaxScroll(this.contentHeight);
    }

    public Set<Map.Entry<W, T>> getEntries() {
        return this.values.entrySet();
    }

    public void updateDropIndex(double mouseY) {
        if (this.draggedEntry == null) {
            return;
        }
        this.relMousePosY = (int)(mouseY - (double)this.y() + this.scrollBar.getScrollValue());
        int cumulative = 0;
        int nonDraggedIndex = 0;
        for (Entry widget : this.entryWidgets) {
            if (widget == this.draggedEntry) continue;
            int widgetHeight = widget.height();
            int widgetBottom = cumulative + widgetHeight;
            if (this.relMousePosY < (double)widgetBottom) {
                this.dropIndex = nonDraggedIndex;
                return;
            }
            cumulative = widgetBottom;
            ++nonDraggedIndex;
        }
        this.dropIndex = nonDraggedIndex;
    }

    public void layoutEntries() {
        int currentY = this.y();
        int nonDraggedIndex = 0;
        for (Entry widget : this.entryWidgets) {
            if (widget == this.draggedEntry) continue;
            if (nonDraggedIndex == this.dropIndex && this.draggedEntry != null) {
                this.markerYPos = currentY;
                currentY += this.draggedEntry.height();
            }
            widget.set_y(currentY);
            currentY += widget.height();
            ++nonDraggedIndex;
        }
        if (nonDraggedIndex == this.dropIndex && this.draggedEntry != null) {
            this.markerYPos = currentY;
            currentY += this.draggedEntry.height();
        }
        this.contentHeight = currentY - this.y();
    }

    public void finalizeDrag() {
        if (this.draggedEntry != null && this.currentData != null) {
            int newIndex;
            int oldIndex = this.entryWidgets.indexOf(this.draggedEntry);
            int n = newIndex = this.dropIndex >= 0 ? this.dropIndex : oldIndex;
            if (oldIndex >= 0 && newIndex >= 0 && oldIndex < this.entryWidgets.size() && newIndex < this.entryWidgets.size()) {
                T element = this.currentData.remove(oldIndex);
                this.currentData.add(newIndex, element);
            }
            ((Entry)((Object)this.draggedEntry)).resetDrag();
            this.draggedEntry = null;
            this.dropIndex = -1;
            this.displayData(this.currentData, this.itemBuilderContext);
        }
    }

    protected void autoScroll() {
        int margin = 16;
        double speedFac = 0.25;
        double mousePos = this.relMousePosY - this.scrollBar.getScrollValue();
        if (mousePos < 16.0) {
            this.scrollBar.setScrollValue(this.scrollBar.getScrollValue() - 0.25 * -(mousePos - 16.0));
        } else if (mousePos > (double)(this.height() - 16)) {
            this.scrollBar.setScrollValue(this.scrollBar.getScrollValue() + 0.25 * (mousePos - (double)(this.height() - 16)));
        }
    }

    public void setDraggedEntry(W entry) {
        if (this.draggedEntry == null) {
            this.draggedEntry = entry;
        }
    }

    public void method_1865() {
        if (this.draggedEntry != null && !this.parent.method_25397()) {
            this.finalizeDrag();
        }
        if (this.draggedEntry != null) {
            this.autoScroll();
            this.layoutEntries();
        }
        super.method_1865();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.draggedEntry != null) {
            this.updateDropIndex(mouseY);
            this.layoutEntries();
        }
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollBar.getScrollValue() > 0.0) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        }
        if (this.scrollBar.getScrollValue() < (double)this.scrollBar.getMaxScroll()) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
        }
        GuiUtils.enableScissor((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.width(), (int)this.height());
        if (this.draggedEntry != null) {
            graphics.poseStack().method_22903();
            graphics.poseStack().method_22904(0.0, -this.scrollBar.getScrollValue(), 0.0);
            GuiUtils.drawBox((Graphics)graphics, (GuiAreaDefinition)new GuiAreaDefinition(this.x(), this.markerYPos, this.width(), this.draggedEntry.height()), (int)DLNewListBox.getPulsatingColor(class_310.method_1551().field_1687.method_8510(), 0.1, 0x44FFFFFF, (byte)0, (byte)85), (int)-1);
            graphics.poseStack().method_22909();
        }
        GuiUtils.disableScissor((Graphics)graphics);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.draggedEntry != null) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            graphics.poseStack().method_22903();
            graphics.poseStack().method_46416((float)(-this.x() + (mouseX - ((Entry)((Object)this.draggedEntry)).grabOffsetX)), (float)(-(this.y() + (this.draggedEntry.y() - this.y())) + (mouseY - ((Entry)((Object)this.draggedEntry)).grabOffsetY)), 100.0f);
            CreateDynamicWidgets.renderShadow(graphics, -2 + this.draggedEntry.x(), -2 + this.draggedEntry.y(), this.draggedEntry.width() + 4, this.draggedEntry.height() + 4);
            CreateDynamicWidgets.renderSingleShadeWidget(graphics, -2 + this.draggedEntry.x(), -2 + this.draggedEntry.y(), this.draggedEntry.width() + 4, this.draggedEntry.height() + 4, CreateDynamicWidgets.ColorShade.DARK);
            ((Entry)((Object)this.draggedEntry)).renderItem(graphics, mouseX, mouseY, partialTicks);
            graphics.poseStack().method_22909();
        }
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    public static int getPulsatingColor(double time, double speed, int color, byte alphaMin, byte alphaMax) {
        int aMin = alphaMin & 0xFF;
        int aMax = alphaMax & 0xFF;
        if (aMin > aMax) {
            int temp = aMin;
            aMin = aMax;
            aMax = temp;
        }
        int alphaRange = aMax - aMin;
        double sineValue = Math.sin(time * speed);
        double normalized = (sineValue + 1.0) / 2.0;
        int alpha = aMin + (int)(normalized * (double)alphaRange);
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static interface EntryBuilderContext<S, T extends Entry<S, T>> {
        public T build(DLNewListBox<S, T> var1, int var2, S var3);
    }

    public static abstract class Entry<S, T extends Entry<S, T>>
    extends DLWidgetContainer {
        private final DLNewListBox<S, T> list;
        private final S data;
        private int index;
        private double initialMouseX;
        private double initialMouseY;
        private double dragOffsetX;
        private double dragOffsetY;
        private boolean isDragging = false;
        int grabOffsetX;
        int grabOffsetY;

        protected Entry(DLNewListBox<S, T> list, int index, S data, int height) {
            super(0, 0, 0, height);
            this.list = list;
            this.data = data;
            this.index = index;
        }

        public final S getData() {
            return this.data;
        }

        public final int getIndex() {
            return this.index;
        }

        public final DLNewListBox<S, T> getList() {
            return this.list;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.initialMouseY = mouseY;
            this.initialMouseX = mouseX;
            this.grabOffsetX = (int)(mouseX - (double)this.x());
            this.grabOffsetY = (int)(mouseY - (double)this.y());
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (!this.isDragging && (Math.abs(this.dragOffsetX) > 5.0 || Math.abs(this.dragOffsetY) > 5.0)) {
                this.isDragging = true;
                this.list.setDraggedEntry((T)((Object)this));
            } else if (!this.isDragging) {
                this.dragOffsetX = mouseX - this.initialMouseX;
                this.dragOffsetY = mouseY - this.initialMouseY;
            }
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            this.isDragging = false;
            this.resetDrag();
            return super.method_25406(mouseX, mouseY, button);
        }

        public final void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (this.isDragging) {
                return;
            }
            this.renderItem(graphics, mouseX, mouseY, partialTicks);
        }

        public void renderItem(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        }

        public void resetDrag() {
            this.isDragging = false;
            this.dragOffsetX = 0.0;
            this.dragOffsetY = 0.0;
        }

        public void method_1865() {
            if (!this.list.parent.method_25397()) {
                this.resetDrag();
            }
            super.method_1865();
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 narrationElementOutput) {
        }

        public boolean consumeScrolling(double mouseX, double mouseY) {
            return false;
        }
    }
}

