/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_768;

public class ModCommandSuggestions {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final class_2583 UNPARSED_STYLE = class_2583.field_24360.method_10977(class_124.field_1061);
    private static final class_2583 LITERAL_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
    private static final List<class_2583> ARGUMENT_STYLES = (List)Stream.of(class_124.field_1075, class_124.field_1054, class_124.field_1060, class_124.field_1076, class_124.field_1065).map(arg_0 -> ((class_2583)class_2583.field_24360).method_10977(arg_0)).collect(ImmutableList.toImmutableList());
    final class_310 minecraft;
    final class_437 screen;
    protected final class_342 input;
    final class_327 font;
    private final boolean commandsOnly;
    private final boolean onlyShowIfCursorPastError;
    final int lineStartOffset;
    final int suggestionLineLimit;
    final boolean anchorToBottom;
    final int fillColor;
    private final List<class_5481> commandUsage = Lists.newArrayList();
    private int commandUsagePosition;
    private int commandUsageWidth;
    @Nullable
    private ParseResults<class_2172> currentParse;
    @Nullable
    private CompletableFuture<Suggestions> pendingSuggestions;
    @Nullable
    protected SuggestionsList suggestions;
    boolean keepSuggestions;

    public ModCommandSuggestions(class_310 pMinecraft, class_437 pScreen, class_342 pInput, class_327 pFont, boolean pCommandsOnly, boolean pOnlyShowIfCursorPastError, int pLineStartOffset, int pSuggestionLineLimit, boolean pAnchorToBottom, int pFillColor) {
        this.minecraft = pMinecraft;
        this.screen = pScreen;
        this.input = pInput;
        this.font = pFont;
        this.commandsOnly = pCommandsOnly;
        this.onlyShowIfCursorPastError = pOnlyShowIfCursorPastError;
        this.lineStartOffset = pLineStartOffset;
        this.suggestionLineLimit = pSuggestionLineLimit;
        this.anchorToBottom = pAnchorToBottom;
        this.fillColor = pFillColor;
        pInput.method_1854(this::formatChat);
    }

    public void setAllowSuggestions(boolean pAutoSuggest) {
        if (!pAutoSuggest) {
            this.suggestions = null;
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.suggestions != null && this.suggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.screen.method_25399() == this.input && pKeyCode == 258) {
            this.showSuggestions(true);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta) {
        return this.suggestions != null && this.suggestions.mouseScrolled((int)pMouseX, (int)pMouseY, class_3532.method_15350((double)pDelta, (double)-1.0, (double)1.0));
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pMouseButton) {
        return this.suggestions != null && this.suggestions.mouseClicked((int)pMouseX, (int)pMouseY, pMouseButton);
    }

    public void showSuggestions(boolean pNarrateFirstSuggestion) {
        Suggestions suggestions;
        if (this.pendingSuggestions != null && this.pendingSuggestions.isDone() && !(suggestions = this.pendingSuggestions.join()).isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                i = Math.max(i, this.font.method_1727(suggestion.getText()));
            }
            int j = class_3532.method_15340((int)this.input.method_1889(suggestions.getRange().getStart()), (int)0, (int)(this.input.method_1889(0) + this.input.method_1859() - i));
            int k = this.anchorToBottom ? this.screen.field_22790 - 12 : 72;
            this.suggestions = new SuggestionsList(j, k, i, this.sortSuggestions(suggestions), pNarrateFirstSuggestion);
        }
    }

    private List<Suggestion> sortSuggestions(Suggestions pSuggestions) {
        String s = this.input.method_1882().substring(0, this.input.method_1881());
        int i = ModCommandSuggestions.getLastWordIndex(s);
        String s1 = s.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (Suggestion suggestion : pSuggestions.getList()) {
            if (!suggestion.getText().startsWith(s1) && !suggestion.getText().startsWith("minecraft:" + s1)) {
                list1.add(suggestion);
                continue;
            }
            list.add(suggestion);
        }
        list.addAll(list1);
        return list;
    }

    public void updateCommandInfo() {
        boolean flag;
        String s = this.input.method_1882();
        if (this.currentParse != null && !this.currentParse.getReader().getString().equals(s)) {
            this.currentParse = null;
        }
        if (!this.keepSuggestions) {
            this.input.method_1887((String)null);
            this.suggestions = null;
        }
        this.commandUsage.clear();
        StringReader stringreader = new StringReader(s);
        boolean bl = flag = stringreader.canRead() && stringreader.peek() == '/';
        if (flag) {
            stringreader.skip();
        }
        boolean flag1 = this.commandsOnly || flag;
        int i = this.input.method_1881();
        if (flag1) {
            int j;
            CommandDispatcher commanddispatcher = this.minecraft.field_1724.field_3944.method_2886();
            if (this.currentParse == null) {
                this.currentParse = commanddispatcher.parse(stringreader, (Object)this.minecraft.field_1724.field_3944.method_2875());
            }
            int n = j = this.onlyShowIfCursorPastError ? stringreader.getCursor() : 1;
            if (!(i < j || this.suggestions != null && this.keepSuggestions)) {
                this.pendingSuggestions = commanddispatcher.getCompletionSuggestions(this.currentParse, i);
                this.pendingSuggestions.thenRun(() -> {
                    if (this.pendingSuggestions.isDone()) {
                        this.updateUsageInfo();
                    }
                });
            }
        } else {
            String s1 = s.substring(0, i);
            int k = ModCommandSuggestions.getLastWordIndex(s1);
            Collection collection = this.minecraft.field_1724.field_3944.method_2875().method_9262();
            this.pendingSuggestions = class_2172.method_9265((Iterable)collection, (SuggestionsBuilder)new SuggestionsBuilder(s1, k));
        }
    }

    private static int getLastWordIndex(String pText) {
        if (Strings.isNullOrEmpty((String)pText)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(pText);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    private static class_5481 getExceptionMessage(CommandSyntaxException pException) {
        class_2561 component = class_2564.method_10883((Message)pException.getRawMessage());
        String s = pException.getContext();
        return s == null ? component.method_30937() : TextUtils.translate((String)"command.context.parse_error", (Object[])new Object[]{component, pException.getCursor(), s}).method_30937();
    }

    private void updateUsageInfo() {
        if (this.input.method_1881() == this.input.method_1882().length()) {
            if (this.pendingSuggestions.join().isEmpty() && !this.currentParse.getExceptions().isEmpty()) {
                int i = 0;
                for (Map.Entry entry : this.currentParse.getExceptions().entrySet()) {
                    CommandSyntaxException commandsyntaxexception = (CommandSyntaxException)entry.getValue();
                    if (commandsyntaxexception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                        ++i;
                        continue;
                    }
                    this.commandUsage.add(ModCommandSuggestions.getExceptionMessage(commandsyntaxexception));
                }
                if (i > 0) {
                    this.commandUsage.add(ModCommandSuggestions.getExceptionMessage(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create()));
                }
            } else if (this.currentParse.getReader().canRead()) {
                this.commandUsage.add(ModCommandSuggestions.getExceptionMessage(class_2170.method_23917(this.currentParse)));
            }
        }
        this.commandUsagePosition = 0;
        this.commandUsageWidth = this.screen.field_22789;
        if (this.commandUsage.isEmpty()) {
            this.fillNodeUsage(class_124.field_1080);
        }
        this.suggestions = null;
    }

    private void fillNodeUsage(class_124 pFormatting) {
        CommandContextBuilder commandcontextbuilder = this.currentParse.getContext();
        SuggestionContext suggestioncontext = commandcontextbuilder.findSuggestionContext(this.input.method_1881());
        Map map = this.minecraft.field_1724.field_3944.method_2886().getSmartUsage(suggestioncontext.parent, (Object)this.minecraft.field_1724.field_3944.method_2875());
        ArrayList list = Lists.newArrayList();
        int i = 0;
        class_2583 style = class_2583.field_24360.method_10977(pFormatting);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            list.add(class_5481.method_30747((String)((String)entry.getValue()), (class_2583)style));
            i = Math.max(i, this.font.method_1727((String)entry.getValue()));
        }
        if (!list.isEmpty()) {
            this.commandUsage.addAll(list);
            this.commandUsagePosition = class_3532.method_15340((int)this.input.method_1889(suggestioncontext.startPos), (int)0, (int)(this.input.method_1889(0) + this.input.method_1859() - i));
            this.commandUsageWidth = i;
        }
    }

    private class_5481 formatChat(String p_93915_, int p_93916_) {
        return this.currentParse != null ? ModCommandSuggestions.formatText(this.currentParse, p_93915_, p_93916_) : class_5481.method_30747((String)p_93915_, (class_2583)class_2583.field_24360);
    }

    @Nullable
    static String calculateSuggestionSuffix(String pInputText, String pSuggestionText) {
        return pSuggestionText.startsWith(pInputText) ? pSuggestionText.substring(pInputText.length()) : null;
    }

    private static class_5481 formatText(ParseResults<class_2172> pProvider, String pCommand, int pMaxLength) {
        int i1;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        int j = -1;
        CommandContextBuilder commandcontextbuilder = pProvider.getContext().getLastChild();
        for (ParsedArgument parsedargument : commandcontextbuilder.getArguments().values()) {
            int k;
            if (++j >= ARGUMENT_STYLES.size()) {
                j = 0;
            }
            if ((k = Math.max(parsedargument.getRange().getStart() - pMaxLength, 0)) >= pCommand.length()) break;
            int l = Math.min(parsedargument.getRange().getEnd() - pMaxLength, pCommand.length());
            if (l <= 0) continue;
            list.add(class_5481.method_30747((String)pCommand.substring(i, k), (class_2583)LITERAL_STYLE));
            list.add(class_5481.method_30747((String)pCommand.substring(k, l), (class_2583)ARGUMENT_STYLES.get(j)));
            i = l;
        }
        if (pProvider.getReader().canRead() && (i1 = Math.max(pProvider.getReader().getCursor() - pMaxLength, 0)) < pCommand.length()) {
            int j1 = Math.min(i1 + pProvider.getReader().getRemainingLength(), pCommand.length());
            list.add(class_5481.method_30747((String)pCommand.substring(i, i1), (class_2583)LITERAL_STYLE));
            list.add(class_5481.method_30747((String)pCommand.substring(i1, j1), (class_2583)UNPARSED_STYLE));
            i = j1;
        }
        list.add(class_5481.method_30747((String)pCommand.substring(i), (class_2583)LITERAL_STYLE));
        return class_5481.method_30749((List)list);
    }

    public void render(class_332 pGuiGraphics, int pMouseX, int pMouseY) {
        if (!this.renderSuggestions(pGuiGraphics, pMouseX, pMouseY)) {
            this.renderUsage(pGuiGraphics);
        }
    }

    public void renderUsage(class_332 pGuiGraphics) {
        int i = 0;
        for (class_5481 formattedcharsequence : this.commandUsage) {
            int j = this.anchorToBottom ? this.screen.field_22790 - 14 - 13 - 12 * i : 72 + 12 * i;
            pGuiGraphics.method_25294(this.commandUsagePosition - 1, j, this.commandUsagePosition + this.commandUsageWidth + 1, j + 12, this.fillColor);
            pGuiGraphics.method_35720(this.font, formattedcharsequence, this.commandUsagePosition, j + 2, -1);
            ++i;
        }
    }

    public boolean renderSuggestions(class_332 pGuiGraphics, int pMouseX, int pMouseY) {
        if (this.suggestions != null) {
            this.suggestions.render(pGuiGraphics, pMouseX, pMouseY);
            return true;
        }
        return false;
    }

    public String getNarrationMessage() {
        return this.suggestions != null ? "\n" + String.valueOf(this.suggestions.getNarrationMessage()) : "";
    }

    public class SuggestionsList {
        private final class_768 rect;
        private final String originalContents;
        private final List<Suggestion> suggestionList;
        private int offset;
        private int current;
        private class_241 lastMouse = class_241.field_1340;
        private boolean tabCycles;

        SuggestionsList(int pXPos, int pYPos, int pWidth, List<Suggestion> pSuggestionList, boolean pNarrateFirstSuggestion) {
            int i = pXPos - 1;
            int j = ModCommandSuggestions.this.anchorToBottom ? pYPos - 3 - Math.min(pSuggestionList.size(), ModCommandSuggestions.this.suggestionLineLimit) * 12 : pYPos;
            this.rect = new class_768(i, j, pWidth + 1, Math.min(pSuggestionList.size(), ModCommandSuggestions.this.suggestionLineLimit) * 12);
            this.originalContents = ModCommandSuggestions.this.input.method_1882();
            this.suggestionList = pSuggestionList;
            this.select(0);
        }

        public void render(class_332 pGuiGraphics, int pMouseX, int pMouseY) {
            Message message;
            boolean flag3;
            int i = Math.min(this.suggestionList.size(), ModCommandSuggestions.this.suggestionLineLimit);
            boolean flag = this.offset > 0;
            boolean flag1 = this.suggestionList.size() > this.offset + i;
            boolean flag2 = flag || flag1;
            boolean bl = flag3 = this.lastMouse.field_1343 != (float)pMouseX || this.lastMouse.field_1342 != (float)pMouseY;
            if (flag3) {
                this.lastMouse = new class_241((float)pMouseX, (float)pMouseY);
            }
            if (flag2) {
                pGuiGraphics.method_25294(this.rect.method_3321(), this.rect.method_3322() - 1, this.rect.method_3321() + this.rect.method_3319(), this.rect.method_3322(), ModCommandSuggestions.this.fillColor);
                pGuiGraphics.method_25294(this.rect.method_3321(), this.rect.method_3322() + this.rect.method_3320(), this.rect.method_3321() + this.rect.method_3319(), this.rect.method_3322() + this.rect.method_3320() + 1, ModCommandSuggestions.this.fillColor);
                if (flag) {
                    for (int k = 0; k < this.rect.method_3319(); ++k) {
                        if (k % 2 != 0) continue;
                        pGuiGraphics.method_25294(this.rect.method_3321() + k, this.rect.method_3322() - 1, this.rect.method_3321() + k + 1, this.rect.method_3322(), -1);
                    }
                }
                if (flag1) {
                    for (int i1 = 0; i1 < this.rect.method_3319(); ++i1) {
                        if (i1 % 2 != 0) continue;
                        pGuiGraphics.method_25294(this.rect.method_3321() + i1, this.rect.method_3322() + this.rect.method_3320(), this.rect.method_3321() + i1 + 1, this.rect.method_3322() + this.rect.method_3320() + 1, -1);
                    }
                }
            }
            boolean flag4 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestionList.get(l + this.offset);
                pGuiGraphics.method_25294(this.rect.method_3321(), this.rect.method_3322() + 12 * l, this.rect.method_3321() + this.rect.method_3319(), this.rect.method_3322() + 12 * l + 12, ModCommandSuggestions.this.fillColor);
                if (pMouseX > this.rect.method_3321() && pMouseX < this.rect.method_3321() + this.rect.method_3319() && pMouseY > this.rect.method_3322() + 12 * l && pMouseY < this.rect.method_3322() + 12 * l + 12) {
                    if (flag3) {
                        this.select(l + this.offset);
                    }
                    flag4 = true;
                }
                pGuiGraphics.method_25303(ModCommandSuggestions.this.font, suggestion.getText(), this.rect.method_3321() + 1, this.rect.method_3322() + 2 + 12 * l, l + this.offset == this.current ? -256 : -5592406);
            }
            if (flag4 && (message = this.suggestionList.get(this.current).getTooltip()) != null) {
                pGuiGraphics.method_51438(ModCommandSuggestions.this.font, class_2564.method_10883((Message)message), pMouseX, pMouseY);
            }
        }

        public boolean mouseClicked(int pMouseX, int pMouseY, int pMouseButton) {
            if (!this.rect.method_3318(pMouseX, pMouseY)) {
                return false;
            }
            int i = (pMouseY - this.rect.method_3322()) / 12 + this.offset;
            if (i >= 0 && i < this.suggestionList.size()) {
                this.select(i);
                this.useSuggestion();
            }
            return true;
        }

        public boolean mouseScrolled(int pMouseX, int pMouseY, double pDelta) {
            if (this.rect.method_3318(pMouseX, pMouseY)) {
                this.offset = class_3532.method_15340((int)((int)((double)this.offset - pDelta)), (int)0, (int)Math.max(this.suggestionList.size() - ModCommandSuggestions.this.suggestionLineLimit, 0));
                return true;
            }
            return false;
        }

        public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (pKeyCode == 265) {
                this.cycle(-1);
                this.tabCycles = false;
                return true;
            }
            if (pKeyCode == 264) {
                this.cycle(1);
                this.tabCycles = false;
                return true;
            }
            if (pKeyCode == 258) {
                if (this.tabCycles) {
                    this.cycle(class_437.method_25442() ? -1 : 1);
                }
                this.useSuggestion();
                return true;
            }
            if (pKeyCode == 256) {
                this.hide();
                return true;
            }
            return false;
        }

        public void cycle(int pChange) {
            this.select(this.current + pChange);
            int i = this.offset;
            int j = this.offset + ModCommandSuggestions.this.suggestionLineLimit - 1;
            if (this.current < i) {
                this.offset = class_3532.method_15340((int)this.current, (int)0, (int)Math.max(this.suggestionList.size() - ModCommandSuggestions.this.suggestionLineLimit, 0));
            } else if (this.current > j) {
                this.offset = class_3532.method_15340((int)(this.current + ModCommandSuggestions.this.lineStartOffset - ModCommandSuggestions.this.suggestionLineLimit), (int)0, (int)Math.max(this.suggestionList.size() - ModCommandSuggestions.this.suggestionLineLimit, 0));
            }
        }

        public void select(int pIndex) {
            this.current = pIndex;
            if (this.current < 0) {
                this.current += this.suggestionList.size();
            }
            if (this.current >= this.suggestionList.size()) {
                this.current -= this.suggestionList.size();
            }
            Suggestion suggestion = this.suggestionList.get(this.current);
            ModCommandSuggestions.this.input.method_1887(ModCommandSuggestions.calculateSuggestionSuffix(ModCommandSuggestions.this.input.method_1882(), suggestion.apply(this.originalContents)));
        }

        public void useSuggestion() {
            Suggestion suggestion = this.suggestionList.get(this.current);
            ModCommandSuggestions.this.keepSuggestions = true;
            ModCommandSuggestions.this.input.method_1852(suggestion.apply(this.originalContents));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            ModCommandSuggestions.this.input.method_1875(i);
            ModCommandSuggestions.this.input.method_1884(i);
            this.select(this.current);
            ModCommandSuggestions.this.keepSuggestions = false;
            this.tabCycles = true;
        }

        class_2561 getNarrationMessage() {
            Suggestion suggestion = this.suggestionList.get(this.current);
            Message message = suggestion.getTooltip();
            return message != null ? TextUtils.translate((String)"narration.suggestion.tooltip", (Object[])new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText(), message}) : TextUtils.translate((String)"narration.suggestion", (Object[])new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText()});
        }

        public void hide() {
            ModCommandSuggestions.this.suggestions = null;
        }
    }
}

