/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.widgets.routedetails.RouteDetailsTransferWidget;
import de.mrjulsen.crn.client.gui.widgets.routedetails.RoutePartWidget;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class RouteDetailsViewer
extends DLScrollableWidgetContainer {
    private final DLAbstractScrollBar<?> scrollBar;
    private int contentHeight = 0;
    private Set<RoutePart> expandedParts = new HashSet<RoutePart>();
    private boolean canExpandCollapse = true;
    private boolean showTrainDetails = true;
    private boolean initialExpanded = false;
    private boolean showJourney = false;
    private final class_437 parent;

    public RouteDetailsViewer(class_437 parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar) {
        super(x, y, width, height);
        this.scrollBar = scrollBar;
        this.parent = parent;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.setMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }

    public void displayRoute(ClientRoute route) {
        this.displayRouteInternal(route, route.getClientParts(), true);
    }

    public void displayPart(ClientRoute route, Predicate<RoutePart> verifiedSelector) {
        this.displayRouteInternal(route, route.getClientParts().stream().filter(verifiedSelector).toList(), false);
    }

    public void displayRouteInternal(ClientRoute route, List<ClientRoutePart> parts, boolean displayConnections) {
        this.clearWidgets();
        this.contentHeight = 10;
        ConcurrentLinkedQueue<TransferConnection> connections = new ConcurrentLinkedQueue<TransferConnection>(route.getConnections());
        for (int i = 0; i < parts.size(); ++i) {
            ClientRoutePart part = parts.get(i);
            RoutePartWidget widget = new RoutePartWidget(this.parent, this.x(), this.y() + this.contentHeight, this.width(), route, part);
            widget.setShowTrainDetails(this.showTrainDetails);
            widget.setCanExpandCollapse(this.canExpandCollapse);
            widget.setShowJourney(this.showJourney);
            widget.setExpanded(this.expandedParts.contains(part) || this.initialExpanded);
            widget.withOnGuiChangedEvent(w -> {
                if (w.isExpanded()) {
                    this.expandedParts.add(part);
                } else {
                    this.expandedParts.remove(part);
                }
                this.displayRoute(route);
            });
            this.addRenderableWidget((class_364)widget);
            this.contentHeight += widget.height();
            if (connections.isEmpty() || !displayConnections) continue;
            RouteDetailsTransferWidget transfer = (RouteDetailsTransferWidget)this.addRenderableOnly((class_4068)new RouteDetailsTransferWidget(this.x(), this.y() + this.contentHeight, this.width(), (TransferConnection)connections.poll()));
            this.contentHeight += transfer.height();
        }
        this.contentHeight += 10;
        this.scrollBar.setMaxScroll(this.contentHeight);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
    }

    public void renderMainLayerScrolled(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawTexture((class_2960)Constants.GUI_WIDGETS, (Graphics)graphics, (int)this.x(), (int)this.y(), (int)22, (int)10, (int)0, (int)179, (int)22, (int)1, (int)256, (int)256);
        GuiUtils.drawTexture((class_2960)Constants.GUI_WIDGETS, (Graphics)graphics, (int)this.x(), (int)(this.y() + this.contentHeight - 10), (int)22, (int)Math.max(10, this.height() - this.contentHeight + 10), (int)0, (int)179, (int)22, (int)1, (int)256, (int)256);
        super.renderMainLayerScrolled(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean canExpandCollapse() {
        return this.canExpandCollapse;
    }

    public void setCanExpandCollapse(boolean canExpandCollapse) {
        this.canExpandCollapse = canExpandCollapse;
    }

    public boolean showTrainDetails() {
        return this.showTrainDetails;
    }

    public void setShowTrainDetails(boolean showTrainDetails) {
        this.showTrainDetails = showTrainDetails;
    }

    public boolean isInitialExpanded() {
        return this.initialExpanded;
    }

    public void setInitialExpanded(boolean b) {
        this.initialExpanded = b;
    }

    public boolean isShowingJourney() {
        return this.showJourney;
    }

    public void setShowJourney(boolean b) {
        this.showJourney = b;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }
}

