/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.Animator;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.RouteWidget;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.storage.RecentSearchQueries;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class RouteViewer
extends DLScrollableWidgetContainer
implements Closeable {
    private final class_5250 searchingText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.searching");
    private final class_5250 noConnectionsText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.no_connections");
    private final class_5250 notSearchedText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.not_searched");
    private final class_5250 txtRecentSearchQueries = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.recently_searched").method_27692(class_124.field_1067);
    private final class_437 parent;
    private final DLAbstractScrollBar<?> scrollBar;
    private boolean shouldDisplayRecentSearchQueries;
    private UserSettings userSettings;
    private int contentHeight = 0;
    private int angle = 0;
    private final List<ClientRoute> routes = new ArrayList<ClientRoute>();
    private final Consumer<List<ClientRoute>> onUpdateRoutes;
    private DLIconButton closeBtn;
    private boolean loadingRoutes = false;
    private boolean hasSearched = false;
    private final Animator animator = new Animator();
    private double animPercentage = 0.0;
    private double renderOffsetX = 0.0;
    private boolean animationStarted = false;

    public RouteViewer(class_437 parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar, Consumer<List<ClientRoute>> onUpdateRoutes) {
        super(x, y, width, height);
        this.parent = parent;
        this.scrollBar = scrollBar;
        this.onUpdateRoutes = onUpdateRoutes;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.setMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
        this.setupList();
    }

    public void enableRecentlySearchedList(UserSettings settings) {
        this.shouldDisplayRecentSearchQueries = true;
        this.userSettings = settings;
        this.refresh(settings);
    }

    public class_437 getParent() {
        return this.parent;
    }

    public List<ClientRoute> getRoutes() {
        return ImmutableList.copyOf(this.routes);
    }

    public void setRoutes(Collection<ClientRoute> routes, boolean closeCurrent) {
        if (closeCurrent) {
            this.clear();
        }
        if (routes != null) {
            this.routes.addAll(routes);
            DLUtils.doIfNotNull(this.onUpdateRoutes, x -> x.accept(this.getRoutes()));
            this.hasSearched = true;
        }
        this.setupList();
    }

    public void search(String from, String to, UserSettings settings, Consumer<RouteViewer> andThen) {
        this.loadingRoutes = true;
        this.userSettings = settings;
        this.userSettings.recentSearchQueries.getValue().add(new RecentSearchQueries.RecentSearchQuery(from, to));
        this.clear();
        this.userSettings.clientSave(() -> {
            this.animator.start(10, (poseStack, current, total, percentage) -> {
                this.animPercentage = Math.pow(1.0 - percentage, 4.0);
                this.renderOffsetX = -(50.0 * this.animPercentage);
            }, null, () -> {
                this.renderOffsetX = 0.0;
                DataAccessor.getFromServer((Object)new ModAccessorTypes.NavigationData(from, to, class_310.method_1551().field_1724.method_5667()), ModAccessorTypes.NAVIGATE, routeList -> this.animator.start(10, (poseStack, current, total, percentage) -> {
                    this.animPercentage = Math.pow(percentage, 4.0);
                    this.renderOffsetX = 50.0 * this.animPercentage;
                }, null, () -> {
                    this.animationStarted = false;
                    this.animPercentage = 0.0;
                    this.renderOffsetX = 0.0;
                    this.setRoutes((Collection<ClientRoute>)routeList, true);
                    this.loadingRoutes = false;
                    DLUtils.doIfNotNull((Object)andThen, x -> x.accept(this));
                    if (this.routes.isEmpty()) {
                        this.closeBtn = (DLIconButton)this.addRenderableWidget((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.X.getAsSprite(16, 16), this.x() + this.width() / 2 - 9, this.y() + this.height() / 2 + 20, (class_2561)TextUtils.empty(), btn -> {
                            this.hasSearched = false;
                            this.refresh(this.userSettings);
                        }));
                        this.closeBtn.setBackColor(0);
                    }
                }));
            });
            this.animationStarted = true;
        });
    }

    public void clearWidgets() {
        super.clearWidgets();
        this.closeBtn = null;
    }

    public void method_1865() {
        super.method_1865();
        this.animator.method_1865();
    }

    public void refresh(UserSettings settings) {
        if (this.loadingRoutes) {
            return;
        }
        this.userSettings = settings;
        this.clearWidgets();
        this.setupList();
    }

    private void setupList() {
        this.clearWidgets();
        this.contentHeight = 0;
        if (this.shouldDisplayRecentSearchQueries && !this.hasSearched && !this.loadingRoutes && this.routes.isEmpty() && this.userSettings != null) {
            Objects.requireNonNull(class_310.method_1551().field_1772);
            this.contentHeight = 20 + 9;
            for (RecentSearchQueries.RecentSearchQuery query : this.userSettings.recentSearchQueries.getValue().getAll()) {
                RecentSearchQueryButton btn = (RecentSearchQueryButton)this.addRenderableWidget((class_364)new RecentSearchQueryButton(this, this.x() + 10, this.y() + this.contentHeight, this.width() - 20, query));
                this.contentHeight += btn.height();
            }
            this.contentHeight += 10;
        } else if (!this.routes.isEmpty()) {
            this.contentHeight = 5;
            for (int i = 0; i < this.routes.size(); ++i) {
                RouteWidget widget = new RouteWidget(this, this.routes.get(i), this.x() + 10, this.y() + this.contentHeight);
                this.addRenderableWidget((class_364)widget);
                this.contentHeight += 57;
            }
            this.contentHeight += 2;
        }
        this.scrollBar.setMaxScroll(this.contentHeight);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.animator.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22904(this.renderOffsetX, 0.0, 0.0);
        partialTicks = class_310.method_1551().method_1488();
        this.angle = (int)((float)this.angle + 6.0f * partialTicks);
        if (this.angle > 360) {
            this.angle = 0;
        }
        double offsetX = Math.sin(Math.toRadians(this.angle)) * 5.0;
        double offsetY = Math.cos(Math.toRadians(this.angle)) * 5.0;
        if (!this.loadingRoutes) {
            if (this.hasSearched && this.routes.isEmpty()) {
                int n = this.x() + this.width() / 2;
                int n2 = this.y() + this.height() / 2 + 15;
                Objects.requireNonNull(this.font);
                GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)n, (int)(n2 - 9 - 10), (class_5348)this.noConnectionsText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                class_332 class_3322 = graphics.graphics();
                int n3 = this.x() + this.width() / 2 - 8;
                int n4 = this.y() + this.height() / 2 - 15;
                Objects.requireNonNull(this.font);
                AllIcons.I_ACTIVE.render(class_3322, n3, n4 - 9 - 10);
            } else if (this.shouldDisplayRecentSearchQueries && !this.hasSearched && !this.userSettings.recentSearchQueries.getValue().isEmpty()) {
                GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(this.x() + 10), (int)(this.y() + 10), (class_5348)this.txtRecentSearchQueries, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)true);
                if (this.userSettings == null) {
                    int n = this.x() + this.width() / 2;
                    int n5 = this.y() + this.height() / 2 + 15;
                    Objects.requireNonNull(this.font);
                    GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)n, (int)(n5 - 9), (class_5348)Constants.TEXT_LOADING, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                    class_332 class_3323 = graphics.graphics();
                    int n6 = (int)((double)(this.x() + this.width() / 2 - 8) + offsetX);
                    int n7 = this.y() + this.height() / 2 - 15;
                    Objects.requireNonNull(this.font);
                    AllIcons.I_MTD_SCAN.render(class_3323, n6, (int)((double)(n7 - 9) + offsetY));
                }
            } else if (!this.hasSearched) {
                int n = this.x() + this.width() / 2;
                int n8 = this.y() + this.height() / 2 + 15;
                Objects.requireNonNull(this.font);
                GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)n, (int)(n8 - 9), (class_5348)this.notSearchedText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                int n9 = this.x() + this.width() / 2 - 8;
                int n10 = this.y() + this.height() / 2 - 15;
                Objects.requireNonNull(this.font);
                ModGuiIcons.INFO.render(graphics, n9, n10 - 9);
            }
        } else if (this.animationStarted) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            GuiUtils.setTint((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.animator.isRunning() ? (float)(1.0 - this.animPercentage) : 1.0f));
            int n = this.x() + this.width() / 2 - this.font.method_27525((class_5348)this.searchingText) / 2 - 10;
            int n11 = this.y() + this.height() / 2 - 25;
            Objects.requireNonNull(this.font);
            CreateDynamicWidgets.renderShadow(graphics, n, n11 - 9, this.font.method_27525((class_5348)this.searchingText) + 20, 55);
            int n12 = this.x() + this.width() / 2;
            int n13 = this.y() + this.height() / 2 + 15;
            Objects.requireNonNull(this.font);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)n12, (int)(n13 - 9), (class_5348)this.searchingText, (int)((int)(255.0f * (float)(1.0 - this.animPercentage)) << 24 | 0xFFFFFF), (EAlignment)EAlignment.CENTER, (boolean)false);
            class_332 class_3324 = graphics.graphics();
            int n14 = (int)((double)(this.x() + this.width() / 2 - 8) + offsetX);
            int n15 = this.y() + this.height() / 2 - 15;
            Objects.requireNonNull(this.font);
            AllIcons.I_MTD_SCAN.render(class_3324, n14, (int)((double)(n15 - 9) + offsetY));
        }
        if (this.scrollBar.getScrollValue() > 0.0) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        }
        if (this.scrollBar.getScrollValue() < (double)this.scrollBar.getMaxScroll()) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
        }
        graphics.poseStack().method_22909();
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.closeBtn != null) {
            GuiUtils.renderTooltip((class_437)this.parent, (class_339)this.closeBtn, List.of(DragonLib.TEXT_CLOSE), (int)200, (Graphics)graphics, (int)mouseX, (int)mouseY);
        }
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    public void clear() {
        this.routes.forEach(ClientRoute::close);
        this.routes.clear();
        this.clearWidgets();
    }

    public boolean isLoading() {
        return this.loadingRoutes;
    }

    private static class RecentSearchQueryButton
    extends DLButton {
        private final class_2561 text;
        private final class_2561 subText;

        public RecentSearchQueryButton(RouteViewer viewer, int x, int y, int width, RecentSearchQueries.RecentSearchQuery query) {
            super(x, y, width, 12, (class_2561)TextUtils.empty(), btn -> viewer.search(query.getStartStation(), query.getDestinationStation(), viewer.userSettings, null));
            this.subText = GuiUtils.ellipsisString((class_327)class_310.method_1551().field_1772, (class_2561)TextUtils.text((String)DragonLib.DATE_FORMAT.format(query.getCreationTime())).method_27692(class_124.field_1080), (int)((int)((float)(width - 6) / 0.75f)));
            this.text = GuiUtils.ellipsisString((class_327)class_310.method_1551().field_1772, (class_2561)TextUtils.text((String)String.format("%s \u2192 %s", query.getStartStation(), query.getDestinationStation())), (int)((int)((float)(width - 6 - class_310.method_1551().field_1772.method_27525((class_5348)this.subText) - 5) / 0.75f)));
            this.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
            this.setBackColor(0);
            this.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((class_339)this), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData(Constants.TEXT_SEARCH, Sprite.empty(), true, b -> this.field_22767.onPress((class_4185)b), null)).addSeparator().add(new DLContextMenuItem.ContextMenuItemData(Constants.TEXT_REMOVE, Sprite.empty(), true, b -> DLUtils.doIfNotNull((Object)viewer.userSettings, a -> {
                a.recentSearchQueries.getValue().remove(query);
                a.clientSave(() -> {
                    viewer.hasSearched = false;
                    viewer.refresh(viewer.userSettings);
                });
            }), null))));
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
            super.renderMainLayer(graphics, mouseX, mouseY, partialTick);
            graphics.poseStack().method_22903();
            graphics.poseStack().method_46416((float)(this.x() + 3), (float)(this.y() + 3), 0.0f);
            graphics.poseStack().method_22905(0.75f, 0.75f, 0.75f);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)0, (int)0, (class_5348)this.text, (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().method_22909();
            graphics.poseStack().method_22903();
            graphics.poseStack().method_46416((float)(this.x() + this.width() - 3), (float)(this.y() + 3), 0.0f);
            graphics.poseStack().method_22905(0.75f, 0.75f, 0.75f);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)0, (int)0, (class_5348)this.subText, (int)-1, (EAlignment)EAlignment.RIGHT, (boolean)false);
            graphics.poseStack().method_22909();
        }
    }
}

