/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.widgets.SavedRouteWidget;
import de.mrjulsen.crn.data.ISavableNavigatorData;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLRenderable;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class SavedRoutesViewer
extends DLScrollableWidgetContainer {
    private final class_437 parent;
    private final DLAbstractScrollBar<?> scrollBar;
    private int contentHeight = 0;
    private List<? extends ISavableNavigatorData> data = List.of();

    public SavedRoutesViewer(class_437 parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar) {
        super(x, y, width, height);
        this.parent = parent;
        this.scrollBar = scrollBar;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.setMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }

    public class_437 getParent() {
        return this.parent;
    }

    public void refresh() {
        this.displayRoutes(this.data);
    }

    public void displayRoutes(List<? extends ISavableNavigatorData> data) {
        this.data = data;
        Collections.sort(data, Comparator.comparing(x -> ((ISavableNavigatorData)x).customGroup() == null ? null : (String)((ISavableNavigatorData)x).customGroup().getFirst(), Comparator.nullsLast(Comparator.naturalOrder())).thenComparingLong(x -> ((ISavableNavigatorData)x).dayOrderValue()).thenComparingLong(x -> ((ISavableNavigatorData)x).timeOrderValue()));
        this.clearWidgets();
        this.contentHeight = 5;
        ISavableNavigatorData lastData = null;
        for (int i = 0; i < data.size(); ++i) {
            ISavableNavigatorData d = data.get(i);
            if (lastData != null && lastData.customGroup() != d.customGroup()) {
                this.contentHeight += ((GroupingHeader)this.addRenderableOnly((class_4068)new GroupingHeader(this.x(), this.y() + this.contentHeight, this.width(), (class_2561)(d.customGroup() == null ? TextUtils.empty() : (class_5250)d.customGroup().getSecond()).method_27692(class_124.field_1067)))).height();
            }
            if (lastData == null || lastData.dayOrderValue() != d.dayOrderValue()) {
                long worldTime = DragonLib.getCurrentWorldTime();
                long dayDiff = d.dayOrderValue() - (worldTime + DragonLib.daytimeShift()) / DragonLib.ticksPerDay();
                class_5250 text = d.timeOrderValue() < worldTime ? TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.in_the_past") : (dayDiff == 0L ? TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.today") : (dayDiff == 1L ? TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.tomorrow") : TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.in_days", (Object[])new Object[]{dayDiff})));
                this.contentHeight += ((GroupingHeader)this.addRenderableOnly((class_4068)new GroupingHeader(this.x(), this.y() + this.contentHeight, this.width(), (class_2561)text))).height();
            }
            lastData = d;
            SavedRouteWidget widget = new SavedRouteWidget(this, this.x(), this.y() + this.contentHeight, d);
            this.addRenderableWidget((class_364)widget);
            widget.set_x(this.x() + this.width() / 2 - widget.width() / 2);
            this.contentHeight += widget.height() + 3;
        }
        this.contentHeight += 10;
        this.scrollBar.setMaxScroll(this.contentHeight);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.method_25396().isEmpty()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(this.x() + this.width() / 2), (int)(this.y() + this.height() / 2), (class_5348)TextUtils.translate((String)"gui.createrailwaysnavigator.empty_list"), (int)-2368549, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    private static final class GroupingHeader
    extends DLRenderable {
        private static final int HEIGHT = 24;
        private final class_2561 text;

        public GroupingHeader(int x, int y, int width, class_2561 text) {
            super(x, y, width, 24);
            this.text = text == null ? TextUtils.empty() : text;
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            class_327 class_3272 = class_310.method_1551().field_1772;
            int n = this.x() + 10;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(class_310.method_1551().field_1772);
            GuiUtils.drawString((Graphics)graphics, (class_327)class_3272, (int)n, (int)(n2 - 9 / 2), (class_5348)this.text, (int)-1, (EAlignment)EAlignment.LEFT, (boolean)true);
        }
    }
}

