/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.GlobalSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.CRNListBox;
import de.mrjulsen.crn.client.gui.widgets.DLCreateTextBox;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class TrustedPlayersWidget
extends DLWidgetContainer {
    private final class_437 parent;
    private final CRNListBox<Owner, Entry> listbox;
    private final Map<String, Owner> playerListByName = new HashMap<String, Owner>();
    private final Set<Owner> currentPlayerList = new HashSet<Owner>();
    private String searchText = "";

    public TrustedPlayersWidget(class_437 parent, int x, int y, int width, int height, GlobalSettingsScreen.IPlayerListSuggestionData suggestions, Set<Owner> currentPlayerList) {
        super(x, y, width, height);
        this.parent = parent;
        this.currentPlayerList.addAll(currentPlayerList);
        GuiAreaDefinition listArea = new GuiAreaDefinition(this.x(), this.y() + 16, this.width() - 5, this.height() - 16 - 18);
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar(this.parent, listArea.getRight(), listArea.getY(), listArea.getHeight(), listArea);
        this.listbox = (CRNListBox)this.addRenderableWidget((class_364)new CRNListBox(this.parent, listArea.getX(), listArea.getY(), listArea.getWidth(), listArea.getHeight(), (DLAbstractScrollBar<?>)scrollBar));
        this.addRenderableWidget((class_364)scrollBar);
        DLEditBox addBox = (DLEditBox)this.addRenderableWidget((class_364)new DLCreateTextBox(this.font, this.x(), this.y() + this.height() - 18, this.width() - 18, (class_2561)TextUtils.empty()));
        addBox.method_1863(value -> suggestions.run(addBox, this.playerListByName.values(), this.currentPlayerList));
        DLIconButton addBtn = (DLIconButton)this.addRenderableWidget((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.ADD.getAsSprite(16, 16), this.x() + this.width() - 18, this.y() + this.height() - 18, (class_2561)TextUtils.empty(), btn -> {
            if (addBox.method_1882() != null && !addBox.method_1882().isBlank() && this.playerListByName.containsKey(addBox.method_1882())) {
                this.currentPlayerList.add(this.playerListByName.get(addBox.method_1882()));
                addBox.method_1852("");
                this.reload();
            }
        }));
        addBtn.setBackColor(0);
        DLEditBox searchBox = (DLEditBox)this.addRenderableWidget((class_364)new DLEditBox(this.font, this.x() + 1, this.y() + 1, this.width() - 2, 14, (class_2561)TextUtils.empty()){

            public boolean method_25404(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
                if (code == 257) {
                    TrustedPlayersWidget.this.searchText = this.method_1882();
                    TrustedPlayersWidget.this.refreshListBox();
                    return true;
                }
                return super.method_25404(code, p_keyPressed_2_, p_keyPressed_3_);
            }
        });
        searchBox.method_1852(this.searchText);
        searchBox.withHint(DragonLib.TEXT_SEARCH);
        this.reload();
    }

    private void reload() {
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ONLINE_PLAYERS, list -> {
            this.playerListByName.clear();
            for (Owner o : list) {
                this.playerListByName.put(o.name(), o);
            }
            this.refreshListBox();
        });
    }

    private void refreshListBox() {
        this.listbox.displayData(this.currentPlayerList.stream().filter(x -> x.name().toLowerCase(Locale.ROOT).contains(this.searchText.toLowerCase(Locale.ROOT))).sorted((a, b) -> a.name().compareToIgnoreCase(b.name())).toList(), (player, i) -> new Entry(this, this.x(), this.y(), this.listbox.width(), (Owner)player));
    }

    public Set<Owner> getPlayers() {
        return this.currentPlayerList;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    private static class Entry
    extends DLWidgetContainer {
        private final Owner player;

        public Entry(TrustedPlayersWidget parent, int x, int y, int width, Owner player) {
            super(x, y, width, 18);
            this.player = player;
            DLIconButton deleteBtn = (DLIconButton)this.addRenderableWidget((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.DELETE.getAsSprite(16, 16), this.x() + this.width() - 16, this.y() + 1, 16, 16, (class_2561)TextUtils.empty(), btn -> {
                parent.currentPlayerList.removeIf(a -> a.equals(player));
                parent.refreshListBox();
            }));
            deleteBtn.setBackColor(0);
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
            CreateDynamicWidgets.renderTextSlotOverlay(graphics, this.x(), this.y() + 1, this.width() - 18, this.height() - 2);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(this.x() + 5), (int)(this.y() + 5), (String)this.player.name(), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33785;
        }

        public void method_37020(class_6382 narrationElementOutput) {
        }

        public boolean consumeScrolling(double mouseX, double mouseY) {
            return false;
        }
    }
}

