/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.modular;

import de.mrjulsen.crn.client.gui.widgets.modular.ModularWidgetContainer;
import de.mrjulsen.crn.client.gui.widgets.modular.ModularWidgetLine;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ModularWidgetBuilder {
    private final ModularWidgetContainer container;
    private final Map<String, Consumer<ModularWidgetLine>> lineBuilders = new LinkedHashMap<String, Consumer<ModularWidgetLine>>();

    public ModularWidgetBuilder(ModularWidgetContainer container) {
        this.container = container;
    }

    public void addLine(String name, Consumer<ModularWidgetLine> lineBuilder) {
        if (this.lineBuilders.containsKey(name)) {
            return;
        }
        this.lineBuilders.put(name, lineBuilder);
    }

    public void clear() {
        this.lineBuilders.clear();
    }

    public int getCurrentLinesCount() {
        return this.lineBuilders.size();
    }

    public boolean hasLine(String name) {
        return this.lineBuilders.containsKey(name);
    }

    public Consumer<ModularWidgetLine> getLine(String name) {
        return this.lineBuilders.get(name);
    }

    public void addToLine(String name, Consumer<ModularWidgetLine> additional) {
        this.lineBuilders.replace(name, this.lineBuilders.get(name).andThen(additional));
    }

    public void build() {
        int currentY = 0;
        for (Consumer<ModularWidgetLine> c : this.lineBuilders.values()) {
            ModularWidgetLine line = new ModularWidgetLine(0, 0, this.container.width());
            line.set_width(this.container.width() - this.container.getPaddingLeft() - this.container.getPaddingRight());
            c.accept(line);
            currentY += this.container.addLine(line, currentY);
        }
        DLAbstractScrollBar<?> scrollBar = this.container.getScrollbar();
        scrollBar.set_x(this.container.x() + this.container.width() - scrollBar.width());
        scrollBar.set_y(this.container.y());
        scrollBar.set_height(this.container.height());
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.container.height());
        scrollBar.setMaxScroll(currentY + this.container.getPaddingBottom());
        scrollBar.withOnValueChanged(sb -> this.container.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }
}

