/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.crn.client.gui.Animator;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.options.DLOptionsList;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntryHeader;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class OptionEntry<T extends DLWidgetContainer>
extends DLWidgetContainer
implements Closeable {
    private int btnX = 0;
    private final Collection<DLButton> additionalButtons = new ArrayList<DLButton>();
    private final Map<DLIconButton, DLTooltip> tooltips = new HashMap<DLIconButton, DLTooltip>();
    private List<class_5348> descriptionTooltips;
    private final int initialHeight = 20;
    private final class_2561 description;
    private class_2561 text;
    private final class_437 parent;
    private final DLOptionsList parentList;
    private final T contentContainer;
    private final Consumer<OptionEntry<T>> onSizeChanged;
    private final OptionEntryHeader header;
    private DLEditBox editBox;
    private final Animator animator = (Animator)this.addRenderableOnly((class_4068)new Animator());
    private boolean expanded;
    private boolean closing;

    public static void expandOrCollapse(OptionEntry<?> entry) {
        if (entry.isExpanded()) {
            entry.collapse();
        } else {
            entry.expand();
        }
    }

    public OptionEntry(class_437 parent, DLOptionsList parentList, int x, int y, int width, Function<OptionEntry<T>, T> contentContainer, class_2561 text, class_2561 description, Consumer<OptionEntry<T>> onSizeChanged, BiConsumer<OptionEntry<T>, OptionEntryHeader> onHeaderClick, Function<String, Boolean> onTitleEdited) {
        super(x, y, width, 20);
        this.parent = parent;
        this.parentList = parentList;
        this.text = text;
        this.contentContainer = contentContainer != null ? (DLWidgetContainer)contentContainer.apply(this) : null;
        this.description = description;
        this.onSizeChanged = onSizeChanged;
        this.setTooltip(this.font.method_27527().method_27495((class_5348)description, width, class_2583.field_24360));
        this.header = (OptionEntryHeader)this.addRenderableWidget((class_364)new OptionEntryHeader(this, this.x(), this.y(), this.width(), text, b -> onHeaderClick.accept(this, (OptionEntryHeader)((Object)b))));
        DLUtils.doIfNotNull(this.contentContainer, a -> {
            this.addRenderableWidget((class_364)a);
            a.set_visible(false);
        });
        if (onTitleEdited != null) {
            int n = this.x() + 5;
            int n2 = this.y() + 6;
            int n3 = this.width() - 5 - 25;
            Objects.requireNonNull(this.font);
            this.editBox = (DLEditBox)this.addRenderableWidget((class_364)new DLEditBox(this.font, n, n2, n3, 9, text){

                public void setMouseSelected(boolean selected) {
                    super.setMouseSelected(selected);
                    if (selected) {
                        OptionEntry.this.header.setCustomMouseSelected(true);
                    }
                }
            });
            this.editBox.method_1852(text.getString());
            this.editBox.method_1858(false);
            this.editBox.method_1880(32);
            this.editBox.set_visible(false);
            this.editBox.withOnFocusChanged((box, focus) -> {
                if (!focus.booleanValue() && !this.closing && ((Boolean)onTitleEdited.apply(box.method_1882())).booleanValue()) {
                    this.text = TextUtils.text((String)box.method_1882());
                    this.header.method_25355(this.text);
                }
            });
        }
        this.animator.start(10, null, null, null);
    }

    @Override
    public void close() {
        super.close();
        this.closing = true;
    }

    public DLIconButton addAdditionalButton(Sprite icon, List<class_5348> text, BiConsumer<OptionEntry<T>, DLIconButton> onClick) {
        DLIconButton btn = new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, icon, this.x() + this.width() - 2 - 18 - this.btnX - 16, this.y() + 2, 16, 16, (class_2561)TextUtils.empty(), x -> onClick.accept(this, (DLIconButton)x)){

            public void setMouseSelected(boolean selected) {
                super.setMouseSelected(selected);
                OptionEntry.this.header.setCustomMouseSelected(selected);
            }
        };
        btn.setBackColor(0);
        DLTooltip tooltip = DLTooltip.of(text).assignedTo((class_339)btn);
        tooltip.setDynamicOffset(() -> (int)this.parentList.getXScrollOffset(), () -> (int)this.parentList.getYScrollOffset());
        this.tooltips.put(btn, tooltip);
        this.btnX += btn.width();
        this.addRenderableWidget((class_364)btn);
        this.additionalButtons.add((DLButton)btn);
        return btn;
    }

    public void updateTooltipOf(DLIconButton widget, List<class_5348> text) {
        DLTooltip tooltip = DLTooltip.of(text).assignedTo((class_339)widget);
        tooltip.setDynamicOffset(() -> (int)this.parentList.getXScrollOffset(), () -> (int)this.parentList.getYScrollOffset());
        this.tooltips.put(widget, tooltip);
    }

    public OptionEntry(class_437 parent, DLOptionsList parentList, int x, int y, int width, Function<OptionEntry<T>, T> contentContainer, class_2561 text, class_2561 description, Consumer<OptionEntry<T>> onExpandedChanged, BiConsumer<OptionEntry<T>, OptionEntryHeader> onHeaderClick) {
        this(parent, parentList, x, y, width, contentContainer, text, description, onExpandedChanged, onHeaderClick, null);
    }

    public GuiAreaDefinition getContentSpace() {
        return new GuiAreaDefinition(this.x() + 3, this.y() + 20, this.width() - 6, this.height() - 20 - 2);
    }

    public void collapse() {
        this.expanded = false;
        this.set_height(20);
        DLUtils.doIfNotNull((Object)this.editBox, a -> {
            a.method_1862(false);
            a.method_25358(this.width() - 5 - 5 - 18 - this.btnX);
        });
        DLUtils.doIfNotNull(this.contentContainer, a -> a.set_visible(false));
        this.onSizeChanged.accept(this);
    }

    public void expand() {
        this.expanded = true;
        DLUtils.doIfNotNull(this.contentContainer, a -> {
            this.set_height(20 + a.height() + 2);
            a.set_visible(true);
        });
        DLUtils.doIfNotNull((Object)this.editBox, a -> a.method_1862(true));
        this.onSizeChanged.accept(this);
    }

    public void notifyContentSizeChanged() {
        DLUtils.doIfNotNull(this.contentContainer, a -> this.set_height(20 + a.height() + 2));
        this.onSizeChanged.accept(this);
    }

    public int getInitialHeight() {
        return 20;
    }

    public class_2561 getText() {
        return this.text;
    }

    public class_2561 getDescription() {
        return this.description;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public T getContentContainer() {
        return this.contentContainer;
    }

    public void setTooltip(List<class_5348> tooltip) {
        this.descriptionTooltips = tooltip;
    }

    public List<class_5348> getTooltips() {
        return this.descriptionTooltips;
    }

    public DLOptionsList getParentList() {
        return this.parentList;
    }

    public class_437 getParentScreen() {
        return this.parent;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.poseStack().method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (this.animator.isRunning()) {
            graphics.poseStack().method_22904(-(50.0 * Math.pow(1.0 - (double)this.animator.getPercentage(), 4.0)), 0.0, 0.0);
        }
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x() + 1, this.y(), this.width() - 2, this.height(), CreateDynamicWidgets.ColorShade.LIGHT);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        DLUtils.doIfNotNull((Object)this.editBox, a -> {
            if (a.visible()) {
                CreateDynamicWidgets.renderTextBox(graphics, this.x() + 1, this.y() + 1, this.width() - 2 - 2 - 20 - this.btnX);
                this.editBox.method_25394(graphics.graphics(), mouseX, mouseY, partialTicks);
            }
        });
        if (this.isExpanded() && this.contentContainer != null) {
            GuiUtils.fillGradient((Graphics)graphics, (int)(this.x() + 3), (int)(this.y() + 20), (int)0, (int)(this.width() - 6), (int)10, (int)0x77000000, (int)0);
        }
        graphics.poseStack().method_22909();
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
        this.tooltips.values().stream().forEach(x -> {
            IDragonLibWidget dlw;
            class_339 patt0$temp = x.getAssignedWidget();
            if (patt0$temp instanceof IDragonLibWidget && (dlw = (IDragonLibWidget)patt0$temp).isMouseSelected()) {
                x.render(this.parent, graphics, mouseX, mouseY);
            }
        });
    }
}

